/*
 * Decompiled with CFR 0.152.
 */
package com.club.framework.util;

import com.club.framework.log.ClubLogManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class MessageResourceUtils {
    private static final ClubLogManager logger = ClubLogManager.getLogger(MessageResourceUtils.class);
    private static Locale locale = Locale.CHINA;
    private static ResourceBundleMessageSource resource = new ResourceBundleMessageSource();
    private static Map<String, String> map = new HashMap<String, String>();

    private MessageResourceUtils() {
    }

    public static String getMessage(String key) {
        String resStr = map.get(key);
        if (StringUtils.isNotEmpty((String)resStr)) {
            return resStr;
        }
        resStr = MessageResourceUtils.getMessage(key, null);
        map.put(key, resStr);
        return resStr;
    }

    public static String getMessage(String key, Object[] args) {
        return MessageResourceUtils.getMessage(key, args, "");
    }

    public static String getMessage(String key, Object[] args, String defaultMessage) {
        return MessageResourceUtils.getMessage(key, args, defaultMessage, locale);
    }

    public static String getMessage(String key, Object[] args, String defaultMessage, Locale locale) {
        return resource.getMessage(key, args, defaultMessage, locale);
    }

    public static void clear() {
        map.clear();
    }

    public static void main(String[] args) {
        System.out.println("begin!!!");
        System.out.println(MessageResourceUtils.getMessage("APP-00-0001"));
        System.out.println(MessageResourceUtils.getMessage("APP-00-0002"));
        System.out.println(MessageResourceUtils.getMessage("APP-00-0003"));
        System.out.println("end!!!");
    }

    static {
        ArrayList<String> baseNames = new ArrayList<String>();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            Resource[] props_resources;
            Resource[] config_resources = resolver.getResources("classpath:config/*.properties");
            Resource[] error_code_resources = resolver.getResources("classpath:config/error_code//*.properties");
            for (Resource resource : props_resources = resolver.getResources("classpath:config/props//*.properties")) {
                baseNames.add("config/props//" + resource.getFilename().substring(0, resource.getFilename().indexOf(".")));
            }
            for (Resource resource : error_code_resources) {
                baseNames.add("config/error_code//" + resource.getFilename().substring(0, resource.getFilename().indexOf(".")));
            }
            for (Resource resource : config_resources) {
                baseNames.add("config/" + resource.getFilename().substring(0, resource.getFilename().indexOf(".")));
            }
        }
        catch (IOException e) {
            logger.error(e);
        }
        resource.setBasenames(baseNames.toArray(new String[1]));
        resource.setDefaultEncoding("UTF-8");
    }
}

