/*
 * Decompiled with CFR 0.152.
 */
package com.club.framework.util;

import com.club.framework.log.ClubLogManager;
import java.util.Properties;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;

public class SendMailUtils {
    private static final ClubLogManager logger = ClubLogManager.getLogger(SendMailUtils.class);
    private String message;
    private JavaMailSender javaMailSender;
    private String sendTo;
    private String sendFrom;

    public String getMessage() {
        return this.message;
    }

    public String getSendTo() {
        return this.sendTo;
    }

    public JavaMailSender getJavaMailSender() {
        return this.javaMailSender;
    }

    public void setJavaMailSender(JavaMailSender javaMailSender) {
        this.javaMailSender = javaMailSender;
    }

    public SendMailUtils() {
    }

    public SendMailUtils(String host, int port, String username, String password) {
        JavaMailSenderImpl javaMailSenderImp = new JavaMailSenderImpl();
        javaMailSenderImp.setHost(host);
        javaMailSenderImp.setPort(port);
        javaMailSenderImp.setUsername(username);
        javaMailSenderImp.setPassword(password);
        Properties props = new Properties();
        props.setProperty("mail.smtp.auth", "true");
        props.setProperty("ssl.SocketFactory.provider", "com.hollycrm.service.ticket.util.DNESSLSocketFactory");
        props.setProperty("mail.smtp.starttls.enable", "true");
        props.setProperty("mail.smtp.timeout", "25000");
        props.setProperty("mail.smtp.localhost", "localHostAdress");
        javaMailSenderImp.setJavaMailProperties(props);
        this.sendFrom = username;
        this.sendTo = username;
        this.javaMailSender = javaMailSenderImp;
    }

    public SendMailUtils(String host, String username, String password) {
        JavaMailSenderImpl javaMailSenderImp = new JavaMailSenderImpl();
        javaMailSenderImp.setHost(host);
        javaMailSenderImp.setUsername(username);
        javaMailSenderImp.setPassword(password);
        Properties props = new Properties();
        props.setProperty("mail.smtp.auth", "true");
        props.setProperty("mail.smtp.starttls.enable", "true");
        props.setProperty("mail.smtp.timeout", "25000");
        props.setProperty("mail.smtp.localhost", "localHostAdress");
        javaMailSenderImp.setJavaMailProperties(props);
        this.sendFrom = username;
        this.sendTo = username;
        this.javaMailSender = javaMailSenderImp;
    }

    public void setSendTo(String sendTo) {
        this.sendTo = sendTo;
    }

    public String getSendFrom() {
        return this.sendFrom;
    }

    public void setSendFrom(String sendFrom) {
        this.sendFrom = sendFrom;
    }

    public Boolean send(String sendSubject, String sendText) {
        SimpleMailMessage mail = new SimpleMailMessage();
        try {
            mail.setTo(this.sendTo);
            mail.setFrom(this.sendFrom);
            mail.setSubject(sendSubject);
            mail.setText(sendText);
            this.javaMailSender.send(mail);
            return true;
        }
        catch (Exception e) {
            logger.error(e);
            this.message = e.getMessage();
            return false;
        }
    }

    public Boolean send(String sendSubject, String sendText, String[] sendToList) {
        SimpleMailMessage mail = new SimpleMailMessage();
        try {
            mail.setFrom(this.sendFrom);
            mail.setSubject(sendSubject);
            mail.setText(sendText);
            for (String sendTo : sendToList) {
                mail.setTo(sendTo);
                this.javaMailSender.send(mail);
            }
            return true;
        }
        catch (Exception e) {
            this.message = e.getMessage();
            return false;
        }
    }

    public static void main(String[] args) {
        SendMailUtils sendMailUtils = new SendMailUtils("smtp.163.com", 25, "username", "password");
        sendMailUtils.send("Test", "\u53d1\u9001\u90ae\u4ef6");
    }
}

