/*
 * Decompiled with CFR 0.152.
 */
package com.club.framework.util;

import com.club.framework.log.ClubLogManager;
import com.club.framework.util.ValidateUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.CharUtils;

public abstract class StringUtils {
    private static final ClubLogManager logger = ClubLogManager.getLogger(StringUtils.class);
    public static String EMPTY = "";

    private StringUtils() {
    }

    public static String toGBK(String val) throws UnsupportedEncodingException {
        return new String(val.getBytes("GBK"));
    }

    public static String toGB2312_ENCODING(String val) throws UnsupportedEncodingException {
        return new String(val.getBytes(), "GB2312");
    }

    public static String toGB2312(String val) throws UnsupportedEncodingException {
        return new String(val.getBytes("GB2312"));
    }

    public static String getISO_8859_1(String val) throws UnsupportedEncodingException {
        return new String(val.getBytes("ISO-8859-1"));
    }

    public static String getGB2312(String val) throws UnsupportedEncodingException {
        return new String(val.getBytes("GB2312"));
    }

    public static String toISO_8859_1(String val) throws UnsupportedEncodingException {
        return new String(val.getBytes(), "ISO-8859-1");
    }

    public static String toUTF_8(String val) throws UnsupportedEncodingException {
        return new String(val.getBytes("UTF-8"));
    }

    public static String encode(String val, String encoding) throws UnsupportedEncodingException {
        if (val == null) {
            return null;
        }
        return new String(val.getBytes(encoding));
    }

    public static String GBKToISO_8859_1(String val) throws UnsupportedEncodingException {
        return StringUtils.encode(val, "GBK", "ISO-8859-1");
    }

    public static String GB2312ToISO_8859_1(String val) throws UnsupportedEncodingException {
        return StringUtils.encode(val, "GB2312", "ISO-8859-1");
    }

    public static String ISO_8859_1ToGB2312(String val) throws UnsupportedEncodingException {
        return StringUtils.encode(val, "ISO-8859-1", "GB2312");
    }

    public static String ISO_8859_1ToGBK(String val) throws UnsupportedEncodingException {
        return StringUtils.encode(val, "ISO-8859-1", "GBK");
    }

    public static String getGBK(String val) {
        try {
            return StringUtils.encode(val, "GBK");
        }
        catch (UnsupportedEncodingException ex) {
            return "";
        }
    }

    public static String encode(String val, String formEncoding, String toEncoding) throws UnsupportedEncodingException {
        if (val == null) {
            return null;
        }
        return new String(val.getBytes(formEncoding), toEncoding);
    }

    public static String getStandardStr(String columnName) {
        columnName = columnName.toLowerCase();
        StringBuffer sb = new StringBuffer();
        StringTokenizer token = new StringTokenizer(columnName, "_");
        int itoken = token.countTokens();
        for (int i = 0; i < itoken; ++i) {
            if (i == 0) {
                sb.append(token.nextToken());
                continue;
            }
            String temp = token.nextToken();
            sb.append(temp.substring(0, 1).toUpperCase());
            sb.append(temp.substring(1));
        }
        return sb.toString();
    }

    public static boolean isEmpty(String val) {
        return val == null || val.length() == 0 || val.equals("null");
    }

    public static boolean isEmpty(Object val) {
        return val == null || val.equals("") || val.equals("null") || val.equals("NULL") || val.toString().toUpperCase().equals("NULL");
    }

    public static boolean isNotEmpty(String val) {
        return val != null && val.trim().length() != 0;
    }

    public static boolean isNotObjectEmpty(Object val) {
        return val != null && val.toString().length() != 0;
    }

    public static String toString(Object val) {
        if (val == null) {
            return "";
        }
        return val.toString();
    }

    public static String toString(Object[] objs) {
        if (objs != null && objs.length > 0) {
            StringBuffer buff = new StringBuffer();
            for (int i = 0; i < objs.length; ++i) {
                buff.append("\nItem[").append(i).append("]\n").append(objs[i]);
            }
            return buff.toString();
        }
        return "";
    }

    public static String toString(int val) {
        return Integer.toString(val);
    }

    public static String toString(float val) {
        return Float.toString(val);
    }

    public static String toString(double val) {
        return Double.toString(val);
    }

    public static String toString(long val) {
        return Long.toString(val);
    }

    public static String toString(short val) {
        return Short.toString(val);
    }

    public static String toString(boolean val) {
        return Boolean.toString(val);
    }

    public static String toCommaString(Long[] longArray) {
        if (longArray == null || longArray.length <= 0) {
            return "";
        }
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < longArray.length; ++i) {
            buff.append(longArray[i]);
            if (i == longArray.length - 1) continue;
            buff.append(",");
        }
        return buff.toString();
    }

    public static String listToString(List<?> list, String itemName) {
        if (!ValidateUtils.validateNotEmpty(list)) {
            return "";
        }
        int size = list.size();
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            buff.append(list.get(i).toString()).append("\n");
        }
        return buff.toString();
    }

    public static String listToString2(List<?> list, String split) {
        if (!ValidateUtils.validateNotEmpty(list)) {
            return "";
        }
        int size = list.size();
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            buff.append(list.get(i).toString()).append(split);
        }
        return buff.substring(0, buff.length() - 1);
    }

    public static String arrayToString(Object[] objs) {
        if (!ValidateUtils.validateNotEmpty(objs)) {
            return "";
        }
        int size = objs.length;
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            buff.append(objs[i].toString()).append("\n");
        }
        return buff.toString();
    }

    public static String[] delRepeatData(ArrayList<String> al) {
        HashSet<String> set = new HashSet<String>(al);
        String[] objs = set.toArray(new String[0]);
        return objs;
    }

    public static String delRepeatData(String str) {
        ArrayList<String> al = new ArrayList<String>();
        StringBuilder dataBuf = new StringBuilder();
        if (str != null && str.length() >= 1) {
            StringTokenizer st = new StringTokenizer(str, ",");
            while (st.hasMoreTokens()) {
                al.add(st.nextToken());
            }
            String[] singleDateArr = StringUtils.delRepeatData(al);
            if (singleDateArr != null) {
                for (int i = 0; i < singleDateArr.length; ++i) {
                    dataBuf.append(singleDateArr[i]);
                    if (i == singleDateArr.length - 1) continue;
                    dataBuf.append(",");
                }
            }
        }
        return dataBuf.toString();
    }

    public static String[] delRepeatData(String[] strArr) {
        ArrayList<String> al = new ArrayList<String>();
        if (strArr != null) {
            for (int i = 0; i < strArr.length; ++i) {
                al.add(strArr[i]);
            }
        }
        String[] singleDateArr = StringUtils.delRepeatData(al);
        return singleDateArr;
    }

    public static Integer[] delRepeatData(Integer[] intArr) {
        ArrayList<Integer> al = new ArrayList<Integer>();
        if (intArr != null) {
            for (int i = 0; i < intArr.length; ++i) {
                al.add(intArr[i]);
            }
        }
        HashSet set = new HashSet(al);
        Integer[] objs = set.toArray(new Integer[0]);
        return objs;
    }

    public static Long[] delRepeatData(Long[] intArr) {
        ArrayList<Long> al = new ArrayList<Long>();
        if (intArr != null) {
            for (int i = 0; i < intArr.length; ++i) {
                al.add(intArr[i]);
            }
        }
        HashSet set = new HashSet(al);
        return set.toArray(new Long[0]);
    }

    public static String format(String pattern, Object ... arguments) {
        return MessageFormat.format(pattern, arguments);
    }

    public static String padLeft(String s, int totalWidth, char paddingChar) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < totalWidth - s.length(); ++i) {
            sb.append(paddingChar);
        }
        sb.append(s);
        return sb.toString();
    }

    public static String padRight(String s, int totalWidth, char paddingChar) {
        StringBuffer sb = new StringBuffer();
        sb.append(s);
        for (int i = 0; i < totalWidth - s.length(); ++i) {
            sb.append(paddingChar);
        }
        return sb.toString();
    }

    public static boolean isNumeric(String str) {
        if (str == null) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String trim(String str) {
        return str == null ? str : str.trim();
    }

    public static Map<String, String> splitPara(String paraSrc, String sepa) {
        if (paraSrc == null || paraSrc.trim().length() == 0) {
            return null;
        }
        LinkedHashMap<String, String> paraMap = new LinkedHashMap<String, String>();
        if (sepa == null || sepa.equals("")) {
            sepa = ",";
        }
        String[] paras = paraSrc.split(sepa);
        String[] tmpResult = null;
        int j = 0;
        for (int i = 0; i < paras.length; ++i) {
            tmpResult = paras[i].split("=");
            if (tmpResult.length >= 2) {
                paraMap.put(tmpResult[0].trim(), tmpResult[1]);
                continue;
            }
            if (tmpResult.length != 1) continue;
            if (paras[i].indexOf("=") >= 0) {
                paraMap.put(tmpResult[0].trim(), "");
                continue;
            }
            paraMap.put("TEXT." + j, paras[i]);
            ++j;
        }
        return paraMap;
    }

    public static String toDBCS(String str) {
        if (str == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            int c = str.charAt(i);
            if (c >= 97 && c <= 122) {
                c = c + 65345 - 97;
            } else if (c >= 65 && c <= 90) {
                c = c + 65313 - 65;
            } else if (c >= 48 && c <= 57) {
                c = c + 65296 - 48;
            }
            sb.append((char)c);
        }
        return sb.toString();
    }

    public static String toSBCS(String str) {
        if (str == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            int c = str.charAt(i);
            if (c >= 65313 && c <= 65338) {
                c = c + 65 - 65313;
            } else if (c >= 65345 && c <= 65370) {
                c = c + 97 - 65345;
            } else if (c >= 65296 && c <= 65305) {
                c = c + 48 - 65296;
            } else if (c == 8221) {
                c = 34;
            } else if (c == 8220) {
                c = 34;
            } else if (c == 65308) {
                c = 60;
            } else if (c == 65310) {
                c = 62;
            } else if (c == 8217) {
                c = 39;
            } else if (c == 8216) {
                c = 39;
            } else if (c == 65292) {
                c = 44;
            } else if (c == 65307) {
                c = 59;
            } else if (c == 12290) {
                c = 46;
            } else if (c == 65286) {
                c = 38;
            }
            sb.append((char)c);
        }
        return sb.toString();
    }

    public static String[] findAll(String src, String pattern) {
        if (src == null) {
            return new String[0];
        }
        if (pattern == null) {
            return new String[0];
        }
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(src);
        ArrayList<String> l = new ArrayList<String>();
        while (m.find()) {
            l.add(m.group());
        }
        return l.toArray(new String[0]);
    }

    public static final String getQryCondtion(String[] conditions, boolean isString) {
        if (conditions == null || conditions.length <= 0) {
            return null;
        }
        StringBuffer cond = new StringBuffer("(");
        for (int i = 0; i < conditions.length; ++i) {
            if (isString) {
                cond.append("'").append(conditions[i]).append("'");
            } else {
                cond.append(conditions[i]);
            }
            cond.append(",");
        }
        cond.replace(cond.length() - 1, cond.length(), ")");
        return cond.toString();
    }

    public static String loadFromCollection(Collection c) {
        StringBuffer sb = new StringBuffer();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString());
        }
        return sb.toString();
    }

    public static String loadFromFile(String filename) throws FileNotFoundException, IOException {
        StringBuffer sb = new StringBuffer();
        byte[] buf = new byte[1024];
        try (FileInputStream in = new FileInputStream(filename);){
            int n;
            do {
                n = in.read(buf);
                sb.append(new String(buf, 0, n));
            } while (n >= 1024);
        }
        return sb.toString();
    }

    public static String loadFromFile(String filename, String encoding) throws FileNotFoundException, IOException {
        StringBuffer sb = new StringBuffer();
        try (BufferedReader b = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), encoding));){
            String s;
            while ((s = b.readLine()) != null) {
                sb.append(s + "\r\n");
            }
        }
        return sb.toString();
    }

    public static String loadFromUrl(String url) throws MalformedURLException, IOException {
        StringBuffer sb = new StringBuffer();
        URL u = new URL(url);
        byte[] buf = new byte[1024];
        try (InputStream in = u.openStream();){
            int n;
            do {
                n = in.read(buf);
                sb.append(new String(buf, 0, n));
            } while (n >= 1024);
        }
        return sb.toString();
    }

    public static String replace(String source, String oldString, String newString) {
        int pos;
        StringBuffer output = new StringBuffer();
        int lengthOfSource = source.length();
        int lengthOfOld = oldString.length();
        int posStart = 0;
        while ((pos = source.indexOf(oldString, posStart)) >= 0) {
            output.append(source.substring(posStart, pos));
            output.append(newString);
            posStart = pos + lengthOfOld;
        }
        if (posStart < lengthOfSource) {
            output.append(source.substring(posStart));
        }
        return output.toString();
    }

    public static String secondSplit(String name, String split) {
        int index;
        if (name == null || name.equals("")) {
            return "";
        }
        if (split == null || split.equals("")) {
            split = ".";
        }
        if ((index = name.indexOf(split)) >= 0) {
            return name.substring(index + split.length());
        }
        return name;
    }

    public static String pathname(String name, String split) {
        int index;
        if (name == null || name.equals("")) {
            return "";
        }
        if (split == null || split.equals("")) {
            split = ".";
        }
        if ((index = name.lastIndexOf(split)) >= 0) {
            return name.substring(0, index);
        }
        return name;
    }

    public static String basename(String name, String split) {
        int index;
        if (name == null || name.equals("")) {
            return "";
        }
        if (split == null || split.equals("")) {
            split = ".";
        }
        if ((index = name.lastIndexOf(split)) >= 0) {
            return name.substring(index + split.length());
        }
        return name;
    }

    public static String firstCharToUpperCase(String src) {
        if (src == null) {
            return null;
        }
        if (src.length() > 0) {
            src = src.substring(0, 1).toUpperCase() + src.substring(1);
        }
        return src;
    }

    public static String throwableToString(Throwable t) {
        StringBuffer sb = new StringBuffer();
        sb.append(t.getClass().getName());
        if (t.getMessage() != null) {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            t.printStackTrace(new PrintStream(bo));
            sb.append(":\r\n\t" + bo.toString());
        }
        return sb.toString();
    }

    public static String long2StringForLen(long num, String str) {
        int len = String.valueOf(num).length();
        if (len > str.length()) {
            return String.valueOf(num).substring(len - str.length(), len);
        }
        return str.substring(0, str.length() - len) + String.valueOf(num);
    }

    public static String objToString(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    public static final String[] split(String line, String separator) {
        LinkedList<String> list = new LinkedList<String>();
        if (line != null) {
            int start = 0;
            int end = 0;
            int separatorLen = separator.length();
            while ((end = line.indexOf(separator, start)) >= 0) {
                list.add(line.substring(start, end));
                start = end + separatorLen;
            }
            if (start < line.length()) {
                list.add(line.substring(start, line.length()));
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public static String splitString(String str, int len, String elide) {
        int elideLen;
        if (str == null) {
            return "";
        }
        byte[] strByte = str.getBytes();
        int strLen = strByte.length;
        int n = elideLen = elide.trim().length() == 0 ? 0 : elide.getBytes().length;
        if (len >= strLen || len < 1) {
            return str;
        }
        if (len - elideLen > 0) {
            len -= elideLen;
        }
        int count = 0;
        for (int i = 0; i < len; ++i) {
            byte value = strByte[i];
            if (value >= 0) continue;
            ++count;
        }
        if (count % 2 != 0) {
            len = len == 1 ? len + 1 : len - 1;
        }
        return new String(strByte, 0, len) + elide.trim();
    }

    public static String getStringDivideByCommaFromList(Object[] inputList, boolean isNeedAddSingleQuote) {
        if (inputList == null || inputList.length == 0) {
            return "";
        }
        String ret = null;
        if (inputList[0] != null) {
            ret = isNeedAddSingleQuote ? "'" + inputList[0].toString() + "'" : inputList[0].toString();
        }
        for (int i = 1; i < inputList.length; ++i) {
            ret = isNeedAddSingleQuote ? ret + ",'" + inputList[i].toString() + "'" : ret + "," + inputList[i].toString();
        }
        return ret;
    }

    public static String getStringFromStream(InputStream is) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = bufferedReader.readLine()) != null) {
            sb.append(line);
        }
        return sb.toString();
    }

    public static String toLowerCaseFirstOne(String s) {
        if (Character.isLowerCase(s.charAt(0))) {
            return s;
        }
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    public static String toUpperCaseFirstOne(String s) {
        if (Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public static String toHump(String str) {
        char[] _strs = str.toLowerCase().toCharArray();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < _strs.length; ++i) {
            char c = _strs[i];
            if (c == '_') {
                if (i == _strs.length - 1) continue;
                c = _strs[++i];
                sb.append(new String(c + "").toUpperCase());
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String toUnderline(String str) {
        char[] charArr = str.toCharArray();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < charArr.length; ++i) {
            char c = charArr[i];
            if (CharUtils.isAsciiAlphaUpper((char)c) && i != 0) {
                sb.append(new String("_" + c).toUpperCase());
                continue;
            }
            sb.append(new String("" + c).toUpperCase());
        }
        return sb.toString();
    }

    public static List<Map<String, Object>> toHump(List<Map<String, Object>> records) {
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> record : records) {
            results.add(StringUtils.toHump(record));
        }
        return results;
    }

    public static Map<String, Object> toHump(Map<String, Object> record) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (record == null) {
            return result;
        }
        for (String key : record.keySet()) {
            if (key.indexOf("_") != -1 || Character.isUpperCase(key.substring(0, 1).charAt(0))) {
                result.put(StringUtils.toHump(key), record.get(key));
                continue;
            }
            result.put(key, record.get(key));
        }
        return result;
    }

    public static String toDBString(String str) {
        char[] _strs = str.toCharArray();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < _strs.length; ++i) {
            char c = _strs[i];
            if (c >= 'A' && c <= 'Z' && i != 0) {
                sb.append("_" + c);
                continue;
            }
            sb.append(new String(c + "").toUpperCase());
        }
        return sb.toString();
    }

    public static String md5(String str) {
        return StringUtils.md5(str, true);
    }

    public static String md5(String str, boolean isUpper) {
        StringBuilder sb = new StringBuilder();
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] array = md.digest(str.getBytes("utf-8"));
            for (int i = 0; i < array.length; ++i) {
                if (isUpper) {
                    sb.append(Integer.toHexString(array[i] & 0xFF | 0x100).toUpperCase().substring(1, 3));
                    continue;
                }
                sb.append(Integer.toHexString(array[i] & 0xFF | 0x100).toLowerCase().substring(1, 3));
            }
            return sb.toString();
        }
        catch (Exception e) {
            logger.error(e);
            return sb.toString();
        }
    }

    public static String random(int n) {
        if (n < 1 || n > 10) {
            throw new IllegalArgumentException("cannot random " + n + " bit number");
        }
        Random ran = new Random();
        if (n == 1) {
            return String.valueOf(ran.nextInt(10));
        }
        int bitField = 0;
        char[] chs = new char[n];
        for (int i = 0; i < n; ++i) {
            int k;
            while ((bitField & 1 << (k = ran.nextInt(10))) != 0) {
            }
            bitField |= 1 << k;
            chs[i] = (char)(k + 48);
        }
        return new String(chs);
    }

    public static String getMD5Str(String str) {
        return StringUtils.md5(str);
    }

    public static void main(String[] args) {
        System.out.println(StringUtils.md5("/msgservice/sms/sendmsg?userId=212558791940096000&mobile=13859924100&content=fuck!bb3J0dwS8FDs6aD1HLKMhHWkYLr3Zarbky"));
    }
}

