/*
 * Decompiled with CFR 0.152.
 */
package com.club.framework.util;

import com.club.core.common.Inflector;

public class TortoiseClassUtils {
    private static final String DTO_FLAG = "DTO";
    private static final String DTO_FLAG2 = "Dto";
    private static final String UNDERLINE_DTO_FLAG = "_DTO";
    private static final String UNDERLINE_DTO_FLAG2 = "_Dto";
    private static final String UNDERLINE_DTO_FLAG3 = "_dto";
    protected static final Inflector INFLECTOR = Inflector.getInstance();

    public static String getEntityNameWithoutDto(String name) {
        if (name.endsWith(UNDERLINE_DTO_FLAG) || name.endsWith(UNDERLINE_DTO_FLAG2) || name.endsWith(UNDERLINE_DTO_FLAG3)) {
            return name.substring(0, name.length() - UNDERLINE_DTO_FLAG.length());
        }
        if (name.endsWith(DTO_FLAG) || name.endsWith(DTO_FLAG2)) {
            return name.substring(0, name.length() - DTO_FLAG.length());
        }
        return name;
    }

    public static String getEntityNameWithoutDto(Class entityClass) {
        return TortoiseClassUtils.getEntityNameWithoutDto(entityClass.getSimpleName());
    }

    public static String getLowerCamelAndSingularize(String name) {
        return INFLECTOR.lowerCamelCase(INFLECTOR.singularize(TortoiseClassUtils.getEntityNameWithoutDto(name)), new char[0]);
    }

    public static String getLowerCamelAndPluralize(String name) {
        return INFLECTOR.lowerCamelCase(INFLECTOR.pluralize(TortoiseClassUtils.getEntityNameWithoutDto(name)), new char[0]);
    }
}

