/*
 * Decompiled with CFR 0.152.
 */
package com.club.framework.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Random;

public final class ValidateUtils {
    private static String randString = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static Random random = new Random();
    private static int width = 120;
    private static int height = 38;
    private static int lineSize = 40;
    private static int stringNum = 4;

    private static Font getFont() {
        return new Font("Fixedsys", 1, 32);
    }

    private static Color getRandColor(int fc, int bc) {
        if (fc > 255) {
            fc = 255;
        }
        if (bc > 255) {
            bc = 255;
        }
        int r = fc + random.nextInt(bc - fc - 16);
        int g = fc + random.nextInt(bc - fc - 14);
        int b = fc + random.nextInt(bc - fc - 18);
        return new Color(r, g, b);
    }

    public static Object[] getRandcode() {
        BufferedImage image = new BufferedImage(width, height, 4);
        Graphics g = image.getGraphics();
        g.setColor(new Color(208, 211, 207));
        g.fillRect(0, 0, width, height);
        g.setFont(new Font("Times New Roman", 0, 32));
        g.setColor(ValidateUtils.getRandColor(110, 133));
        for (int i = 0; i <= lineSize; ++i) {
            ValidateUtils.drowLine(g);
        }
        String randomString = "";
        for (int i = 1; i <= stringNum; ++i) {
            randomString = ValidateUtils.drowString(g, randomString, i);
        }
        g.dispose();
        return new Object[]{randomString, image};
    }

    private static String drowString(Graphics g, String randomString, int i) {
        g.setFont(ValidateUtils.getFont());
        g.setColor(new Color(random.nextInt(255), random.nextInt(111), random.nextInt(121)));
        String rand = String.valueOf(ValidateUtils.getRandomString(random.nextInt(randString.length())));
        randomString = randomString + rand;
        g.translate(random.nextInt(3), random.nextInt(3));
        g.drawString(rand, 22 * i, 28);
        return randomString;
    }

    private static void drowLine(Graphics g) {
        int x = random.nextInt(width);
        int y = random.nextInt(height);
        int xl = random.nextInt(13);
        int yl = random.nextInt(15);
        g.drawLine(x, y, x + xl, y + yl);
    }

    public static String getRandomString(int num) {
        return String.valueOf(randString.charAt(num));
    }

    private ValidateUtils() {
    }

    public static final boolean validateNotNull(String str) {
        return str != null;
    }

    public static final boolean validateNotEmpty(String str) {
        if (ValidateUtils.validateNotNull(str)) {
            return !str.trim().equals("");
        }
        return false;
    }

    public static final boolean validateNotNull(Long l) {
        return l != null;
    }

    public static final boolean validateNotNull(Object o) {
        return o != null;
    }

    public static final boolean validateNotEmpty(Object[] obj) {
        if (ValidateUtils.validateNotNull(obj)) {
            return obj.length != 0;
        }
        return false;
    }

    public static final boolean validateNotEmpty(Collection col) {
        if (ValidateUtils.validateNotNull(col)) {
            return col.size() != 0;
        }
        return false;
    }

    public static void isNull(Object object, String message) {
        if (!ValidateUtils.validateNotNull(object)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isNull(Object object) {
        ValidateUtils.isNull(object, "[Assertion failed] - the object argument must be null");
    }

    public static void notNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notNull(Object object) {
        ValidateUtils.notNull(object, "[Assertion failed] - this argument is required; it cannot be null");
    }

    public static void hasText(String text, String message) {
        if (!ValidateUtils.validateNotEmpty(text)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void hasText(String text) {
        ValidateUtils.hasText(text, "[Assertion failed] - this String argument must have text; it cannot be <code>null</code>, empty, or blank");
    }

    public static void notEmpty(Object[] array, String message) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(String str, String message) {
        if (!ValidateUtils.validateNotEmpty(str)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(Object[] array) {
        ValidateUtils.notEmpty(array, "[Assertion failed] - this array must not be empty: it must contain at least 1 element");
    }

    public static void notEmpty(Collection collection, String message) {
        if (collection == null || collection.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(Collection collection) {
        ValidateUtils.notEmpty(collection, "[Assertion failed] - this collection must not be empty: it must contain at least 1 element");
    }

    public static void state(boolean expression, String message) {
        if (!expression) {
            throw new IllegalStateException(message);
        }
    }

    public static void state(boolean expression) {
        ValidateUtils.state(expression, "[Assertion failed] - this state invariant must be true");
    }

    public static void isFalse(boolean expression, String message) {
        if (expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isTrue(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }
}

