/*
 * Decompiled with CFR 0.152.
 */
package com.club.framework.util;

import com.club.framework.log.ClubLogManager;
import com.club.framework.util.StringUtils;
import com.club.web.common.cache.DBMetaCache;
import com.club.web.common.vo.DBColumn;
import com.club.web.common.vo.DBTable;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ValidformUtils {
    private static final ClubLogManager logger = ClubLogManager.getLogger(ValidformUtils.class);

    public static String defaultLength(String type) {
        if ("INT".equals(type)) {
            return "11";
        }
        if ("VARCHAR".equals(type)) {
            return "255";
        }
        if ("CHAR".equals(type)) {
            return "255";
        }
        if ("TEXT".equals(type)) {
            return "0";
        }
        if ("TINYINT".equals(type)) {
            return "4";
        }
        if ("BIGINT".equals(type)) {
            return "20";
        }
        if ("DOUBLE".equals(type)) {
            return "0";
        }
        if ("BIT".equals(type)) {
            return "1";
        }
        if ("DATETIME".equals(type)) {
            return "0";
        }
        return "1";
    }

    public static void validTable(String tableName, Map<String, Object> record) throws RuntimeException {
        DBTable table = DBMetaCache.getTable(tableName);
        if (table == null) {
            throw new RuntimeException("\u8868\u3010" + tableName + "\u3011\u672a\u627e\u5230\uff01");
        }
        for (String fieldName : record.keySet()) {
            if (table.getColumnMap().containsKey(fieldName)) {
                DBColumn column = table.getColumnMap().get(fieldName);
                if (column.getType().indexOf("pk") != -1) continue;
                if (StringUtils.isEmpty(record.get(fieldName))) {
                    if (!column.getIsNull().equals("0")) continue;
                    throw new RuntimeException("\u8868\u201c" + tableName + "\u201d\u5b57\u6bb5\u3010" + fieldName + "\u3011\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
                }
                if (column.getDbType().toUpperCase().indexOf("CHAR") != -1 && record.get(fieldName).toString().length() >= column.getLength()) {
                    throw new RuntimeException("\u8868\u201c" + tableName + "\u201d\u5b57\u6bb5\u3010" + fieldName + "\u3011\u6700\u957f\u4e0d\u80fd\u8d85\u8fc7" + column.getLength());
                }
                if (column.getDbType().toUpperCase().equals("INT")) {
                    record.put(fieldName, Integer.parseInt(record.get(fieldName) + ""));
                }
                if (column.getDbType().toUpperCase().equals("LONG")) {
                    record.put(fieldName, Long.parseLong(record.get(fieldName) + ""));
                }
                if (!column.getDbType().toUpperCase().equals("Date") || !StringUtils.isEmpty(record.get(fieldName))) continue;
                record.put(fieldName, null);
                continue;
            }
            throw new RuntimeException("\u8868\u201c" + tableName + "\u201d\u4e0d\u5b58\u5728\u5b57\u6bb5\u3010" + fieldName + "\u3011\uff01");
        }
    }

    public static boolean isMobile(String str) {
        Pattern p = null;
        Matcher m = null;
        boolean b = false;
        p = Pattern.compile("^[1][3,4,5,7,8][0-9]{9}$");
        m = p.matcher(str);
        b = m.matches();
        return b;
    }

    public static boolean isPhone(String str) {
        Pattern p1 = null;
        Pattern p2 = null;
        Matcher m = null;
        boolean b = false;
        p1 = Pattern.compile("^[0][1-9]{2,3}?-?[0-9]{5,10}$");
        p2 = Pattern.compile("^[1-9]{1}[0-9]{5,8}$");
        if (str.length() > 9) {
            m = p1.matcher(str);
            b = m.matches();
        } else {
            m = p2.matcher(str);
            b = m.matches();
        }
        return b;
    }
}

