/*
 * Decompiled with CFR 0.152.
 */
package com.club.framework.util;

import com.club.framework.log.ClubLogManager;
import com.thoughtworks.xstream.XStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.simpleframework.xml.core.Persister;

public class XmlUtils {
    private static final ClubLogManager logger = ClubLogManager.getLogger(XmlUtils.class);

    public static String bean2XML(Object bean) {
        XStream xstream = new XStream();
        return xstream.toXML(bean);
    }

    public static String bean2XML(Object bean, Class clazz) {
        XStream xstream = new XStream();
        xstream.aliasPackage("", clazz.getPackage().getName());
        return xstream.toXML(bean);
    }

    public static String beanList2XML(Object bean, Class clazz) {
        XStream xstream = new XStream();
        xstream.setMode(1001);
        xstream.aliasPackage("", clazz.getPackage().getName());
        return xstream.toXML(bean);
    }

    public static String beanList2XML(Object bean) {
        XStream xstream = new XStream();
        xstream.setMode(1001);
        return xstream.toXML(bean);
    }

    public static <T> List<T> xml2BeanList(String xml) {
        XStream xstream = new XStream();
        List ret = (List)xstream.fromXML(xml);
        return ret;
    }

    public static <T> T xml2Bean(String xml) {
        XStream xstream = new XStream();
        Object ret = xstream.fromXML(xml);
        return (T)ret;
    }

    public static String serialize(Object bean) {
        Persister serializer = new Persister();
        try {
            StringWriter writer = new StringWriter();
            serializer.write(bean, (Writer)writer);
            return ((Object)writer).toString();
        }
        catch (Exception e) {
            logger.error(e);
            return "";
        }
    }

    public static Object deserialize(String xml, Class clazz) {
        Persister serializer = new Persister();
        try {
            return serializer.read(clazz, xml);
        }
        catch (Exception e) {
            logger.error(e);
            return null;
        }
    }
}

