/*
 * Decompiled with CFR 0.152.
 */
package com.club.framework.util;

import com.club.framework.log.ClubLogManager;
import com.club.framework.util.Utils;
import com.club.web.common.controller.DownloadController;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

public class ZipCompressor {
    private static final ClubLogManager logger = ClubLogManager.getLogger(DownloadController.class);
    static final int BUFFER = 8192;
    private File zipFile;

    public ZipCompressor(String pathName) {
        this.zipFile = new File(pathName);
    }

    public File getZipFile() {
        return this.zipFile;
    }

    public void compress(List<String> pathName) {
        ZipOutputStream out = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.zipFile);
            CheckedOutputStream cos = new CheckedOutputStream(fileOutputStream, new CRC32());
            out = new ZipOutputStream((OutputStream)cos);
            String basedir = "";
            for (int i = 0; i < pathName.size(); ++i) {
                this.compress(new File(pathName.get(i)), out, basedir);
            }
            out.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void compress(List<String> files, List<String> realNames, String basedir) {
        ZipOutputStream out = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.zipFile);
            CheckedOutputStream cos = new CheckedOutputStream(fileOutputStream, new CRC32());
            out = new ZipOutputStream((OutputStream)cos);
            for (int i = 0; i < files.size(); ++i) {
                this.compressFile2(new File(basedir + files.get(i)), out, realNames.get(i));
            }
            out.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void compress(File file, ZipOutputStream out, String basedir) {
        if (file.isDirectory()) {
            logger.debug("\u538b\u7f29\uff1a" + basedir + file.getName());
            this.compressDirectory(file, out, basedir);
        } else {
            logger.debug("\u538b\u7f29\uff1a" + basedir + file.getName());
            this.compressFile(file, out, basedir);
        }
    }

    private void compressDirectory(File dir, ZipOutputStream out, String basedir) {
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            this.compress(files[i], out, basedir + dir.getName() + "/");
        }
    }

    private void compressFile(File file, ZipOutputStream out, String basedir) {
        if (!file.exists()) {
            return;
        }
        try {
            int count;
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            ZipEntry entry = new ZipEntry(basedir + file.getName());
            out.putNextEntry(entry);
            byte[] data = new byte[8192];
            while ((count = bis.read(data, 0, 8192)) != -1) {
                out.write(data, 0, count);
            }
            bis.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void compressFile2(File file, ZipOutputStream out, String realName) {
        if (!file.exists()) {
            return;
        }
        if (Utils.isEmpty(realName)) {
            realName = file.getName();
        }
        try {
            int count;
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            ZipEntry entry = new ZipEntry(realName);
            out.putNextEntry(entry);
            byte[] data = new byte[8192];
            while ((count = bis.read(data, 0, 8192)) != -1) {
                out.write(data, 0, count);
            }
            bis.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        String s = "192.168.0.1";
        System.out.println(s.split(",")[0]);
    }
}

