/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.alipay.util;

import com.club.web.alipay.config.AlipayConfig;
import com.club.web.alipay.sign.RSA;
import com.club.web.alipay.util.AlipayCore;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class AlipaySubmit {
    private static final String ALIPAY_GATEWAY_NEW = "https://mapi.alipay.com/gateway.do?";

    public static String buildRequestMysign(Map<String, String> sPara) {
        String prestr = AlipayCore.createLinkString(sPara);
        String mysign = "";
        if (AlipayConfig.sign_type.equals("RSA")) {
            mysign = RSA.sign(prestr, AlipayConfig.private_key, AlipayConfig.input_charset);
        }
        return mysign;
    }

    private static Map<String, String> buildRequestPara(Map<String, String> sParaTemp) {
        Map<String, String> sPara = AlipayCore.paraFilter(sParaTemp);
        String mysign = AlipaySubmit.buildRequestMysign(sPara);
        sPara.put("sign", mysign);
        sPara.put("sign_type", AlipayConfig.sign_type);
        return sPara;
    }

    public static String buildRequest(Map<String, String> sParaTemp, String strMethod, String strButtonName) {
        Map<String, String> sPara = AlipaySubmit.buildRequestPara(sParaTemp);
        ArrayList<String> keys = new ArrayList<String>(sPara.keySet());
        StringBuffer sbHtml = new StringBuffer();
        sbHtml.append("<form id=\"alipaysubmit\" name=\"alipaysubmit\" action=\"https://mapi.alipay.com/gateway.do?_input_charset=" + AlipayConfig.input_charset + "\" method=\"" + strMethod + "\">");
        for (int i = 0; i < keys.size(); ++i) {
            String name = (String)keys.get(i);
            String value = sPara.get(name);
            sbHtml.append("<input type=\"hidden\" name=\"" + name + "\" value=\"" + value + "\"/>");
        }
        sbHtml.append("<input type=\"submit\" value=\"" + strButtonName + "\" style=\"display:none;\"></form>");
        sbHtml.append("<script>document.forms['alipaysubmit'].submit();</script>");
        return sbHtml.toString();
    }

    public static String query_timestamp() throws MalformedURLException, DocumentException, IOException {
        String strUrl = "https://mapi.alipay.com/gateway.do?service=query_timestamp&partner=" + AlipayConfig.partner + "&_input_charset" + AlipayConfig.input_charset;
        StringBuffer result = new StringBuffer();
        SAXReader reader = new SAXReader();
        Document doc = reader.read(new URL(strUrl).openStream());
        List nodeList = doc.selectNodes("//alipay/*");
        for (Node node : nodeList) {
            if (!node.getName().equals("is_success") || !node.getText().equals("T")) continue;
            List nodeList1 = doc.selectNodes("//response/timestamp/*");
            for (Node node1 : nodeList1) {
                result.append(node1.getText());
            }
        }
        return result.toString();
    }
}

