/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.client.controller;

import com.club.core.common.Page;
import com.club.framework.exception.BaseAppException;
import com.club.framework.util.JsonUtil;
import com.club.framework.util.StringUtils;
import com.club.web.client.service.StaffService;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/staffManager"})
public class StaffController {
    private Logger logger = LoggerFactory.getLogger(StaffController.class);
    @Autowired
    private StaffService staffService;

    @RequestMapping(value={"/staffPage"})
    @ResponseBody
    public Page<Map<String, Object>> staffPage(Page<Map<String, Object>> page, String conditionStr) throws BaseAppException {
        this.logger.debug("staffPage ");
        if (conditionStr != null) {
            page.setConditons(JsonUtil.toMap(conditionStr));
        }
        Map<String, Object> conditions = page.getConditons();
        conditions.put("start", page.getStart());
        conditions.put("limit", page.getLimit());
        return this.staffService.selectPage(conditions);
    }

    @RequestMapping(value={"/save"})
    @ResponseBody
    public Map<String, Object> save(@RequestParam(value="params") String params) {
        this.logger.debug("save staff. ");
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            HashMap<String, Object> paramsMap = new HashMap<String, Object>();
            if (params != null) {
                paramsMap.putAll(JsonUtil.toMap(params));
            }
            this.staffService.save(paramsMap);
            result.put("code", 1);
            result.put("msg", "\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            result.put("code", 0);
            result.put("msg", "\u4fdd\u5b58\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public Map<String, Object> delete(@RequestParam(value="params") String params) {
        this.logger.debug("save staff. ");
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            String[] ids = new String[]{};
            if (StringUtils.isNotEmpty(params)) {
                ids = params.split(",");
            }
            this.staffService.delete(ids);
            result.put("code", 1);
            result.put("msg", "\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            result.put("code", 0);
            result.put("msg", "\u5220\u9664\u5931\u8d25");
        }
        return result;
    }
}

