/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.common.cache;

import com.club.framework.util.Utils;
import com.club.web.common.db.arg.CodeValueArg;
import com.club.web.common.db.dao.CodeValueDao;
import com.club.web.common.db.po.CodeValuePO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class CodeValueCache {
    @Autowired
    private CodeValueDao codeValueDao;
    private static Map<String, List<CodeValuePO>> codeValues = new HashMap<String, List<CodeValuePO>>();
    private static Map<String, String> codeValueNames = new HashMap<String, String>();

    public static String findCodeName(String codeType, String codeValue) {
        StringBuffer sb = new StringBuffer();
        sb.append(codeType).append("_").append(codeValue);
        return codeValueNames.get(sb.toString());
    }

    public static List<CodeValuePO> findCodeValues(String codeType) {
        return codeValues.get(codeType);
    }

    public void init() {
        this.iniCodeValue(null);
    }

    public void refresh(String codeType) {
        if (Utils.isEmpty(codeType)) {
            codeValues.clear();
        } else {
            codeValues.get(codeType).clear();
        }
        this.iniCodeValue(codeType);
    }

    public void iniCodeValue(String codeType) {
        CodeValueArg arg = new CodeValueArg();
        CodeValueArg.CodeValueCriteria criteria = arg.createCriteria();
        if (Utils.notEmpty(codeType)) {
            criteria.andCodeTypeEqualTo(codeType);
        }
        criteria.andStateEqualTo("00A");
        List<CodeValuePO> datas = this.codeValueDao.selectByArg(arg);
        if (Utils.notEmpty(datas)) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < datas.size(); ++i) {
                sb.setLength(0);
                CodeValuePO po = datas.get(i);
                sb.append(po.getCodeType()).append("_").append(po.getCodeValue());
                List<CodeValuePO> list = codeValues.get(po.getCodeType());
                if (list == null) {
                    list = new ArrayList<CodeValuePO>();
                    codeValues.put(po.getCodeType(), list);
                }
                list.add(po);
                codeValueNames.put(sb.toString(), po.getCodeName());
            }
        }
    }
}

