/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.common.controller;

import com.club.core.common.Page;
import com.club.core.common.TreeNode;
import com.club.core.common.TreePO;
import com.club.core.common.TreeQueryPO;
import com.club.core.spring.context.SpringApplicationContextHolder;
import com.club.framework.exception.BaseAppException;
import com.club.framework.log.ClubLogManager;
import com.club.framework.util.DBUtils;
import com.club.framework.util.JsonUtil;
import com.club.framework.util.StringUtils;
import com.club.framework.util.ValidateUtils;
import com.club.web.common.cache.CodeValueCache;
import com.club.web.common.cache.DBMetaCache;
import com.club.web.common.db.po.CodeValuePO;
import com.club.web.common.service.IBaseService;
import com.club.web.common.vo.DBColumn;
import com.club.web.common.vo.DBTable;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/base"})
public class BaseController {
    public static final String RANDOMCODEKEY = "RANDOMVALIDATECODEKEY";
    private static final ClubLogManager logger = ClubLogManager.getLogger(BaseController.class);
    @Value(value="#{propertyConfigurer.ctxPropertiesMap['framework.jdbc.driverClassName']}")
    private String driver;
    @Value(value="#{propertyConfigurer.ctxPropertiesMap['framework.jdbc.url']}")
    private String url;
    @Value(value="#{propertyConfigurer.ctxPropertiesMap['framework.jdbc.username']}")
    private String username;
    @Value(value="#{propertyConfigurer.ctxPropertiesMap['framework.jdbc.password']}")
    private String password;
    @Autowired
    private IBaseService baseService;

    @RequestMapping(value={"getList"})
    @ResponseBody
    public List<?> getList(String tableName, String conditionsKey) throws BaseAppException {
        Map<String, Object> conditions = StringUtils.isEmpty(conditionsKey) ? new HashMap<String, Object>() : JsonUtil.toMap(conditionsKey);
        List<Map<String, Object>> list = this.baseService.selectList(tableName, conditions);
        return list;
    }

    @RequestMapping(value={"getPage"})
    @ResponseBody
    public Page<?> getPage(String tableName, String conditionsKey) throws BaseAppException {
        Map<String, Object> conditions = StringUtils.isEmpty(conditionsKey) ? new HashMap<String, Object>() : JsonUtil.toMap(conditionsKey);
        Page<Map<String, Object>> list = this.baseService.selectPage(tableName, conditions);
        return list;
    }

    @RequestMapping(value={"tableInfo/{tableName}"})
    @ResponseBody
    public DBTable tableInfo(@PathVariable String tableName) throws BaseAppException {
        DBTable dbtable = DBUtils.getTalbe(tableName.toUpperCase());
        DBTable table = new DBTable();
        table.setTableName(dbtable.getTableName());
        table.setRemarks(dbtable.getRemarks());
        table.setPks(dbtable.getPks());
        table.setFks(dbtable.getFks());
        ArrayList<DBColumn> columns = new ArrayList<DBColumn>();
        for (DBColumn column : dbtable.getColumns()) {
            DBColumn c = new DBColumn();
            c.setColumnName(StringUtils.toHump(column.getColumnName()));
            c.setDbType(column.getDbType());
            c.setDisplayName(column.getDisplayName());
            c.setType(column.getType());
            c.setIsNull(column.getIsNull());
            c.setLength(column.getLength());
            columns.add(c);
        }
        table.setColumns(columns);
        return table;
    }

    @RequestMapping(value={"proxy"})
    public void proxy(String strURL, HttpServletResponse response) {
        try {
            String temp;
            PrintWriter writer = response.getWriter();
            URL url = new URL(strURL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            InputStreamReader isr = new InputStreamReader(conn.getInputStream());
            BufferedReader br = new BufferedReader(isr);
            int i = 0;
            while ((temp = br.readLine()) != null) {
                if (i++ == 6) {
                    ((Writer)writer).append("<meta http-equiv=\"Access-Control-Allow-Origin\" content=\"*\" />");
                }
                ((Writer)writer).append(temp + "\n");
            }
            br.close();
            isr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"testDBConnection"})
    @ResponseBody
    public Map<String, Object> testDBConnection(String driver, String dbName, String characterEncoding, String ip, String port, String params, String username, String password) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            result.put("success", true);
            result.put("message", this.baseService.testDBConnection(driver, dbName, characterEncoding, ip, port, params, username, password));
        }
        catch (Exception e) {
            e.printStackTrace();
            result.put("success", false);
            result.put("message", e.getMessage() + e.toString());
        }
        return result;
    }

    @RequestMapping(value={"loadDBMeta"})
    @ResponseBody
    public Map<String, Object> loadDBMeta() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            result.put("success", true);
            result.put("message", DBMetaCache.getMeta(true));
        }
        catch (Exception e) {
            e.printStackTrace();
            result.put("success", false);
            result.put("message", e.getMessage() + e.toString());
        }
        return result;
    }

    @RequestMapping(value={"saveDBMeta"})
    @ResponseBody
    public Map<String, Object> saveDBMeta(String driver, String dbName, String characterEncoding, String ip, String port, String params, String username, String password) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            result.put("success", true);
            if (driver == null || driver.isEmpty()) {
                this.baseService.saveDBMeta(this.driver, this.url, this.username, this.password);
            }
            result.put("message", this.baseService.saveDBMeta(driver, dbName, characterEncoding, ip, port, params, username, password));
        }
        catch (Exception e) {
            e.printStackTrace();
            result.put("success", false);
            result.put("message", e.getMessage() + e.toString());
        }
        return result;
    }

    @RequestMapping(value={"randCodeImage"})
    public void randCodeImage(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession();
        Object[] results = ValidateUtils.getRandcode();
        session.removeAttribute(RANDOMCODEKEY);
        session.setAttribute(RANDOMCODEKEY, results[0]);
        try {
            ImageIO.write((RenderedImage)results[1], "JPEG", (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getfFileToClient(HttpServletResponse response, String pic_path) throws IOException {
        FileInputStream is = new FileInputStream(pic_path);
        int i = is.available();
        byte[] data = new byte[i];
        is.read(data);
        is.close();
        response.setContentType("image/png");
        ServletOutputStream toClient = response.getOutputStream();
        toClient.write(data);
        toClient.close();
    }

    @RequestMapping(value={"showImage"})
    public void showImage(HttpServletResponse response, HttpServletRequest request) throws UnsupportedEncodingException, IOException {
        String fullPath = request.getParameter("fullPath");
        if (StringUtils.isEmpty(fullPath)) {
            response.sendError(405, "filePath is null!");
            return;
        }
        fullPath = request.getSession().getServletContext().getRealPath("/") + fullPath;
        try {
            this.getfFileToClient(response, fullPath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"getGeneralTree"})
    @ResponseBody
    public TreeNode getGeneralTree(String paramMap, String node) {
        String iconStr;
        String unChangeParamStr;
        TreePO params = JsonUtil.toBean(paramMap, TreePO.class);
        Map<String, Object> data = JsonUtil.toMap(paramMap);
        String valueField = data.get("valueField").toString();
        if (StringUtils.isEmpty(params.getDeep())) {
            params.setDeep(10);
        }
        Object rootId = data.get("rootId");
        data.put(valueField, rootId);
        if (!StringUtils.isEmpty(node)) {
            data.put(valueField, node);
        }
        if (!StringUtils.isEmpty(unChangeParamStr = params.getUnChangeParamStr())) {
            String[] temp = unChangeParamStr.split(",");
            HashMap<String, Object> paramData = new HashMap<String, Object>();
            for (int i = 0; i < temp.length; ++i) {
                paramData.put(temp[i], data.get(temp[i]));
            }
            params.setParamData(paramData);
        }
        if (!StringUtils.isEmpty(iconStr = params.getIconStr())) {
            params.setIcons(iconStr.split(","));
        } else {
            params.setIcons(new String[0]);
        }
        TreeNode tree = this.baseService.getTreeAllData(params, data, 0);
        return tree;
    }

    @RequestMapping(value={"queryTree"})
    @ResponseBody
    public TreeNode queryTree(TreeQueryPO reqDto) {
        return this.baseService.queryTree(reqDto);
    }

    @RequestMapping(value={"getDataList"})
    @ResponseBody
    public List<Map<String, Object>> getDataList(String sqlKey, String paramMap) {
        Map<String, Object> params = JsonUtil.toMap(paramMap);
        return this.baseService.selectList2(sqlKey, params);
    }

    @RequestMapping(value={"getCodeValues"})
    @ResponseBody
    public List<CodeValuePO> getCodeValues(String codeType) throws BaseAppException {
        return CodeValueCache.findCodeValues(codeType);
    }

    @RequestMapping(value={"refreshCodeValues"})
    @ResponseBody
    public void refreshCodeValues(String codeType) throws BaseAppException {
        CodeValueCache cache = SpringApplicationContextHolder.getBean(CodeValueCache.class);
        cache.refresh(codeType);
    }
}

