/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.common.controller;

import com.club.core.spring.context.CustomPropertyConfigurer;
import com.club.framework.log.ClubLogManager;
import com.club.framework.util.StringUtils;
import com.club.framework.util.ZipCompressor;
import com.club.web.common.Configuration;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.activation.MimetypesFileTypeMap;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.imgscalr.Scalr;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.support.DefaultMultipartHttpServletRequest;

@Controller
public class DownloadController {
    private static final ClubLogManager logger = ClubLogManager.getLogger(DownloadController.class);

    @RequestMapping(value={"download"})
    public void sendRedirect(HttpServletRequest request, HttpServletResponse response) throws IOException {
        File resultFile = null;
        request.setCharacterEncoding("UTF-8");
        response.setCharacterEncoding("UTF-8");
        String fileName = request.getParameter("fileName");
        String filePath = request.getParameter("filePath");
        String fullPath = request.getParameter("fullPath");
        String multiFile = request.getParameter("multiFile");
        boolean needZip = false;
        String basePath = "";
        if (StringUtils.isNotEmpty(multiFile)) {
            needZip = true;
        }
        if (StringUtils.isNotEmpty(fullPath)) {
            basePath = request.getSession().getServletContext().getRealPath("/");
            filePath = fullPath;
        } else {
            basePath = Configuration.getString("uploadPath");
        }
        if (StringUtils.isEmpty(filePath)) {
            response.sendError(405, "filePath is null!");
            logger.error("\u4e0b\u8f7d\u5931\u8d25\uff01filePath and fileName is null");
            return;
        }
        if (StringUtils.isEmpty(fileName)) {
            response.sendError(405, "fileName is null!");
            logger.error("\u4e0b\u8f7d\u5931\u8d25\uff01fileName is null");
            return;
        }
        fileName = new String(fileName.getBytes("iso-8859-1"), "utf-8");
        resultFile = this.getFile(basePath, filePath, fileName, needZip);
        if (needZip) {
            fileName = resultFile.getName();
        }
        logger.info("start download fileName {0}  ,  filePath  {1}", (Object)fileName, (Object)filePath);
        FileInputStream resultFileFi = new FileInputStream(resultFile);
        long l = resultFile.length();
        int k = 0;
        byte[] abyte0 = new byte[65000];
        response.setContentType("application/x-msdownload");
        response.setContentLength((int)l);
        response.setHeader("Content-Disposition", "attachment; filename=" + new String(fileName.getBytes("GBK"), "ISO8859-1"));
        while ((long)k < l) {
            int j = resultFileFi.read(abyte0, 0, 65000);
            k += j;
            response.getOutputStream().write(abyte0, 0, j);
        }
        resultFileFi.close();
        if (needZip) {
            resultFile.delete();
        }
    }

    private File getFile(String basePath, String filePath, String fileName, boolean needZip) {
        File resultFile = null;
        if (needZip) {
            List<String> files = Arrays.asList(filePath.split(","));
            List<String> realNames = Arrays.asList(fileName.split(","));
            String zipFileName = realNames.get(0);
            zipFileName = zipFileName.substring(0, zipFileName.lastIndexOf(".")) + "\u7b49.zip";
            ZipCompressor zc = new ZipCompressor(basePath + zipFileName);
            zc.compress(files, realNames, basePath);
            resultFile = zc.getZipFile();
        } else {
            resultFile = new File(basePath + filePath);
        }
        return resultFile;
    }

    @RequestMapping(value={"/upload"}, method={RequestMethod.GET})
    public void getfile(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String iconPath = CustomPropertyConfigurer.getContextProperty("uploadPath").toString() + "icons/";
        if (request.getParameter("getfile") != null && !request.getParameter("getfile").isEmpty()) {
            File file = new File(iconPath, request.getParameter("getfile"));
            if (file.exists()) {
                int bytes = 0;
                ServletOutputStream op = response.getOutputStream();
                response.setContentType(this.getMimeType(file));
                response.setContentLength((int)file.length());
                response.setHeader("Content-Disposition", "inline; filename=\"" + file.getName() + "\"");
                byte[] bbuf = new byte[1024];
                DataInputStream in = new DataInputStream(new FileInputStream(file));
                while (in != null && (bytes = in.read(bbuf)) != -1) {
                    op.write(bbuf, 0, bytes);
                }
                in.close();
                op.flush();
                op.close();
            }
        } else if (request.getParameter("delfile") != null && !request.getParameter("delfile").isEmpty()) {
            File file = new File(iconPath, request.getParameter("delfile"));
            if (file.exists()) {
                file.delete();
            }
        } else if (request.getParameter("getthumb") != null && !request.getParameter("getthumb").isEmpty()) {
            File file = new File(iconPath, request.getParameter("getthumb"));
            if (file.exists()) {
                BufferedImage im;
                String mimetype = this.getMimeType(file);
                if ((mimetype.endsWith("png") || mimetype.endsWith("jpeg") || mimetype.endsWith("gif")) && (im = ImageIO.read(file)) != null) {
                    int size = 200;
                    int width = 0;
                    int height = 0;
                    if (request.getParameter("size") != null) {
                        size = Integer.parseInt(request.getParameter("size"));
                    }
                    if (request.getParameter("width") != null) {
                        width = Integer.parseInt(request.getParameter("width"));
                    }
                    if (request.getParameter("height") != null) {
                        height = Integer.parseInt(request.getParameter("height"));
                    }
                    BufferedImage thumb = width != 0 && height != 0 ? Scalr.resize((BufferedImage)im, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[0]) : (width != 0 ? Scalr.resize((BufferedImage)im, (Scalr.Method)Scalr.Method.AUTOMATIC, (Scalr.Mode)Scalr.Mode.FIT_TO_WIDTH, (int)width, (BufferedImageOp[])new BufferedImageOp[0]) : (height != 0 ? Scalr.resize((BufferedImage)im, (Scalr.Method)Scalr.Method.AUTOMATIC, (Scalr.Mode)Scalr.Mode.FIT_TO_HEIGHT, (int)height, (BufferedImageOp[])new BufferedImageOp[0]) : Scalr.resize((BufferedImage)im, (int)size, (BufferedImageOp[])new BufferedImageOp[0])));
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    if (mimetype.endsWith("png")) {
                        ImageIO.write((RenderedImage)thumb, "PNG", os);
                        response.setContentType("image/png");
                    } else if (mimetype.endsWith("jpeg")) {
                        ImageIO.write((RenderedImage)thumb, "jpg", os);
                        response.setContentType("image/jpeg");
                    } else {
                        ImageIO.write((RenderedImage)thumb, "GIF", os);
                        response.setContentType("image/gif");
                    }
                    ServletOutputStream srvos = response.getOutputStream();
                    response.setContentLength(os.size());
                    response.setHeader("Content-Disposition", "inline; filename=\"" + file.getName() + "\"");
                    os.writeTo((OutputStream)srvos);
                    srvos.flush();
                    srvos.close();
                }
            } else {
                response.sendRedirect("image/user5-128x128.jpg");
            }
        } else {
            PrintWriter writer = response.getWriter();
            writer.write("call POST with multipart form data");
        }
    }

    @RequestMapping(value={"/upload"}, method={RequestMethod.POST})
    @ResponseBody
    public List<Object> fileUpload(DefaultMultipartHttpServletRequest request) throws IOException {
        ArrayList<Object> rs = new ArrayList<Object>();
        try {
            String iconPath = CustomPropertyConfigurer.getContextProperty("uploadPath").toString() + "icons/";
            File f = new File(iconPath);
            if (!f.exists()) {
                f.mkdirs();
            }
            long iconNameTime = System.currentTimeMillis();
            Iterator iter = request.getFileNames();
            while (iter.hasNext()) {
                String fileName = (String)iter.next();
                String iconName = request.getFile(fileName).getOriginalFilename();
                String iconNames = iconName.substring(iconName.lastIndexOf("."));
                iconName = iconNameTime + iconNames;
                FileOutputStream os = new FileOutputStream(iconPath + iconName);
                InputStream in = request.getFile(fileName).getInputStream();
                int b = 0;
                while ((b = in.read()) != -1) {
                    os.write(b);
                }
                os.flush();
                in.close();
                os.close();
                String hashFileName = URLEncoder.encode(iconName, "UTF-8");
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("name", hashFileName);
                result.put("size", request.getFile(fileName).getSize());
                result.put("url", "upload.do?getfile=" + hashFileName);
                result.put("thumbnail_url", "upload.do?getthumb=" + hashFileName);
                result.put("delete_url", "upload.do?delfile=" + hashFileName);
                result.put("delete_type", "GET");
                rs.add(result);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return rs;
    }

    public String getMimeType(File file) {
        String mimetype = "";
        if (file.exists()) {
            if (this.getSuffix(file.getName()).equalsIgnoreCase("png")) {
                mimetype = "image/png";
            } else {
                MimetypesFileTypeMap mtMap = new MimetypesFileTypeMap();
                mimetype = mtMap.getContentType(file);
            }
        }
        return mimetype;
    }

    private String getSuffix(String filename) {
        String suffix = "";
        int pos = filename.lastIndexOf(46);
        if (pos > 0 && pos < filename.length() - 1) {
            suffix = filename.substring(pos + 1);
        }
        return suffix;
    }
}

