/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.common.domain.repository.impl;

import com.club.core.common.Page;
import com.club.core.db.dao.BaseDao;
import com.club.core.spring.context.SpringApplicationContextHolder;
import com.club.framework.exception.BaseAppException;
import com.club.framework.exception.ExceptionHandler;
import com.club.framework.util.BeanUtils;
import com.club.framework.util.DBUtils;
import com.club.framework.util.StringUtils;
import com.club.framework.util.Utils;
import com.club.web.common.cache.DBMetaCache;
import com.club.web.common.domain.repository.IBaseRepository;
import com.club.web.common.vo.BaseVo;
import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseRepositoryImpl
implements IBaseRepository {
    private Logger logger = LoggerFactory.getLogger(BaseRepositoryImpl.class);
    private String tableName;
    @Autowired
    private BaseDao baseDao;

    public BaseRepositoryImpl(String tableName) {
        this.tableName = tableName;
    }

    public BaseRepositoryImpl() {
        String className = this.getClass().getSimpleName();
        String humpName = className.replace("RepositoryImpl", "");
        this.tableName = StringUtils.toUnderline(humpName);
        this.logger.info("{} convert tableName:{}", (Object)className, (Object)this.tableName);
    }

    @Override
    public Integer selectCount(BaseVo paramsBean) throws BaseAppException {
        Map<String, Object> paramsMap = null;
        try {
            paramsMap = BeanUtils.convertBeanNotNull(paramsBean);
            return this.selectCount(paramsMap);
        }
        catch (IntrospectionException e) {
            ExceptionHandler.publish("APP-00-0051", "\u8f6c\u6362\u7c7b\u5c5e\u6027\u5931\u8d25");
        }
        catch (IllegalAccessException e) {
            ExceptionHandler.publish("APP-00-0051", "\u5b9e\u4f8b\u5316JavaBean\u5931\u8d25");
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.publish("APP-00-0051", "\u8c03\u7528\u5c5e\u6027\u7684setter\u65b9\u6cd5\u5931\u8d25");
        }
        return null;
    }

    @Override
    public Integer selectCount(Map<String, Object> paramsMap) throws BaseAppException {
        return this.selectMapCount(paramsMap);
    }

    @Override
    public <T> Page<T> selectPageList(BaseVo paramsBean, Class<T> clazz) throws BaseAppException {
        Map<String, Object> paramsMap = null;
        try {
            paramsMap = BeanUtils.convertBeanNotNull(paramsBean);
            return this.selectMapPageList(paramsMap, clazz);
        }
        catch (IntrospectionException e) {
            ExceptionHandler.publish("APP-00-0051", "\u8f6c\u6362\u7c7b\u5c5e\u6027\u5931\u8d25");
        }
        catch (IllegalAccessException e) {
            ExceptionHandler.publish("APP-00-0051", "\u5b9e\u4f8b\u5316JavaBean\u5931\u8d25");
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.publish("APP-00-0051", "\u8c03\u7528\u5c5e\u6027\u7684setter\u65b9\u6cd5\u5931\u8d25");
        }
        return null;
    }

    @Override
    public <T> Page<T> selectPageList(Map<String, Object> paramsMap, Class<T> clazz) throws BaseAppException {
        return this.selectMapPageList(paramsMap, clazz);
    }

    @Override
    public <T> List<T> selectList(BaseVo paramsBean, Class<T> clazz) throws BaseAppException {
        try {
            Map<String, Object> paramsMap = BeanUtils.convertBeanNotNull(paramsBean);
            String sql = this.getSelectListSql(paramsMap);
            if (Utils.isEmpty(sql)) {
                return null;
            }
            paramsMap.put("sql", sql);
            List<Map<String, Object>> list = this.baseDao.selectList(paramsMap);
            if (list == null || list.isEmpty()) {
                return null;
            }
            list = StringUtils.toHump(list);
            ArrayList<T> returnList = new ArrayList<T>(list.size());
            for (Map<String, Object> returnMap : list) {
                returnList.add(BeanUtils.copy(returnMap, clazz));
            }
            return returnList;
        }
        catch (IntrospectionException e) {
            ExceptionHandler.publish("APP-00-0051", "\u8f6c\u6362\u7c7b\u5c5e\u6027\u5931\u8d25");
        }
        catch (IllegalAccessException e) {
            ExceptionHandler.publish("APP-00-0051", "\u5b9e\u4f8b\u5316JavaBean\u5931\u8d25");
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.publish("APP-00-0051", "\u8c03\u7528\u5c5e\u6027\u7684setter\u65b9\u6cd5\u5931\u8d25");
        }
        return null;
    }

    @Override
    public List<Map<String, Object>> selectList(Map<String, Object> paramsMap) throws BaseAppException {
        String sql = this.getSelectListSql(paramsMap);
        if (Utils.isEmpty(sql)) {
            return null;
        }
        paramsMap.put("sql", sql);
        return StringUtils.toHump(this.baseDao.selectList(paramsMap));
    }

    @Override
    public <T> T selectOne(BaseVo record, Class<T> clazz) throws BaseAppException {
        try {
            Map<String, Object> paramsMap = BeanUtils.convertBeanNotNull(record);
            String sql = this.getSelectListSql(paramsMap);
            Map<String, Object> returnMap = this.baseDao.selectOne(sql, paramsMap);
            if (StringUtils.isEmpty(returnMap)) {
                return null;
            }
            return BeanUtils.copy(StringUtils.toHump(returnMap), clazz);
        }
        catch (IntrospectionException e) {
            ExceptionHandler.publish("APP-00-0051", "\u8f6c\u6362\u7c7b\u5c5e\u6027\u5931\u8d25");
        }
        catch (IllegalAccessException e) {
            ExceptionHandler.publish("APP-00-0051", "\u5b9e\u4f8b\u5316JavaBean\u5931\u8d25");
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.publish("APP-00-0051", "\u8c03\u7528\u5c5e\u6027\u7684setter\u65b9\u6cd5\u5931\u8d25");
        }
        return null;
    }

    @Override
    public Map<String, Object> selectOne(Map<String, Object> paramsMap) throws BaseAppException {
        String sql = this.getSelectListSql(paramsMap);
        Map<String, Object> returnMap = this.baseDao.selectOne(sql, paramsMap);
        return returnMap;
    }

    @Override
    public <T> int insert(T record) throws BaseAppException {
        try {
            Map<String, Object> keyValues = BeanUtils.convertBeanNotNull(record);
            String sql = DBUtils.getInsertTableSql(this.tableName, keyValues);
            keyValues.put("sql", sql);
            this.baseDao.insertNew(keyValues);
            return 1;
        }
        catch (IntrospectionException e) {
            ExceptionHandler.publish("APP-00-0051", "\u8f6c\u6362\u7c7b\u5c5e\u6027\u5931\u8d25");
        }
        catch (IllegalAccessException e) {
            ExceptionHandler.publish("APP-00-0051", "\u5b9e\u4f8b\u5316JavaBean\u5931\u8d25");
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.publish("APP-00-0051", "\u8c03\u7528\u5c5e\u6027\u7684setter\u65b9\u6cd5\u5931\u8d25");
        }
        return 0;
    }

    @Override
    public <T> int update(T record) throws BaseAppException {
        try {
            Map<String, Object> keyValues = BeanUtils.convertBeanNotNull(record);
            keyValues.put("sql", DBUtils.getUpdateTableSql(this.tableName, keyValues));
            this.baseDao.update(keyValues);
            return 1;
        }
        catch (IntrospectionException e) {
            ExceptionHandler.publish("APP-00-0051", "\u8f6c\u6362\u7c7b\u5c5e\u6027\u5931\u8d25");
        }
        catch (IllegalAccessException e) {
            ExceptionHandler.publish("APP-00-0051", "\u5b9e\u4f8b\u5316JavaBean\u5931\u8d25");
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.publish("APP-00-0051", "\u8c03\u7528\u5c5e\u6027\u7684setter\u65b9\u6cd5\u5931\u8d25");
        }
        return 0;
    }

    @Override
    public <T> int delete(T record) throws BaseAppException {
        try {
            Map<String, Object> keyValues = BeanUtils.convertBeanNotNull(record);
            keyValues.put("sql", DBUtils.getDeleteSql(this.tableName));
            this.baseDao.delete(keyValues);
            return 1;
        }
        catch (IntrospectionException e) {
            ExceptionHandler.publish("APP-00-0051", "\u8f6c\u6362\u7c7b\u5c5e\u6027\u5931\u8d25");
        }
        catch (IllegalAccessException e) {
            ExceptionHandler.publish("APP-00-0051", "\u5b9e\u4f8b\u5316JavaBean\u5931\u8d25");
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.publish("APP-00-0051", "\u8c03\u7528\u5c5e\u6027\u7684setter\u65b9\u6cd5\u5931\u8d25");
        }
        return 0;
    }

    @Override
    public int delete(String id) throws BaseAppException {
        DBMetaCache dbMetaCache = SpringApplicationContextHolder.getBean(DBMetaCache.class);
        String pkColumnName = DBMetaCache.getTable(this.tableName).getPks().get(0);
        String sql = DBUtils.getDeleteSql(this.tableName);
        Map<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("sql", sql);
        paramsMap.put(pkColumnName, id);
        paramsMap = StringUtils.toHump(paramsMap);
        this.baseDao.delete(paramsMap);
        return 1;
    }

    private String getSelectListSql(Map<String, Object> paramsMap) throws BaseAppException {
        String sql = paramsMap.get("selectColumns") == null || paramsMap.get("selectColumns").toString().isEmpty() ? DBUtils.getSelectListSql(this.tableName.toUpperCase(), paramsMap, null) : DBUtils.getSelectListSql(this.tableName.toUpperCase(), paramsMap, paramsMap.get("selectColumns").toString());
        if (paramsMap.get("orderByStr") != null && !paramsMap.get("orderByStr").toString().isEmpty()) {
            sql = sql + " order by " + paramsMap.get("orderByStr");
        }
        return sql;
    }

    private Integer selectMapCount(Map<String, Object> paramsMap) throws BaseAppException {
        String sql = this.getSelectListSql(paramsMap);
        if (Utils.isEmpty(sql)) {
            return null;
        }
        Page page = new Page();
        if (paramsMap.containsKey("start")) {
            page.setStart((Integer)paramsMap.get("start"));
        }
        if (paramsMap.containsKey("limit")) {
            page.setLimit((Integer)paramsMap.get("limit"));
        }
        paramsMap.put("sql", DBUtils.getCountSql(sql));
        Map<String, Object> r = this.baseDao.selectOne(paramsMap);
        return Integer.parseInt(r.get("count").toString());
    }

    private <T> Page<T> selectMapPageList(Map<String, Object> paramsMap, Class<T> clazz) throws BaseAppException {
        String sql = this.getSelectListSql(paramsMap);
        if (Utils.isEmpty(sql)) {
            return null;
        }
        Page<Map<String, Object>> page = new Page<Map<String, Object>>();
        if (paramsMap.containsKey("start")) {
            page.setStart((Integer)paramsMap.get("start"));
        }
        if (paramsMap.containsKey("limit")) {
            page.setLimit((Integer)paramsMap.get("limit"));
        }
        paramsMap.put("sql", DBUtils.getCountSql(sql));
        Map<String, Object> r = this.baseDao.selectOne(paramsMap);
        page.setTotalRecords(Integer.parseInt(r.get("count").toString()));
        if (page.getTotalRecords() == 0) {
            return page;
        }
        paramsMap.put("sql", DBUtils.getPageSql(sql, page));
        if (clazz == null) {
            page.setResultList(StringUtils.toHump(this.baseDao.selectList(paramsMap)));
        } else {
            List<Map<String, Object>> list = StringUtils.toHump(this.baseDao.selectList(paramsMap));
            ArrayList<T> returnList = new ArrayList<T>(list.size());
            for (Map<String, Object> returnMap : list) {
                try {
                    T returnObj = clazz.newInstance();
                    for (String key : returnMap.keySet()) {
                        org.apache.commons.beanutils.BeanUtils.copyProperty(returnObj, (String)key.toString(), (Object)returnMap.get(key));
                    }
                    returnList.add(returnObj);
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            page.setResultList(returnList);
        }
        return page;
    }
}

