/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.common.filter;

import com.club.framework.log.ClubLogManager;
import com.club.web.common.Configuration;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SessionFilter
implements Filter {
    private static final ClubLogManager logger = ClubLogManager.getLogger(SessionFilter.class);
    private String redirectUrl;
    private String webIP;
    private Map<String, String> loginExecutePageMap = new HashMap<String, String>();
    private Map<String, String> executePageMap = new HashMap<String, String>();

    public void init(FilterConfig cfg) throws ServletException {
        this.redirectUrl = cfg.getInitParameter("redirectUrl");
        this.webIP = Configuration.getString("webIP");
        String loginExecutePageStr = cfg.getInitParameter("loginExecutePage");
        List<Object> executePage = Configuration.getList("executePage");
        String[] loginExecutePageArr = loginExecutePageStr.split(",");
        for (String string : loginExecutePageArr) {
            this.loginExecutePageMap.put(string, "");
        }
        for (Object e : executePage) {
            this.executePageMap.put(e.toString(), "");
        }
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        Object sessionObj;
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String servletPath = request.getServletPath();
        String contextPath = request.getContextPath();
        String queryString = request.getQueryString();
        logger.debug("\u8bf7\u6c42\u8bbf\u95ee\u5730\u5740\uff1a" + servletPath);
        if (this.executePageMap.containsKey(servletPath) || servletPath.equals(this.redirectUrl) || servletPath.contains("/noPrivilege") || servletPath.contains("/login") || servletPath.contains("/logout")) {
            logger.debug("\u8bbf\u95ee\u5730\u5740\u4e3a\u65e0\u9700\u767b\u5f55\u5c31\u80fd\u8bbf\u95ee\u7684\u5730\u5740\uff0c\u76f4\u63a5\u653e\u884c\uff01");
            chain.doFilter(req, res);
            return;
        }
        if (!(queryString != null && queryString.contains("token") || (sessionObj = request.getSession().getAttribute("staff")) != null)) {
            logger.info("\u7528\u6237\u672a\u767b\u5f55\uff0c\u5373\u5c06\u8df3\u8f6c\u5230\u767b\u5f55\u9875\u9762\uff01");
            String redirect = contextPath + this.redirectUrl;
            if (servletPath.endsWith(".do")) {
                response.setHeader("sessionstatus", "timeout");
            } else {
                response.sendRedirect(redirect);
            }
        }
        chain.doFilter(req, res);
    }

    public void destroy() {
    }
}

