/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.common.message;

import com.club.web.common.message.MessageCell;
import com.club.web.common.message.MessageHeartThread;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageHeart {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static MessageHeart instance = null;
    private Map<String, List<MessageCell>> queue = new HashMap<String, List<MessageCell>>();
    private Map<String, Date> timeQueue = new HashMap<String, Date>();
    private MessageHeartThread messageHeartThread;

    public Map<String, Date> getTimeQueue() {
        return this.timeQueue;
    }

    public void setTimeQueue(Map<String, Date> timeQueue) {
        this.timeQueue = timeQueue;
    }

    private MessageHeart() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MessageHeart getInstance() {
        if (instance != null) return instance;
        Class<MessageHeart> clazz = MessageHeart.class;
        synchronized (MessageHeart.class) {
            if (instance != null) return instance;
            instance = new MessageHeart();
            MessageHeart.instance.messageHeartThread = new MessageHeartThread(instance);
            MessageHeart.instance.messageHeartThread.start();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String channel, String message) {
        MessageCell cell = new MessageCell();
        cell.setChannel(channel);
        cell.setMessage(message);
        for (String uuid : this.queue.keySet()) {
            List<MessageCell> list = this.queue.get(uuid);
            synchronized (list) {
                this.queue.get(uuid).add(cell);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(String uuid) {
        List<MessageCell> list = this.queue.get(uuid);
        synchronized (list) {
            this.queue.get(uuid).clear();
            this.queue.remove(uuid);
            this.timeQueue.remove(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(String uuid) {
        if (!this.queue.containsKey(uuid)) {
            Map<String, List<MessageCell>> map = this.queue;
            synchronized (map) {
                if (!this.queue.containsKey(uuid)) {
                    ArrayList cells = new ArrayList();
                    this.queue.put(uuid, cells);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MessageCell> loadData(String uuid, String[] chanels) {
        Object object;
        this.bind(uuid);
        if (this.timeQueue.isEmpty()) {
            object = this.timeQueue;
            synchronized (object) {
                this.timeQueue.notifyAll();
                this.logger.info("timeQueue wake up");
            }
        }
        object = this.queue.get(uuid);
        synchronized (object) {
            ArrayList<MessageCell> cells = new ArrayList<MessageCell>(this.queue.get(uuid).size());
            for (MessageCell cell : this.queue.get(uuid)) {
                for (String chanel : chanels) {
                    if (!chanel.equals(cell.getChannel())) continue;
                    cells.add(cell);
                }
            }
            this.queue.get(uuid).clear();
            this.timeQueue.put(uuid, new Date());
            return cells;
        }
    }
}

