/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.common.service.impl;

import com.club.core.common.Page;
import com.club.core.common.QueryCondition;
import com.club.core.common.TreeNode;
import com.club.core.common.TreePO;
import com.club.core.common.TreeQueryPO;
import com.club.core.common.TreeSortComparator;
import com.club.core.db.dao.BaseDao;
import com.club.core.idproduce.ISequenceGenerator;
import com.club.framework.exception.BaseAppException;
import com.club.framework.log.ClubLogManager;
import com.club.framework.util.BeanUtils;
import com.club.framework.util.DBUtils;
import com.club.framework.util.JsonUtil;
import com.club.framework.util.StringUtils;
import com.club.framework.util.Utils;
import com.club.framework.util.ValidformUtils;
import com.club.web.common.cache.DBMetaCache;
import com.club.web.common.db.arg.WfDbColumnsArg;
import com.club.web.common.db.arg.WfDbMetaArg;
import com.club.web.common.db.arg.WfDbTableArg;
import com.club.web.common.db.dao.WfDbColumnsDao;
import com.club.web.common.db.dao.WfDbMetaDao;
import com.club.web.common.db.dao.WfDbTableDao;
import com.club.web.common.db.po.WfDbColumnsPO;
import com.club.web.common.db.po.WfDbMetaPO;
import com.club.web.common.db.po.WfDbTablePO;
import com.club.web.common.service.IBaseService;
import com.club.web.common.vo.DBColumn;
import com.club.web.common.vo.DBMeta;
import com.club.web.common.vo.DBTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BaseServiceImpl
implements IBaseService {
    private static final ClubLogManager logger = ClubLogManager.getLogger(BaseServiceImpl.class);
    @Autowired
    private BaseDao baseDao;
    @Autowired
    private WfDbMetaDao dbMetaDao;
    @Autowired
    private WfDbTableDao dbTableDao;
    @Autowired
    private WfDbColumnsDao dbColumnDao;
    @Resource(name="sequenceProcGenerator")
    private ISequenceGenerator sequenceGenerator;

    @Override
    public List<Map<String, Object>> selectList(String tableName, Map<String, Object> conditions) throws BaseAppException {
        return this.selectList(conditions, DBUtils.getSelectListSql(tableName.toUpperCase(), conditions.keySet()));
    }

    @Override
    public List<Map<String, Object>> selectList(Map<String, Object> conditions, String sql) throws BaseAppException {
        conditions.put("sql", sql);
        return this.baseDao.selectList(conditions);
    }

    @Override
    public List<Map<String, Object>> selectList(String sql) throws BaseAppException {
        return this.selectList(new HashMap<String, Object>(), sql);
    }

    @Override
    public Page<Map<String, Object>> selectPage(String tableName, Map<String, Object> conditions) throws BaseAppException {
        String sql = DBUtils.getSelectListSql(tableName.toUpperCase(), conditions.keySet());
        if (conditions != null && !conditions.containsKey("start")) {
            conditions.put("start", "0");
        }
        if (conditions != null && !conditions.containsKey("limit")) {
            conditions.put("limit", "50");
        }
        conditions.put("sql", sql);
        return this.selectPage(conditions, true);
    }

    @Override
    public Page<Map<String, Object>> selectPage(Map<String, Object> conditions, boolean isHump) throws BaseAppException {
        Page<Map<String, Object>> page = new Page<Map<String, Object>>();
        page.setLimit(Integer.parseInt(conditions.get("limit").toString()));
        page.setStart(Integer.parseInt(conditions.get("start").toString()));
        String sql = conditions.get("sql").toString();
        if (Utils.isEmpty(sql)) {
            return null;
        }
        conditions.put("sql", DBUtils.getPageSql(sql, page));
        if (isHump) {
            page.setResultList(StringUtils.toHump(this.baseDao.selectList(conditions)));
        } else {
            page.setResultList(this.baseDao.selectList(conditions));
        }
        conditions.put("sql", DBUtils.getCountSql(sql));
        Map<String, Object> r = this.baseDao.selectOne(conditions);
        page.setTotalRecords(Integer.parseInt(r.get("count").toString()));
        return page;
    }

    @Override
    public List<Map<String, Object>> selectList2(String sqlKey, Map<String, Object> paramMap) {
        logger.debug("load table {0},by conditions[{1}]", (Object)sqlKey, (Object)paramMap);
        return this.baseDao.selectList(sqlKey, paramMap);
    }

    @Override
    public boolean testDBConnection(String driver, String dbName, String characterEncoding, String ip, String port, String params, String username, String password) throws BaseAppException {
        StringBuffer url = new StringBuffer("jdbc:");
        if (driver.toLowerCase().contains("mysql")) {
            url.append("mysql://").append(ip).append(":").append(port).append("/").append(dbName).append("?characterEncoding=").append(characterEncoding).append("&").append(params);
        } else {
            url.append("oracle:thin:@").append(ip).append(":").append(port).append(":").append(dbName);
        }
        return DBUtils.testDBConnection(driver, url.toString(), username, password);
    }

    @Override
    public DBMeta loadDBMeta(String driver, String dbName, String characterEncoding, String ip, String port, String params, String username, String password) {
        StringBuffer url = new StringBuffer("jdbc:");
        if (driver.toLowerCase().contains("mysql")) {
            url.append("mysql://").append(ip).append(":").append(port).append("/").append(dbName).append("?characterEncoding=").append(characterEncoding).append("&").append(params);
        } else {
            url.append("oracle:thin:@").append(ip).append(":").append(port).append(":").append(dbName);
        }
        return DBUtils.loadDBMeta(driver, url.toString(), username, password);
    }

    @Override
    public boolean saveDBMeta(String driver, String dbName, String characterEncoding, String ip, String port, String params, String username, String password) throws BaseAppException {
        StringBuffer url = new StringBuffer("jdbc:");
        if (driver.toLowerCase().contains("mysql")) {
            url.append("mysql://").append(ip).append(":").append(port).append("/").append(dbName).append("?characterEncoding=").append(characterEncoding).append("&").append(params);
        } else {
            url.append("oracle:thin:@").append(ip).append(":").append(port).append(":").append(dbName);
        }
        return this.saveDBMeta(driver, url.toString(), username, password);
    }

    @Override
    public boolean saveDBMeta(String driver, String url, String username, String password) throws BaseAppException {
        logger.info("auto flush table caches by driver:" + driver + ",url:" + url + ",username:" + username + ",password:" + password);
        WfDbTableArg tableArg = new WfDbTableArg();
        tableArg.createCriteria().andSourceEqualTo("USR");
        List<WfDbTablePO> tablePOss = this.dbTableDao.selectByArg(tableArg);
        HashMap<String, String> tableKey = new HashMap<String, String>();
        for (WfDbTablePO tablePO : tablePOss) {
            DBTable table = DBTable.parse(tablePO);
            tableKey.put(table.getTableName().toLowerCase(), table.getSource());
        }
        long start = System.currentTimeMillis();
        logger.info("load dbMeta start");
        DBMeta meta = DBUtils.loadDBMeta(driver, url.toString(), username, password);
        long end = System.currentTimeMillis();
        logger.info("load dbMeta cost {} seconds", (Object)((end - start) / 1000L));
        for (DBTable t : meta.getTables()) {
            if (tableKey.containsKey(t.getTableName().toLowerCase())) {
                t.setSource((String)tableKey.get(t.getTableName()));
            } else {
                t.setSource("SYS");
            }
            for (DBColumn column : t.getColumns()) {
                t.getColumnMap().put(column.getColumnName(), column);
                t.getColumnMap().put(column.getColumnName().toUpperCase(), column);
                t.getColumnMap().put(StringUtils.toHump(column.getColumnName()), column);
                column.setTableName(t.getTableName());
            }
            t.setDbName(meta.getDbName());
        }
        logger.info("refresh cache");
        DBMetaCache.setMeta(meta);
        WfDbMetaPO metaPo = new WfDbMetaPO();
        meta.convert(metaPo);
        logger.info("start delete data");
        this.dbColumnDao.deleteByArg(new WfDbColumnsArg());
        this.dbTableDao.deleteByArg(new WfDbTableArg());
        this.dbMetaDao.deleteByArg(new WfDbMetaArg());
        logger.info("insert meta");
        this.dbMetaDao.insert(metaPo);
        ArrayList<WfDbTablePO> tables = new ArrayList<WfDbTablePO>();
        ArrayList<WfDbColumnsPO> columns = new ArrayList<WfDbColumnsPO>();
        for (DBTable table : meta.getTables()) {
            WfDbTablePO tablePo = new WfDbTablePO();
            table.convert(tablePo);
            tablePo.setModifyTime(new Date());
            tablePo.setDbName(metaPo.getDbName());
            tables.add(tablePo);
            for (DBColumn column : table.getColumns()) {
                WfDbColumnsPO columnPo = new WfDbColumnsPO();
                column.convert(columnPo);
                columnPo.setTableName(tablePo.getTableName());
                columns.add(columnPo);
            }
        }
        logger.info("insert table batch");
        this.dbTableDao.insertBatch(tables);
        logger.info("insert column batch");
        this.dbColumnDao.insertBatch(columns);
        return true;
    }

    @Override
    public TreeNode getTreeAllData(TreePO params, Map<String, Object> obj, int path) {
        ++path;
        Integer deep = params.getDeep();
        String checked = params.getChecked();
        String[] icons = params.getIcons();
        TreeNode node = new TreeNode();
        node.setText(obj.get(params.getDisplayField()) + "");
        node.setId(obj.get(params.getValueField()) + "");
        if (!StringUtils.isEmpty(params.getCheckField())) {
            boolean checkField = false;
            if (!StringUtils.isEmpty(obj.get(params.getCheckField()))) {
                checkField = true;
            }
            obj.put("fieldChecked", checkField);
        }
        node.setAttributeMap(obj);
        String relatePropertyKey = params.getRelatePropertyKey();
        if (!StringUtils.isEmpty(relatePropertyKey)) {
            HashMap<String, Object> req = new HashMap<String, Object>();
            req.put("relateId", node.getId());
            List<Map<String, Object>> fields = this.baseDao.selectList(relatePropertyKey, req);
            if (!StringUtils.isEmpty(fields)) {
                node.getAttributeMap().put("relateProperty", fields);
            }
        }
        if (path >= deep) {
            if (obj.containsKey("expandable")) {
                node.setExpandable(Boolean.parseBoolean(obj.get("expandable") + ""));
            } else {
                node.setExpandable(true);
            }
            node.setExpanded(false);
        } else {
            ArrayList<TreeNode> childs = new ArrayList<TreeNode>();
            node.setChildren(childs);
            Map<String, Object> req = null;
            if (!StringUtils.isEmpty(params.getParamData())) {
                req = new HashMap<String, Object>();
                req.putAll(obj);
                req.putAll(params.getParamData());
            } else {
                req = obj;
            }
            List<Map<String, Object>> fields = this.baseDao.selectList(params.getSqlKey(), req);
            if (fields.size() == 0) {
                node.setLeaf(true);
            } else {
                node.setExpandable(true);
                node.setExpanded(true);
            }
            for (Map<String, Object> field : fields) {
                childs.add(this.getTreeAllData(params, field, path));
            }
        }
        if (!StringUtils.isEmpty(checked)) {
            if (checked.indexOf(",") != -1) {
                for (String d : checked.split(",")) {
                    if (path != Integer.parseInt(d)) continue;
                    node.setChecked(false);
                }
            } else {
                node.setChecked(false);
            }
        }
        if (icons.length > path) {
            node.setIcon(icons[path]);
        }
        if (obj.containsKey("icon") && !StringUtils.isEmpty(obj.get("icon"))) {
            node.setIcon(obj.get("icon").toString());
        } else if (!StringUtils.isEmpty(params.getIcon())) {
            node.setIcon(params.getIcon());
        }
        return node;
    }

    @Override
    public TreeNode queryTree(TreeQueryPO reqDto) {
        HashMap<String, List<Map<String, Object>>> parents = new HashMap<String, List<Map<String, Object>>>();
        ArrayList<String> ids = new ArrayList<String>();
        String queryConditions = reqDto.getQueryConditions();
        List<QueryCondition> queryConditionsList = JsonUtil.toList(queryConditions, QueryCondition.class);
        Map<String, Object> conditions = DBUtils.getSelectListSql(reqDto.getTableName(), queryConditionsList);
        TreeSortComparator comparator = null;
        String sql = (String)conditions.get("sql");
        String orderByClause = reqDto.getOrderByClause();
        if (!StringUtils.isEmpty(orderByClause)) {
            sql = sql + " order by " + orderByClause;
            comparator = new TreeSortComparator();
            Map<String, Boolean> orderByClauses = comparator.getOrderByClauses();
            String[] orders = orderByClause.split(",");
            for (int i = 0; i < orders.length; ++i) {
                String[] order = orders[i].trim().split("\\s+");
                String key = StringUtils.toHump(order[0]);
                boolean value = false;
                if (order.length == 2 && order[1].toLowerCase().equals("desc")) {
                    value = true;
                }
                orderByClauses.put(key, value);
            }
        }
        conditions.put("sql", sql);
        List<Map<String, Object>> datas = this.baseDao.selectList(conditions);
        ArrayList<String> pks = new ArrayList<String>();
        this.setParentDatas(datas, parents, ids, pks, reqDto, true);
        if (ids.size() > 0) {
            this.queryParents(parents, ids, pks, reqDto);
        }
        TreeNode node = new TreeNode();
        node.setId(reqDto.getRootId());
        node.setText(reqDto.getRootText());
        node.setLeaf(true);
        if (!StringUtils.isEmpty(reqDto.getIcon())) {
            node.setIcon(reqDto.getIcon());
        }
        if (parents.size() > 0) {
            node.setLeaf(false);
            this.setChildren(node, parents, reqDto, comparator);
            return node;
        }
        return node;
    }

    public void queryParents(Map<String, List<Map<String, Object>>> parents, List<String> ids, List<String> pks, TreeQueryPO reqDto) {
        QueryCondition condition = new QueryCondition();
        condition.setParamName(reqDto.getValueField());
        condition.setParamValue(ids.toArray(new String[0]));
        condition.setOperation(QueryCondition.ConditionOperation.In);
        ArrayList<QueryCondition> queryConditionsList = new ArrayList<QueryCondition>(1);
        queryConditionsList.add(condition);
        Map<String, Object> conditions = DBUtils.getSelectListSql(reqDto.getTableName(), queryConditionsList);
        List<Map<String, Object>> datas = this.baseDao.selectList(conditions);
        ids.clear();
        this.setParentDatas(datas, parents, ids, pks, reqDto, false);
        if (ids.size() > 0) {
            this.queryParents(parents, ids, pks, reqDto);
        }
    }

    private void setChildren(TreeNode node, Map<String, List<Map<String, Object>>> datas, TreeQueryPO reqDto, TreeSortComparator comparator) {
        String id = node.getId();
        List<Map<String, Object>> children = datas.get(id);
        if (children == null || children.size() == 0) {
            node.setExpandable(false);
            node.setLeaf(true);
            return;
        }
        ArrayList<TreeNode> childs = new ArrayList<TreeNode>();
        if (comparator != null) {
            Collections.sort(children, comparator);
        }
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            Map<String, Object> data = children.get(i);
            TreeNode nodeTemp = new TreeNode();
            nodeTemp.setId(data.get(reqDto.getValueField()) + "");
            nodeTemp.setText(data.get(reqDto.getDisplayField()) + "");
            nodeTemp.setAttributeMap(data);
            if (!StringUtils.isEmpty(reqDto.getIcon())) {
                nodeTemp.setIcon(reqDto.getIcon());
            }
            this.setChildren(nodeTemp, datas, reqDto, comparator);
            childs.add(nodeTemp);
        }
        node.setChildren(childs);
    }

    private void setParentDatas(List<Map<String, Object>> datas, Map<String, List<Map<String, Object>>> parents, List<String> ids, List<String> pks, TreeQueryPO reqDto, boolean isFirst) {
        int i;
        for (i = 0; i < datas.size(); ++i) {
            Map<String, Object> data = datas.get(i);
            String id = data.get(reqDto.getParentField()).toString();
            if (isFirst) {
                String pk = data.get(reqDto.getValueField()).toString();
                pks.add(pk);
            }
            if (parents.containsKey(id)) {
                parents.get(id).add(data);
                continue;
            }
            ArrayList<Map<String, Object>> temp = new ArrayList<Map<String, Object>>();
            temp.add(data);
            parents.put(id, temp);
            if (id.equals(reqDto.getRootId())) continue;
            ids.add(id);
        }
        if (ids.size() > 0) {
            for (i = 0; i < pks.size(); ++i) {
                String pk = pks.get(i);
                if (!ids.contains(pk)) continue;
                ids.remove(pk);
            }
        }
    }

    public Map<String, Map<String, Object>> convertTables(String tableColumnKey) {
        String[] keys = tableColumnKey.split(",");
        HashMap<String, Map<String, Object>> tables = new HashMap<String, Map<String, Object>>();
        for (String key : keys) {
            String[] keyValue = key.split("=");
            String[] tableColumn = keyValue[0].split("\\.");
            String tableName = tableColumn[0];
            String columnName = StringUtils.toHump(tableColumn[1]);
            String value = keyValue[1];
            if (!tables.containsKey(tableName)) {
                tables.put(tableName, new HashMap());
            }
            ((Map)tables.get(tableName)).put(columnName, value);
        }
        return tables;
    }

    @Override
    public void delete(String tableColumnKey) throws BaseAppException {
        Map<String, Map<String, Object>> tables = this.convertTables(tableColumnKey);
        for (String tableName : tables.keySet()) {
            String sql = DBUtils.getDeleteSql(tableName);
            tables.get(tableName).put("sql", sql);
            this.baseDao.delete(tables.get(tableName));
        }
    }

    @Override
    public Map<String, Object> selectOne(String tableColumnKey) throws BaseAppException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, Map<String, Object>> tables = this.convertTables(tableColumnKey);
        for (String tableName : tables.keySet()) {
            String sql = DBUtils.getSelectListSql(tableName, tables.get(tableName));
            tables.get(tableName).put("sql", sql);
            Map<String, Object> r = this.baseDao.selectOne(tables.get(tableName));
            for (String column : r.keySet()) {
                result.put(tableName + "." + column, r.get(column));
            }
        }
        return result;
    }

    @Override
    public Map<String, Object> selectOne(String tableName, Map<String, Object> conditions) throws BaseAppException {
        return this.selectOne(conditions, DBUtils.getSelectListSql(tableName.toUpperCase(), conditions.keySet()));
    }

    @Override
    public Map<String, Object> selectOneBySql(String sql) throws BaseAppException {
        return this.selectOne(new HashMap<String, Object>(), sql);
    }

    @Override
    public Map<String, Object> selectOne(Map<String, Object> conditions, String sql) throws BaseAppException {
        if (conditions == null) {
            conditions = new HashMap<String, Object>();
        }
        conditions.put("sql", sql);
        List<Map<String, Object>> list = this.baseDao.selectList(conditions);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Map<String, Object> selectHumOne(Map<String, Object> conditions, String sql) throws BaseAppException {
        return StringUtils.toHump(this.selectOne(conditions, sql));
    }

    @Override
    public <T> T selectOne(T record) throws BaseAppException {
        logger.debug("load Record {0}", (Object)record);
        Map<String, Object> keyValues = DBUtils.getSelectOneSql(record);
        Map<String, Object> result = this.baseDao.selectOne(keyValues);
        if (result == null || result.keySet().size() == 0) {
            return null;
        }
        return (T)BeanUtils.map2Bean(result, record.getClass());
    }

    @Override
    public <T> int delete(T record) throws BaseAppException {
        logger.debug("load Record {0}", (Object)record);
        Map<String, Object> keyValues = DBUtils.getDeleteSql(record);
        return this.baseDao.delete(keyValues);
    }

    @Override
    public <T> T insert(T record) throws BaseAppException {
        Map<String, Object> keyValues = DBUtils.getInsertSql(record);
        this.setSequenceGenerator(keyValues, DBUtils.getTalbePK(record), DBUtils.getTalbe(record));
        keyValues = StringUtils.toHump(keyValues);
        this.baseDao.insert(keyValues);
        return (T)BeanUtils.map2Bean(keyValues, record.getClass());
    }

    private Map<String, Object> setSequenceGenerator(Map<String, Object> keyValues, List<DBColumn> pks, DBTable table) throws BaseAppException {
        return this.setSequenceGenerator(keyValues, pks, table, false);
    }

    private Map<String, Object> setSequenceGenerator(Map<String, Object> keyValues, List<DBColumn> pks, DBTable table, boolean auto) throws BaseAppException {
        HashMap<String, Object> ps = new HashMap<String, Object>();
        for (DBColumn column : pks) {
            String columnName = DBUtils.getColumnName(keyValues, column.getColumnName());
            if (column.getDbType().toUpperCase().indexOf("CHAR") != -1 || column.getDbType().toUpperCase().equals("LONG") || column.getDbType().toUpperCase().equals("INT") || column.getDbType().toUpperCase().equals("BIGINT")) {
                if (columnName != null) {
                    int _pk;
                    Object pk = keyValues.get(columnName);
                    if (pk instanceof String && pk.equals("auto") || auto) {
                        _pk = this.sequenceGenerator.sequenceIntValue(column.getTableName().toUpperCase(), column.getColumnName().toUpperCase(), table.getDbName().toUpperCase());
                        keyValues.put(column.getColumnName(), _pk);
                        ps.put(column.getColumnName(), _pk);
                        continue;
                    }
                    if (!(pk instanceof Integer) && !(pk instanceof Long) || !pk.equals(-1)) continue;
                    _pk = this.sequenceGenerator.sequenceIntValue(column.getTableName().toUpperCase(), column.getColumnName().toUpperCase(), table.getDbName().toUpperCase());
                    keyValues.put(column.getColumnName(), _pk);
                    ps.put(column.getColumnName(), _pk);
                    continue;
                }
                int pk = this.sequenceGenerator.sequenceIntValue(column.getTableName().toUpperCase(), column.getColumnName().toUpperCase(), table.getDbName().toUpperCase());
                keyValues.put(column.getColumnName(), pk);
                ps.put(column.getColumnName(), pk);
                continue;
            }
            if (columnName == null) continue;
            ps.put(column.getColumnName(), keyValues.get(columnName));
        }
        return ps;
    }

    @Override
    public Map<String, Object> insert(String tableName, Map<String, Object> record) throws BaseAppException {
        return this.insert(tableName, record, false);
    }

    public Map<String, Object> insert(String tableName, Map<String, Object> record, boolean auto) throws BaseAppException {
        Map<String, Object> ids = this.setSequenceGenerator(record, DBUtils.getTalbePK(tableName), DBUtils.getTalbe(tableName), auto);
        String sql = DBUtils.getInsertTableSql(tableName, record);
        record.put("sql", sql);
        logger.info("insert general sql {0}", (Object)sql);
        this.baseDao.insert(record);
        return ids;
    }

    @Override
    public String saveOrUpdate(Map<String, Object> record) throws BaseAppException {
        StringBuffer pk = new StringBuffer();
        HashMap records = new HashMap();
        for (String key : record.keySet()) {
            if (key.indexOf(".") == -1) {
                throw new RuntimeException("\u8868\u540d\u3001\u5b57\u6bb5\u540d\u4e0d\u5339\u914d:" + key);
            }
            String[] ks = key.split("\\.");
            if (ks.length < 2) {
                throw new RuntimeException("\u5b57\u6bb5\u4e0d\u8bb8\u4e3a\u7a7a:" + key);
            }
            for (int i = 0; i < ks.length; ++i) {
                ks[i] = ks[i].toUpperCase();
            }
            if (!records.containsKey(ks[0])) {
                records.put(ks[0], new HashMap());
            }
            ((Map)records.get(ks[0])).put(ks[1], record.get(key));
        }
        for (String key : records.keySet()) {
            pk.append(this.saveOrUpdate(key, (Map)records.get(key)) + ",");
        }
        return pk.substring(0, pk.length() - 1).toString();
    }

    @Override
    public String save(Map<String, Object> record) throws BaseAppException {
        StringBuffer pk = new StringBuffer();
        HashMap records = new HashMap();
        for (String key : record.keySet()) {
            if (key.indexOf(".") == -1) {
                throw new RuntimeException("\u8868\u540d\u3001\u5b57\u6bb5\u540d\u4e0d\u5339\u914d:" + key);
            }
            String[] ks = key.split("\\.");
            if (ks.length < 2) {
                throw new RuntimeException("\u5b57\u6bb5\u4e0d\u8bb8\u4e3a\u7a7a:" + key);
            }
            for (int i = 0; i < ks.length; ++i) {
                ks[i] = ks[i].toUpperCase();
            }
            if (!records.containsKey(ks[0])) {
                records.put(ks[0], new HashMap());
            }
            ((Map)records.get(ks[0])).put(ks[1], record.get(key));
        }
        StringBuffer pkStr = new StringBuffer();
        for (String key : records.keySet()) {
            Map<String, Object> pks = this.insert(key, (Map)records.get(key), true);
            for (String id_ : pks.keySet()) {
                pkStr.append(key + "." + id_ + "=" + pks.get(id_) + ",");
            }
        }
        return pkStr.substring(0, pkStr.length() - 1).toString();
    }

    @Override
    public String testRun(Map<String, Object> record) throws BaseAppException {
        String tableKey = this.saveOrUpdate(record);
        this.delete(tableKey);
        return tableKey;
    }

    public String saveOrUpdate(String tableName, Map<String, Object> record) throws BaseAppException {
        ValidformUtils.validTable(tableName, record);
        List<DBColumn> pkColumns = DBUtils.getTalbePK(tableName);
        Map<Object, Object> pks = new HashMap();
        for (DBColumn column : pkColumns) {
            Object val;
            String string = DBUtils.getColumnName(record, column.getColumnName());
            if (string == null || (val = record.get(string)) == null || val.equals("auto") || val.equals(-1)) continue;
            pks.put(column.getColumnName(), record.get(string));
        }
        if (pks.keySet().size() == pkColumns.size()) {
            this.update(tableName, record);
        } else {
            pks = this.insert(tableName, record);
        }
        StringBuffer pkStr = new StringBuffer();
        for (String string : pks.keySet()) {
            pkStr.append(tableName + "." + string + "=" + pks.get(string) + ",");
        }
        return pkStr.substring(0, pkStr.length() - 1).toString();
    }

    @Override
    public <T> int update(T record) throws BaseAppException {
        Map<String, Object> keyValues = DBUtils.getUpdateSql(record);
        return this.baseDao.update(keyValues);
    }

    @Override
    public int update(String tableName, Map<String, Object> record) throws BaseAppException {
        String sql = DBUtils.getUpdateTableSql(tableName, record);
        record.put("sql", sql);
        logger.info("update general sql {0}", (Object)sql);
        return this.baseDao.update(record);
    }
}

