/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.datamodel.controller;

import com.club.core.common.Page;
import com.club.framework.exception.BaseAppException;
import com.club.framework.log.ClubLogManager;
import com.club.framework.util.JsonUtil;
import com.club.web.common.vo.DBColumn;
import com.club.web.common.vo.DBTable;
import com.club.web.datamodel.db.po.WfDbColumnsPO;
import com.club.web.datamodel.service.IWfDbColumnsService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/datamodel/wfdbcolumns"})
public class WfDbColumnsController {
    private static final ClubLogManager logger = ClubLogManager.getLogger(WfDbColumnsController.class);
    @Autowired
    private IWfDbColumnsService wfDbColumnsService;

    @RequestMapping(value={"index"})
    public String index(Model model) {
        return "datamodel/jsp/wfDbColumns";
    }

    @RequestMapping(value={"queryRecordByPage"})
    @ResponseBody
    public Page<WfDbColumnsPO> queryRecordByPage(WfDbColumnsPO record, Page<WfDbColumnsPO> resultPage) throws BaseAppException {
        resultPage = this.wfDbColumnsService.selectByArgAndPage(record, resultPage);
        return resultPage;
    }

    @RequestMapping(value={"queryRecordByPageWithDbName"})
    @ResponseBody
    protected Page<WfDbColumnsPO> queryRecordByPageWithDbName(WfDbColumnsPO record, Page<WfDbColumnsPO> resultPage) throws BaseAppException {
        resultPage.setLimit(1000);
        resultPage = this.wfDbColumnsService.queryRecordByPageWithDbName(record, resultPage);
        return resultPage;
    }

    @RequestMapping(value={"add"})
    @ResponseBody
    public WfDbColumnsPO add(WfDbColumnsPO record) throws BaseAppException {
        logger.debug("add record begin...record=[{0}]", (Object)record);
        this.wfDbColumnsService.add(record);
        return record;
    }

    @RequestMapping(value={"saveOrUpdate"})
    @ResponseBody
    public Map<String, Object> saveOrUpdate(WfDbColumnsPO record) throws BaseAppException {
        logger.debug("saveOrUpdate record begin...record=[{0}]", (Object)record);
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (record == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)record.getColumnName())) {
            return null;
        }
        String columnName = record.getColumnName().substring(3);
        String[] recordsSplit = columnName.split("Y@Y");
        WfDbColumnsPO entity = JsonUtil.toBean(recordsSplit[0], WfDbColumnsPO.class);
        ArrayList<WfDbColumnsPO> columnsList = new ArrayList<WfDbColumnsPO>();
        DBTable dbTable = this.newDbTable(entity, record);
        for (int i = 0; i < recordsSplit.length; ++i) {
            if (!StringUtils.isNotBlank((CharSequence)recordsSplit[i])) continue;
            WfDbColumnsPO po = this.wfDbColumnsService.convertWfDbColumnsPO(recordsSplit[i], dbTable);
            columnsList.add(po);
        }
        if (CollectionUtils.isEmpty(columnsList)) {
            return null;
        }
        try {
            this.wfDbColumnsService.createTable(columnsList, entity, record);
            this.wfDbColumnsService.saveTableAndColumns(columnsList, record, dbTable);
            result.put("success", true);
        }
        catch (Exception e) {
            result.put("message", "\u5efa\u8868\u5931\u8d25\uff0c\u5217\u540d\u8bf7\u5c3d\u91cf\u4f7f\u7528\u5b57\u6bcd\u52a0\u4e0b\u5212\u7ebf\uff0c\u8bf7\u5220\u9664\u8be5\u8868\u91cd\u65b0\u5efa\u8868\uff01");
            throw new BaseAppException();
        }
        return result;
    }

    private DBTable newDbTable(WfDbColumnsPO entity, WfDbColumnsPO record) {
        DBTable dbTable = new DBTable();
        dbTable.setTableName(entity.getTableName().toUpperCase());
        dbTable.setRemarks(record.getDisplayName());
        dbTable.setPks(new ArrayList<String>());
        dbTable.setFks(new ArrayList<String>());
        dbTable.setColumns(new ArrayList<DBColumn>());
        return dbTable;
    }

    @RequestMapping(value={"isExist"})
    @ResponseBody
    public int isExist(WfDbColumnsPO record) throws BaseAppException {
        logger.debug("isExist record begin...record=[{0}]", (Object)record);
        return this.wfDbColumnsService.isExist(record);
    }

    @RequestMapping(value={"update"})
    @ResponseBody
    public WfDbColumnsPO update(WfDbColumnsPO record) throws BaseAppException {
        logger.debug("modify record begin...record=[{0}]", (Object)record);
        this.wfDbColumnsService.update(record);
        return record;
    }

    @RequestMapping(value={"delete"})
    @ResponseBody
    public int delete(WfDbColumnsPO record) throws BaseAppException {
        logger.debug("delete record begin...record=[{0}]", (Object)record);
        return this.wfDbColumnsService.delete(record);
    }

    @RequestMapping(value={"deleteBatch"})
    @ResponseBody
    public int deleteBatch(String deleteRecords) throws BaseAppException {
        logger.debug("deleteBatch record begin...deleteRecords={0}", (Object)deleteRecords);
        return this.wfDbColumnsService.deleteBatch(deleteRecords);
    }

    @RequestMapping(value={"qryRecordInfo"})
    @ResponseBody
    public WfDbColumnsPO qryRecordInfo(@RequestParam(value="tableName", required=true) String tableName) throws BaseAppException {
        WfDbColumnsPO record = this.wfDbColumnsService.selectByPrimaryKey(tableName);
        return record;
    }
}

