/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.datamodel.controller;

import com.club.core.common.Page;
import com.club.framework.exception.BaseAppException;
import com.club.framework.log.ClubLogManager;
import com.club.framework.util.StringUtils;
import com.club.web.datamodel.db.po.WfDbTablePO;
import com.club.web.datamodel.service.IWfDbTableService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/datamodel/wfdbtable"})
public class WfDbTableController {
    private static final ClubLogManager logger = ClubLogManager.getLogger(WfDbTableController.class);
    @Autowired
    private IWfDbTableService wfDbTableService;

    @RequestMapping(value={"index"})
    public String index(Model model) {
        return "datamodel/jsp/wfDbTable";
    }

    @RequestMapping(value={"queryRecordByPage"})
    @ResponseBody
    public Page<WfDbTablePO> queryRecordByPage(WfDbTablePO record, Page<WfDbTablePO> resultPage) throws BaseAppException {
        resultPage = this.wfDbTableService.selectByArgAndPage(record, resultPage);
        return resultPage;
    }

    @RequestMapping(value={"add"})
    @ResponseBody
    public WfDbTablePO add(WfDbTablePO record) throws BaseAppException {
        logger.debug("add record begin...record=[{0}]", (Object)record);
        this.wfDbTableService.add(record);
        return record;
    }

    @RequestMapping(value={"update"})
    @ResponseBody
    public WfDbTablePO update(WfDbTablePO record) throws BaseAppException {
        logger.debug("modify record begin...record=[{0}]", (Object)record);
        this.wfDbTableService.update(record);
        return record;
    }

    @RequestMapping(value={"delete"})
    @ResponseBody
    public int delete(WfDbTablePO record) throws BaseAppException {
        logger.debug("delete record begin...record=[{0}]", (Object)record);
        return this.wfDbTableService.delete(record);
    }

    @RequestMapping(value={"qryRecordInfo"})
    @ResponseBody
    public WfDbTablePO qryRecordInfo(@RequestParam(value="tableName", required=true) Integer tableName) throws BaseAppException {
        WfDbTablePO record = this.wfDbTableService.selectByPrimaryKey(tableName);
        return record;
    }

    @RequestMapping(value={"dbTableComboBox"})
    @ResponseBody
    public List<WfDbTablePO> dbTableComboBox(HttpServletRequest request) throws BaseAppException {
        WfDbTablePO po = new WfDbTablePO();
        String dbName = request.getParameter("dbName");
        if (StringUtils.isNotEmpty(dbName)) {
            po.setDbName(dbName);
        }
        List<WfDbTablePO> result = this.wfDbTableService.selectByArg(po);
        return result;
    }
}

