/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.datamodel.service.impl;

import com.club.core.common.Page;
import com.club.core.convert.IArgConversionService;
import com.club.core.db.dao.BaseDao;
import com.club.core.idproduce.ISequenceGenerator;
import com.club.framework.exception.BaseAppException;
import com.club.framework.log.ClubLogManager;
import com.club.framework.util.DBUtils;
import com.club.framework.util.JsonUtil;
import com.club.framework.util.StringUtils;
import com.club.framework.util.Utils;
import com.club.web.common.cache.DBMetaCache;
import com.club.web.common.service.IBaseService;
import com.club.web.common.vo.DBColumn;
import com.club.web.common.vo.DBMeta;
import com.club.web.common.vo.DBTable;
import com.club.web.datamodel.db.arg.WfDbColumnsArg;
import com.club.web.datamodel.db.arg.WfDbTableArg;
import com.club.web.datamodel.db.dao.WfDbColumnsDao;
import com.club.web.datamodel.db.dao.WfDbTableDao;
import com.club.web.datamodel.db.po.WfDbColumnsPO;
import com.club.web.datamodel.db.po.WfDbTablePO;
import com.club.web.datamodel.service.IWfDbColumnsService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="wfDbColumnsService")
public class WfDbColumnsServiceImpl
implements IWfDbColumnsService {
    private static final ClubLogManager logger = ClubLogManager.getLogger(WfDbColumnsServiceImpl.class);
    @Autowired
    private WfDbColumnsDao wfDbColumnsDao;
    @Autowired
    private WfDbTableDao wfDbTableDao;
    @Autowired
    private BaseDao baseDao;
    @Autowired
    private IBaseService baseService;
    @Resource(name="defaultArgConversionService")
    private IArgConversionService argConversionService;
    @Resource(name="sequenceProcGenerator")
    private ISequenceGenerator sequenceGenerator;

    @Override
    public WfDbColumnsPO selectByPrimaryKey(String key) throws BaseAppException {
        return this.wfDbColumnsDao.selectByPrimaryKey(key);
    }

    @Override
    public List<WfDbColumnsPO> selectByArg(WfDbColumnsPO record) throws BaseAppException {
        logger.debug("selectByArg begin...record={0}", (Object)record);
        WfDbColumnsArg arg = this.argConversionService.invokeArg(WfDbColumnsArg.class, record);
        return this.wfDbColumnsDao.selectByArg(arg);
    }

    @Override
    public Page<WfDbColumnsPO> selectByArgAndPage(WfDbColumnsPO record, Page<WfDbColumnsPO> resultPage) throws BaseAppException {
        logger.debug("selectByArgAndPage begin...record={0}", (Object)record);
        WfDbColumnsArg arg = this.argConversionService.invokeArg(WfDbColumnsArg.class, record);
        resultPage = this.wfDbColumnsDao.selectByArgAndPage(arg, resultPage);
        return resultPage;
    }

    @Override
    public Page<WfDbColumnsPO> queryRecordByPageWithDbName(WfDbColumnsPO record, Page<WfDbColumnsPO> resultPage) throws BaseAppException {
        logger.debug("queryRecordByPageWithDbName begin...record={0}", (Object)record);
        WfDbColumnsArg arg = new WfDbColumnsArg();
        WfDbColumnsArg.WfDbColumnsCriteria criteria = arg.createCriteria();
        arg.setIsSearch(null);
        if (Utils.notEmpty(record.getTableName())) {
            criteria.andTableNameEqualTo(record.getTableName());
            arg.setIsSearch("yes");
        }
        if (Utils.notEmpty(record.getColumnName())) {
            criteria.andColumnNameEqualTo(record.getColumnName());
            arg.setIsSearch("yes");
        }
        if (Utils.notEmpty(record.getDisplayName())) {
            criteria.andDisplayNameEqualTo(record.getDisplayName());
            arg.setIsSearch("yes");
        }
        arg.setDbNameFlag(record.getDbName());
        resultPage = this.wfDbColumnsDao.queryRecordByPageWithDbName(arg, resultPage);
        return resultPage;
    }

    @Override
    public int add(WfDbColumnsPO record) throws BaseAppException {
        logger.debug("add begin...record={0}", (Object)record);
        return this.wfDbColumnsDao.insertSelective(record);
    }

    @Override
    public int update(WfDbColumnsPO record) throws BaseAppException {
        logger.debug("update begin...record={0}", (Object)record);
        return this.wfDbColumnsDao.updateByPrimaryKeySelective(record);
    }

    @Override
    public int isExist(WfDbColumnsPO record) throws BaseAppException {
        logger.debug("update begin...record={0}", (Object)record);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tableName", record.getTableName().toUpperCase());
        List<WfDbTablePO> pos = this.wfDbTableDao.selectByMap(map);
        if (pos != null && pos.size() > 0) {
            return 3;
        }
        return 0;
    }

    @Override
    public WfDbColumnsPO convertWfDbColumnsPO(String content, DBTable dbTable) {
        WfDbColumnsPO po = JsonUtil.toBean(content, WfDbColumnsPO.class);
        if ("pk".equals(po.getType())) {
            dbTable.getPks().add(po.getColumnName().toUpperCase());
        } else if ("fk".equals(po.getType())) {
            dbTable.getFks().add(po.getColumnName().toUpperCase());
        }
        DBColumn dbColumn = JsonUtil.toBean(content, DBColumn.class);
        dbColumn.setTableName(dbColumn.getTableName().toUpperCase());
        dbColumn.setColumnName(dbColumn.getColumnName().toUpperCase());
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)(dbColumn.getLength() + ""))) {
            dbColumn.setLength(Integer.parseInt(DBUtils.defaultLength(dbColumn.getDbType())));
        }
        dbTable.getColumns().add(dbColumn);
        po.setTableName(po.getTableName().toUpperCase());
        po.setColumnName(po.getColumnName().toUpperCase());
        DBUtils.defaultLength(po.getDbType());
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)(po.getLength() + ""))) {
            po.setLength(Integer.parseInt(DBUtils.defaultLength(po.getDbType())));
        }
        return po;
    }

    @Override
    public void createTable(List<WfDbColumnsPO> columnsList, WfDbColumnsPO entity, WfDbColumnsPO record) throws Exception {
        String primaryKey = "";
        String columnLength = "";
        HashMap<String, Object> insertMap = new HashMap<String, Object>();
        insertMap.put("sql", "drop table if exists " + entity.getTableName().toUpperCase() + ';');
        this.baseDao.update(insertMap);
        insertMap.put("sql", "drop table if exists " + record.getTableName().toUpperCase() + ';');
        this.baseDao.update(insertMap);
        ArrayList<com.club.web.common.db.po.WfDbColumnsPO> transPoList = new ArrayList<com.club.web.common.db.po.WfDbColumnsPO>();
        for (WfDbColumnsPO column : columnsList) {
            if ("pk".equals(column.getType()) && ("INT".equals(column.getDbType()) || "BIGINT".equals(column.getDbType()) || "TINYINT".equals(column.getDbType()))) {
                primaryKey = column.getColumnName().toUpperCase();
                columnLength = column.getLength() == null || column.getLength() == 0 ? DBUtils.defaultLength(column.getDbType()) : column.getLength().toString();
            }
            transPoList.add(this.convert(column));
        }
        String sql = DBUtils.generalSql(transPoList);
        insertMap.put("sql", sql);
        this.baseDao.update(insertMap);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)primaryKey)) {
            insertMap.put("sql", "delete from init_id  where  table_name= '" + entity.getTableName().toUpperCase() + "' and schema_name='" + record.getDbName().toUpperCase() + "'; ");
            this.baseDao.update(insertMap);
            insertMap.put("sql", "delete from init_id  where  table_name= '" + record.getTableName().toUpperCase() + "' and schema_name='" + record.getDbName().toUpperCase() + "'; ");
            this.baseDao.update(insertMap);
            this.baseService.insert("INIT_ID", this.convertInitIdData(record, entity, primaryKey, columnLength));
        }
    }

    private com.club.web.common.db.po.WfDbColumnsPO convert(WfDbColumnsPO entity) {
        com.club.web.common.db.po.WfDbColumnsPO po = new com.club.web.common.db.po.WfDbColumnsPO();
        po.setColumnName(entity.getColumnName().toUpperCase());
        po.setDbType(entity.getDbType());
        po.setDefaultValue(entity.getDefaultValue());
        po.setDisplayName(entity.getDisplayName());
        po.setIsNull(entity.getIsNull());
        po.setTableName(entity.getTableName().toUpperCase());
        po.setType(entity.getType());
        po.setLength(entity.getLength());
        return po;
    }

    private Map<String, Object> convertInitIdData(WfDbColumnsPO record, WfDbColumnsPO entity, String primaryKey, String columnLength) {
        HashMap<String, Object> initEntityMap = new HashMap<String, Object>();
        initEntityMap.put("tableName", entity.getTableName().toUpperCase());
        initEntityMap.put("columnName", primaryKey.toUpperCase());
        initEntityMap.put("schemaName", record.getDbName().toUpperCase());
        initEntityMap.put("dataType", "1");
        initEntityMap.put("idLength", columnLength);
        initEntityMap.put("refCode", "1");
        initEntityMap.put("refType", "1");
        initEntityMap.put("currentValue", "0");
        initEntityMap.put("idStep", "1");
        return initEntityMap;
    }

    @Override
    public void saveTableAndColumns(List<WfDbColumnsPO> columns, WfDbColumnsPO record, DBTable dbTable) throws Exception {
        WfDbColumnsArg.WfDbColumnsCriteria criteria;
        WfDbColumnsArg arg;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)record.getTableName())) {
            arg = new WfDbColumnsArg();
            criteria = arg.createCriteria();
            criteria.andTableNameEqualTo(record.getTableName());
            this.wfDbColumnsDao.deleteByArg(arg);
        }
        if (!record.getTableName().toUpperCase().trim().equals(dbTable.getTableName()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dbTable.getTableName())) {
            arg = new WfDbColumnsArg();
            criteria = arg.createCriteria();
            criteria.andTableNameEqualTo(dbTable.getTableName());
            this.wfDbColumnsDao.deleteByArg(arg);
        }
        this.getWfDbColumnsPOs(record, dbTable);
        this.wfDbColumnsDao.insertBatch(columns);
    }

    private void getWfDbColumnsPOs(WfDbColumnsPO record, DBTable dbTable) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String oldName = record.getTableName().toUpperCase();
        String newName = dbTable.getTableName();
        map.put("tableName", oldName);
        List<WfDbTablePO> pos = this.wfDbTableDao.selectByMap(map);
        if (!CollectionUtils.isEmpty(pos)) {
            WfDbTablePO table = pos.get(0);
            String newRemarks = record.getDisplayName();
            if (!newName.equals(table.getTableName().toUpperCase()) || !newRemarks.equals(table.getRemarks())) {
                WfDbTableArg wfDbTableArg = new WfDbTableArg();
                WfDbTableArg.WfDbTableCriteria wfDbTableCriteria = wfDbTableArg.createCriteria();
                wfDbTableCriteria.andTableNameEqualTo(table.getTableName().toUpperCase());
                table.setTableName(newName);
                table.setRemarks(record.getDisplayName());
                this.wfDbTableDao.updateByArg(table, wfDbTableArg);
            }
            this.convertDbMeta(dbTable, oldName);
        } else {
            WfDbTablePO po = this.convertWfDbTablePO(record, newName);
            this.wfDbTableDao.insert(po);
            this.parse(po, dbTable);
            DBMeta cacheMeta = DBMetaCache.getMeta();
            cacheMeta.getTables().add(dbTable);
            DBMetaCache.setMeta(cacheMeta);
        }
    }

    private WfDbTablePO convertWfDbTablePO(WfDbColumnsPO record, String tableName) {
        WfDbTablePO po = new WfDbTablePO();
        po.setTableName(tableName);
        po.setDbName(record.getDbName().toUpperCase());
        po.setSource("USR");
        po.setRemarks(record.getDisplayName());
        po.setModifyTime(new Date());
        return po;
    }

    private void parse(WfDbTablePO po, DBTable dbTable) {
        dbTable.setDbName(po.getDbName());
        dbTable.setSource(po.getSource());
        dbTable.setRemarks(po.getRemarks());
        dbTable.setModifyTime(po.getModifyTime());
        for (DBColumn dbColumn1 : dbTable.getColumns()) {
            dbTable.getColumnMap().put(StringUtils.toHump(dbColumn1.getColumnName().toUpperCase()), dbColumn1);
            dbTable.getColumnMap().put(dbColumn1.getColumnName().toUpperCase(), dbColumn1);
            dbTable.getColumnMap().put(dbColumn1.getColumnName(), dbColumn1);
        }
    }

    private void convertDbMeta(DBTable dbTable, String tableName) {
        DBMeta cacheMeta = DBMetaCache.getMeta();
        List<DBTable> cacheMetaTables = cacheMeta.getTables();
        DBTable tempTable = null;
        if (!CollectionUtils.isEmpty(cacheMetaTables)) {
            for (DBTable dbTablePo2 : cacheMetaTables) {
                if (!dbTablePo2.getTableName().toUpperCase().equals(tableName)) continue;
                tempTable = dbTablePo2;
                break;
            }
        }
        if (tempTable != null) {
            cacheMetaTables.remove(tempTable);
            tempTable.getColumnMap().clear();
            tempTable.setPks(dbTable.getPks());
            tempTable.setFks(dbTable.getFks());
            tempTable.setColumns(dbTable.getColumns());
            tempTable.setTableName(dbTable.getTableName());
            tempTable.setRemarks(dbTable.getRemarks());
            for (DBColumn dbColumn1 : dbTable.getColumns()) {
                tempTable.getColumnMap().put(StringUtils.toHump(dbColumn1.getColumnName().toUpperCase()), dbColumn1);
                tempTable.getColumnMap().put(dbColumn1.getColumnName().toUpperCase(), dbColumn1);
                tempTable.getColumnMap().put(dbColumn1.getColumnName(), dbColumn1);
            }
            cacheMetaTables.add(tempTable);
            cacheMeta.setTables(cacheMetaTables);
        }
        DBMetaCache.setMeta(cacheMeta);
    }

    @Override
    public int delete(WfDbColumnsPO record) throws BaseAppException {
        logger.debug("delete begin...record={0}", (Object)record);
        return this.wfDbColumnsDao.deleteByPrimaryKey(record.getTableName());
    }

    @Override
    public int deleteBatch(String deleteRecords) throws BaseAppException {
        logger.debug("deleteBatch record begin...deleteRecords={0}", (Object)deleteRecords);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)deleteRecords)) {
            deleteRecords = deleteRecords.substring(1, deleteRecords.length() - 1);
            String[] records = deleteRecords.split("},");
            Map<String, Object> map = null;
            WfDbColumnsArg arg = null;
            WfDbColumnsArg.WfDbColumnsCriteria criteria = null;
            for (int i = 0; i < records.length; ++i) {
                map = records.length == 1 || records.length > 1 && records.length == i + 1 ? JsonUtil.toMap(records[i]) : JsonUtil.toMap(records[i] + "}");
                arg = new WfDbColumnsArg();
                criteria = arg.createCriteria();
                criteria.andTableNameEqualTo((String)map.get("tableName"));
                criteria.andColumnNameEqualTo((String)map.get("columnName"));
                this.wfDbColumnsDao.deleteByArg(arg);
            }
        }
        return 1;
    }
}

