/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.datamodel.service.impl;

import com.club.core.common.Page;
import com.club.core.convert.IArgConversionService;
import com.club.core.db.dao.BaseDao;
import com.club.core.idproduce.ISequenceGenerator;
import com.club.framework.exception.BaseAppException;
import com.club.framework.log.ClubLogManager;
import com.club.framework.util.DBUtils;
import com.club.framework.util.StringUtils;
import com.club.web.common.cache.DBMetaCache;
import com.club.web.common.service.IBaseService;
import com.club.web.common.vo.DBMeta;
import com.club.web.common.vo.DBTable;
import com.club.web.datamodel.db.arg.WfDbColumnsArg;
import com.club.web.datamodel.db.arg.WfDbTableArg;
import com.club.web.datamodel.db.dao.WfDbColumnsDao;
import com.club.web.datamodel.db.dao.WfDbTableDao;
import com.club.web.datamodel.db.po.WfDbTablePO;
import com.club.web.datamodel.service.IWfDbTableService;
import com.club.web.datasource.db.dao.WfDataSetDao;
import com.club.web.datasource.db.po.WfDataSetPO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="wfDbTableService")
public class WfDbTableServiceImpl
implements IWfDbTableService {
    private static final ClubLogManager logger = ClubLogManager.getLogger(WfDbTableServiceImpl.class);
    @Autowired
    private WfDbTableDao wfDbTableDao;
    @Autowired
    private WfDbColumnsDao wfDbColumnsDao;
    @Autowired
    private IBaseService baseService;
    @Autowired
    private BaseDao baseDao;
    @Autowired
    private WfDataSetDao wfDataSetDao;
    @Resource(name="defaultArgConversionService")
    private IArgConversionService argConversionService;
    @Resource(name="sequenceProcGenerator")
    private ISequenceGenerator sequenceGenerator;

    @Override
    public WfDbTablePO selectByPrimaryKey(Integer key) throws BaseAppException {
        return this.wfDbTableDao.selectByPrimaryKey(key);
    }

    @Override
    public List<WfDbTablePO> selectByArg(WfDbTablePO record) throws BaseAppException {
        logger.debug("selectByArg begin...record={0}", (Object)record);
        WfDbTableArg arg = new WfDbTableArg();
        WfDbTableArg.WfDbTableCriteria criteria = arg.createCriteria();
        if (StringUtils.isNotEmpty(record.getTableName())) {
            criteria.andTableNameEqualTo(record.getTableName());
        }
        return this.wfDbTableDao.selectByArg(arg);
    }

    @Override
    public Page<WfDbTablePO> selectByArgAndPage(WfDbTablePO record, Page<WfDbTablePO> resultPage) throws BaseAppException {
        logger.debug("selectByArgAndPage begin...record={0}", (Object)record);
        WfDbTableArg arg = this.argConversionService.invokeArg(WfDbTableArg.class, record);
        resultPage = this.wfDbTableDao.selectByArgAndPage(arg, resultPage);
        return resultPage;
    }

    @Override
    public List<Object> getDataListByIdAndColumns(String name, String columns) throws BaseAppException {
        logger.debug("getData begin...dataSetId={0}", (Object)(name + columns));
        ArrayList<Object> listObj = new ArrayList<Object>();
        String sql = this.getDataSetSql(name, true);
        String sqlNew = "select ";
        String columnMessage = "";
        if (StringUtils.isNotEmpty(columns)) {
            String[] columnArray = columns.split(",");
            for (int i = 0; i < columnArray.length; ++i) {
                columnMessage = columnMessage + ",t." + columnArray[i];
            }
            columnMessage = columnMessage.substring(1);
        } else {
            columnMessage = " t.* ";
        }
        sqlNew = sqlNew + columnMessage + " from (" + sql + ") t";
        HashMap<String, Object> conditions = new HashMap<String, Object>();
        conditions.put("sql", DBUtils.getCountSql(sql));
        Map<String, Object> r = this.baseDao.selectOne(conditions);
        int count = Integer.parseInt(r.get("count").toString());
        conditions.put("sql", sqlNew);
        conditions.put("start", 0);
        conditions.put("limit", count);
        List<Map<String, Object>> result = this.baseService.selectPage(conditions, true).getResultList();
        if (result.size() > 0 && result != null) {
            for (Map<String, Object> map : result) {
                listObj.add(map.get(columns));
            }
        }
        return listObj;
    }

    @Override
    public Page<Map<String, Object>> getDataListByIdAndColumns(String name, String columns, Page<Map<String, Object>> resultPage) throws BaseAppException {
        logger.debug("getData begin...dataSetId={0}", (Object)(name + columns));
        String sql = this.getDataSetSql(name, true);
        if (StringUtils.isEmpty(sql)) {
            return resultPage;
        }
        String sqlNew = "select ";
        String columnMessage = "";
        if (StringUtils.isNotEmpty(columns)) {
            String[] columnArray = columns.split(",");
            for (int i = 0; i < columnArray.length; ++i) {
                columnMessage = columnMessage + ",t." + columnArray[i] + " as " + columnArray[i];
            }
            columnMessage = columnMessage.substring(1);
        } else {
            columnMessage = " t.* ";
        }
        sqlNew = sqlNew + columnMessage + " from (" + sql + ") t";
        HashMap<String, Object> conditions = new HashMap<String, Object>();
        conditions.put("sql", sqlNew);
        conditions.put("start", resultPage.getStart());
        conditions.put("limit", resultPage.getLimit());
        resultPage = this.baseService.selectPage(conditions, true);
        return resultPage;
    }

    @Override
    public Page<Map<String, Object>> getData(Integer dataSetId, Page<Map<String, Object>> resultPage, HttpServletResponse response) throws BaseAppException {
        logger.debug("getData begin...dataSetId={0}", (Object)dataSetId);
        HashMap<String, Object> conditions = new HashMap<String, Object>();
        conditions.put("sql", this.getDataSetSql(dataSetId, false));
        conditions.put("start", resultPage.getStart());
        conditions.put("limit", resultPage.getLimit());
        Page<Map<String, Object>> result = this.baseService.selectPage(conditions, true);
        return result;
    }

    @Override
    public Page<Map<String, Object>> getData(String name, Page<Map<String, Object>> resultPage, HttpServletResponse response) throws BaseAppException {
        logger.debug("getData begin...dataSetId={0}", (Object)name);
        Page<Map<String, Object>> result = this.baseService.selectPage(this.buildConditions(name, resultPage, response), true);
        return result;
    }

    @Override
    public Page<Map<String, Object>> getDataNoHump(String name, Page<Map<String, Object>> resultPage, HttpServletResponse response) throws BaseAppException {
        logger.debug("getDataNoHump begin...dataSetId={0}", (Object)name);
        Page<Map<String, Object>> result = this.baseService.selectPage(this.buildConditions(name, resultPage, response), false);
        return result;
    }

    private Map<String, Object> buildConditions(String name, Page<Map<String, Object>> resultPage, HttpServletResponse response) throws BaseAppException {
        String resultStr = this.getDataSetSql(name, true);
        if (resultStr.indexOf("http://") > -1 || resultStr.indexOf("https://") > -1) {
            try {
                response.sendRedirect(resultStr);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        }
        resultPage.getConditons().put("sql", this.getDataSetSql(name, true));
        resultPage.getConditons().put("start", resultPage.getStart());
        resultPage.getConditons().put("limit", resultPage.getLimit());
        return resultPage.getConditons();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getDataSetSql(Object dataSetIdOrName, boolean nameOrId) throws BaseAppException {
        WfDataSetPO dataSetPO = null;
        if (nameOrId) {
            HashMap<String, Object> searchMap = new HashMap<String, Object>();
            searchMap.put("name", (String)dataSetIdOrName);
            searchMap.put("status", "0");
            List<WfDataSetPO> dataSetPOs = this.wfDataSetDao.selectByMap(searchMap);
            if (dataSetPOs == null) return "";
            if (dataSetPOs.size() <= 0) return "";
            dataSetPO = dataSetPOs.get(0);
        } else {
            dataSetPO = this.wfDataSetDao.selectByPrimaryKey((Integer)dataSetIdOrName);
            if (dataSetPO == null) {
                return "";
            }
        }
        String sql = "";
        String columnMessage = "";
        String tableMessage = "";
        if (!"1".equals(dataSetPO.getDataSetType())) return dataSetPO.getDataUrl();
        String columns = dataSetPO.getColumns();
        String displayColumns = dataSetPO.getDisplayColumns();
        if (StringUtils.isNotEmpty(columns)) {
            String[] columnArray = columns.split(",");
            String[] displayColumnArray = displayColumns.split(",");
            for (int i = 0; i < columnArray.length; ++i) {
                columnMessage = columnMessage + "," + columnArray[i] + " as '" + displayColumnArray[i] + "'";
            }
            columnMessage = columnMessage.substring(1);
        }
        String tables = dataSetPO.getTableGroup();
        String conditions = dataSetPO.getJoinGroup();
        String onConditions = dataSetPO.getOnGroup();
        String whereParams = dataSetPO.getWhereParams();
        if (whereParams != null && whereParams.length() > 0) {
            whereParams = " where " + whereParams;
        }
        if (StringUtils.isNotEmpty(tables)) {
            String[] tableArray = tables.split(",");
            String[] conditionArray = conditions.split(",");
            String[] onConditionArray = onConditions.split(",");
            if (tables.indexOf(",") == -1) {
                tableMessage = tables;
            } else {
                tableMessage = tableArray[0] + " ";
                for (int j = 0; j < conditionArray.length; ++j) {
                    tableMessage = tableMessage + " " + conditionArray[j] + " " + tableArray[j + 1] + " on " + onConditionArray[j] + " ";
                }
            }
        }
        if (columnMessage.length() != 0) return "select " + columnMessage + " from  " + tableMessage + whereParams;
        columnMessage = "*";
        return "select " + columnMessage + " from  " + tableMessage + whereParams;
    }

    @Override
    public int add(WfDbTablePO record) throws BaseAppException {
        logger.debug("add begin...record={0}", (Object)record);
        return this.wfDbTableDao.insertSelective(record);
    }

    @Override
    public int update(WfDbTablePO record) throws BaseAppException {
        logger.debug("update begin...record={0}", (Object)record);
        return this.wfDbTableDao.updateByPrimaryKeySelective(record);
    }

    @Override
    public int delete(WfDbTablePO record) throws BaseAppException {
        logger.debug("delete begin...record={0}", (Object)record);
        WfDbColumnsArg arg = new WfDbColumnsArg();
        WfDbColumnsArg.WfDbColumnsCriteria criteria = arg.createCriteria();
        criteria.andTableNameEqualTo(record.getTableName());
        this.wfDbColumnsDao.deleteByArg(arg);
        this.wfDbTableDao.deleteByPrimaryKey(record.getTableName());
        HashMap<String, Object> insertMap = new HashMap<String, Object>();
        insertMap.put("sql", "drop table if exists " + record.getTableName() + " ;");
        this.baseDao.update(insertMap);
        insertMap.put("sql", "delete from init_id where schema_name='" + record.getDbName().toUpperCase() + "' and table_name='" + record.getTableName().toUpperCase() + "';");
        this.baseDao.update(insertMap);
        DBMeta cacheMeta = DBMetaCache.getMeta();
        List<DBTable> cacheMetaTables = cacheMeta.getTables();
        if (cacheMetaTables != null && cacheMetaTables.size() > 0) {
            String left = "";
            String right = "";
            right = record.getTableName();
            for (DBTable dbTablePo2 : cacheMetaTables) {
                left = dbTablePo2.getTableName();
                if (!left.equals(right)) continue;
                cacheMetaTables.remove(dbTablePo2);
                break;
            }
            cacheMeta.setTables(cacheMetaTables);
        }
        DBMetaCache.setMeta(cacheMeta);
        return 9;
    }
}

