/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.datasource.controller;

import com.club.core.common.Page;
import com.club.framework.exception.BaseAppException;
import com.club.framework.log.ClubLogManager;
import com.club.framework.util.JsonUtil;
import com.club.web.common.service.IBaseService;
import com.club.web.datamodel.service.IWfDbTableService;
import com.club.web.datasource.db.dao.WfDataSetDao;
import com.club.web.datasource.db.po.WfDataSetPO;
import com.club.web.datasource.service.IWfDataSetService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/datasource/wfdataset"})
public class WfDataSetController {
    private static final ClubLogManager logger = ClubLogManager.getLogger(WfDataSetController.class);
    @Autowired
    private IWfDataSetService wfDataSetService;
    @Autowired
    private WfDataSetDao dataSetDao;
    @Autowired
    private IBaseService baseService;
    @Autowired
    private IWfDbTableService wfDbTableService;

    @RequestMapping(value={"index"})
    public String index(Model model) {
        return "datasource/jsp/wfDataSet";
    }

    @RequestMapping(value={"queryRecordByPage"})
    @ResponseBody
    public Page<WfDataSetPO> queryRecordByPage(WfDataSetPO record, Page<WfDataSetPO> resultPage) throws BaseAppException {
        resultPage = this.wfDataSetService.selectByArgAndPage(record, resultPage);
        return resultPage;
    }

    @RequestMapping(value={"add"})
    @ResponseBody
    public WfDataSetPO add(WfDataSetPO record, HttpServletRequest request) throws BaseAppException {
        logger.debug("add record begin...record=[{0}]", (Object)record);
        this.wfDataSetService.add(record, request);
        return record;
    }

    @RequestMapping(value={"verifyDataSetCode"})
    @ResponseBody
    public WfDataSetPO verifyDataSetCode(WfDataSetPO record) throws BaseAppException {
        logger.debug("verifyDataSetCode record begin...record=[{0}]", (Object)record);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", record.getName());
        map.put("status", "0");
        List<WfDataSetPO> pos = this.dataSetDao.selectByMap(map);
        if (pos != null && pos.size() > 0 && !pos.get(0).getDataSetId().equals(record.getDataSetId())) {
            return pos.get(0);
        }
        record.setName("");
        return record;
    }

    @RequestMapping(value={"update"})
    @ResponseBody
    public WfDataSetPO update(WfDataSetPO record, HttpServletRequest request) throws BaseAppException {
        logger.debug("modify record begin...record=[{0}]", (Object)record);
        this.wfDataSetService.update(record, request);
        return record;
    }

    @RequestMapping(value={"delete"})
    @ResponseBody
    public int delete(WfDataSetPO record, HttpServletRequest request) throws BaseAppException {
        logger.debug("delete record begin...record=[{0}]", (Object)record);
        return this.wfDataSetService.delete(record, request);
    }

    @RequestMapping(value={"qryRecordInfo"})
    @ResponseBody
    public WfDataSetPO qryRecordInfo(@RequestParam(value="dataSetId", required=true) Integer dataSetId) throws BaseAppException {
        WfDataSetPO record = this.wfDataSetService.selectByPrimaryKey(dataSetId);
        return record;
    }

    @RequestMapping(value={"getDataByDataSetId"})
    @ResponseBody
    public Page<Map<String, Object>> getDataByDataSetId(@RequestParam(value="dataSetId", required=true) Integer dataSetId, Page<Map<String, Object>> page, HttpServletResponse response) throws BaseAppException {
        page = this.wfDbTableService.getData(dataSetId, page, response);
        return page;
    }

    @RequestMapping(value={"getDataByName"})
    @ResponseBody
    public Page<Map<String, Object>> getDataByName(@RequestParam(value="name", required=true) String name, Page<Map<String, Object>> page, String conditionStr, HttpServletResponse response) throws BaseAppException {
        if (conditionStr != null) {
            page.setConditons(JsonUtil.toMap(conditionStr));
        }
        page = this.wfDbTableService.getData(name, page, response);
        return page;
    }

    @RequestMapping(value={"getDataByNameNoHump"})
    @ResponseBody
    public Page<Map<String, Object>> getDataByNameNoHump(@RequestParam(value="name", required=true) String name, Page<Map<String, Object>> page, HttpServletResponse response) throws BaseAppException {
        page = this.wfDbTableService.getDataNoHump(name, page, response);
        return page;
    }

    @RequestMapping(value={"getTableCombobox"})
    @ResponseBody
    public List<Map<String, Object>> getTableCombobox() throws BaseAppException {
        List<Map<String, Object>> results = this.baseService.selectList("wf_db_table", new HashMap<String, Object>());
        return results;
    }

    @RequestMapping(value={"getTableColumnCombobox"})
    @ResponseBody
    public List<Map<String, Object>> getTableColumnCombobox(@RequestParam(value="tableName", required=true) String tableName) throws BaseAppException {
        HashMap<String, Object> searchParams = new HashMap<String, Object>();
        searchParams.put("tableName", tableName);
        List<Map<String, Object>> results = this.baseService.selectList("wf_db_columns", searchParams);
        return results;
    }

    @RequestMapping(value={"getDataListByIdAndColumns"})
    @ResponseBody
    public List<Object> getDataListByIdAndColumns(@RequestParam(value="name", required=true) String name, @RequestParam(value="columns", required=true) String columns) throws BaseAppException {
        List<Object> results = this.wfDbTableService.getDataListByIdAndColumns(name, columns);
        return results;
    }

    @RequestMapping(value={"getDataPageByIdAndColumns"})
    @ResponseBody
    public Page<Map<String, Object>> getDataPageByIdAndColumns(@RequestParam(value="name", required=true) String name, @RequestParam(value="columns", required=true) String columns, Page<Map<String, Object>> page) throws BaseAppException {
        return this.wfDbTableService.getDataListByIdAndColumns(name, columns, page);
    }
}

