/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.datasource.controller;

import com.club.core.common.Page;
import com.club.framework.exception.BaseAppException;
import com.club.framework.log.ClubLogManager;
import com.club.framework.util.Utils;
import com.club.web.datasource.db.arg.WfGeneralTableColumnsArg;
import com.club.web.datasource.db.dao.WfGeneralTableColumnsDao;
import com.club.web.datasource.db.po.WfGeneralTableColumnsPO;
import com.club.web.datasource.service.IWfGeneralTableColumnsService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/datasource/wfgeneraltablecolumns"})
public class WfGeneralTableColumnsController {
    private static final ClubLogManager logger = ClubLogManager.getLogger(WfGeneralTableColumnsController.class);
    @Autowired
    private IWfGeneralTableColumnsService wfGeneralTableColumnsService;
    @Autowired
    private WfGeneralTableColumnsDao generalTableColumnsDao;

    @RequestMapping(value={"index"})
    public String index(Model model) {
        return "datasource/jsp/wfGeneralTableColumns";
    }

    @RequestMapping(value={"queryRecordByPage"})
    @ResponseBody
    public Page<WfGeneralTableColumnsPO> queryRecordByPage(WfGeneralTableColumnsPO record, Page<WfGeneralTableColumnsPO> resultPage) throws BaseAppException {
        resultPage = this.wfGeneralTableColumnsService.selectByArgAndPage(record, resultPage);
        return resultPage;
    }

    @RequestMapping(value={"add"})
    @ResponseBody
    public WfGeneralTableColumnsPO add(WfGeneralTableColumnsPO record) throws BaseAppException {
        logger.debug("add record begin...record=[{0}]", (Object)record);
        this.wfGeneralTableColumnsService.add(record);
        return record;
    }

    @RequestMapping(value={"update"})
    @ResponseBody
    public WfGeneralTableColumnsPO update(WfGeneralTableColumnsPO record) throws BaseAppException {
        logger.debug("modify record begin...record=[{0}]", (Object)record);
        this.wfGeneralTableColumnsService.update(record);
        return record;
    }

    @RequestMapping(value={"delete"})
    @ResponseBody
    public int delete(WfGeneralTableColumnsPO record) throws BaseAppException {
        logger.debug("delete record begin...record=[{0}]", (Object)record);
        return this.wfGeneralTableColumnsService.delete(record);
    }

    @RequestMapping(value={"qryRecordInfo"})
    @ResponseBody
    public WfGeneralTableColumnsPO qryRecordInfo(@RequestParam(value="columnId", required=true) Integer columnId) throws BaseAppException {
        WfGeneralTableColumnsPO record = this.wfGeneralTableColumnsService.selectByPrimaryKey(columnId);
        return record;
    }

    @RequestMapping(value={"generalTableColumnsList"})
    @ResponseBody
    public List<WfGeneralTableColumnsPO> generalTableColumnsList(HttpServletRequest request) throws BaseAppException {
        WfGeneralTableColumnsArg arg = new WfGeneralTableColumnsArg();
        WfGeneralTableColumnsArg.WfGeneralTableColumnsCriteria criteria = arg.createCriteria();
        criteria.andHiddenEqualTo("0");
        String tableId = request.getParameter("tableId");
        if (Utils.isNumber(tableId)) {
            criteria.andTableIdEqualTo(Integer.parseInt(tableId));
        }
        List<WfGeneralTableColumnsPO> result = this.generalTableColumnsDao.selectByArg(arg);
        return result;
    }
}

