/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.datasource.controller;

import com.club.core.common.Page;
import com.club.framework.exception.BaseAppException;
import com.club.framework.log.ClubLogManager;
import com.club.web.datasource.db.arg.WfGeneralTableArg;
import com.club.web.datasource.db.dao.WfGeneralTableDao;
import com.club.web.datasource.db.po.WfGeneralTablePO;
import com.club.web.datasource.service.IWfGeneralTableService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/datasource/wfgeneraltable"})
public class WfGeneralTableController {
    private static final ClubLogManager logger = ClubLogManager.getLogger(WfGeneralTableController.class);
    @Autowired
    private IWfGeneralTableService wfGeneralTableService;
    @Autowired
    private WfGeneralTableDao wfGeneralTableDao;

    @RequestMapping(value={"index"})
    public String index(Model model) {
        return "datasource/jsp/wfGeneralTable";
    }

    @RequestMapping(value={"queryRecordByPage"})
    @ResponseBody
    public Page<WfGeneralTablePO> queryRecordByPage(WfGeneralTablePO record, Page<WfGeneralTablePO> resultPage) throws BaseAppException {
        resultPage = this.wfGeneralTableService.selectByArgAndPage(record, resultPage);
        return resultPage;
    }

    @RequestMapping(value={"add"})
    @ResponseBody
    public WfGeneralTablePO add(WfGeneralTablePO record) throws BaseAppException {
        logger.debug("add record begin...record=[{0}]", (Object)record);
        this.wfGeneralTableService.add(record);
        return record;
    }

    @RequestMapping(value={"update"})
    @ResponseBody
    public WfGeneralTablePO update(WfGeneralTablePO record) throws BaseAppException {
        logger.debug("modify record begin...record=[{0}]", (Object)record);
        this.wfGeneralTableService.update(record);
        return record;
    }

    @RequestMapping(value={"delete"})
    @ResponseBody
    public int delete(WfGeneralTablePO record) throws BaseAppException {
        logger.debug("delete record begin...record=[{0}]", (Object)record);
        return this.wfGeneralTableService.delete(record);
    }

    @RequestMapping(value={"qryRecordInfo"})
    @ResponseBody
    public WfGeneralTablePO qryRecordInfo(@RequestParam(value="tableId", required=true) Integer tableId) throws BaseAppException {
        WfGeneralTablePO record = this.wfGeneralTableService.selectByPrimaryKey(tableId);
        return record;
    }

    @RequestMapping(value={"generalTableComboBox"})
    @ResponseBody
    public List<WfGeneralTablePO> generalTableComboBox(HttpServletRequest request) throws BaseAppException {
        WfGeneralTableArg arg = new WfGeneralTableArg();
        WfGeneralTableArg.WfGeneralTableCriteria criteria = arg.createCriteria();
        criteria.andIsPageEqualTo("0");
        List<WfGeneralTablePO> result = this.wfGeneralTableDao.selectByArg(arg);
        return result;
    }
}

