/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.datasource.service.impl;

import com.club.core.common.Page;
import com.club.core.convert.IArgConversionService;
import com.club.core.idproduce.ISequenceGenerator;
import com.club.framework.exception.BaseAppException;
import com.club.framework.log.ClubLogManager;
import com.club.web.datasource.db.arg.WfDataSetArg;
import com.club.web.datasource.db.dao.WfDataSetDao;
import com.club.web.datasource.db.po.WfDataSetPO;
import com.club.web.datasource.service.IWfDataSetService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="wfDataSetService")
public class WfDataSetServiceImpl
implements IWfDataSetService {
    private static final ClubLogManager logger = ClubLogManager.getLogger(WfDataSetServiceImpl.class);
    @Autowired
    private WfDataSetDao wfDataSetDao;
    @Resource(name="defaultArgConversionService")
    private IArgConversionService argConversionService;
    @Resource(name="sequenceProcGenerator")
    private ISequenceGenerator sequenceGenerator;

    @Override
    public WfDataSetPO selectByPrimaryKey(Integer key) throws BaseAppException {
        return this.wfDataSetDao.selectByPrimaryKey(key);
    }

    @Override
    public List<WfDataSetPO> selectByArg(WfDataSetPO record) throws BaseAppException {
        logger.debug("selectByArg begin...record={0}", (Object)record);
        WfDataSetArg arg = this.argConversionService.invokeArg(WfDataSetArg.class, record);
        return this.wfDataSetDao.selectByArg(arg);
    }

    @Override
    public Page<WfDataSetPO> selectByArgAndPage(WfDataSetPO record, Page<WfDataSetPO> resultPage) throws BaseAppException {
        logger.debug("selectByArgAndPage begin...record={0}", (Object)record);
        WfDataSetArg arg = new WfDataSetArg();
        WfDataSetArg.WfDataSetCriteria criteria = arg.createCriteria();
        if (StringUtils.isNotBlank((CharSequence)record.getName())) {
            arg.setConditionFlag1("true");
            arg.setParamName(record.getName());
        }
        if (StringUtils.isNotBlank((CharSequence)record.getDisplayName())) {
            arg.setConditionFlag2("true");
            arg.setParamDisplayName(record.getDisplayName());
        }
        resultPage = this.wfDataSetDao.selectByArgAndPage(arg, resultPage);
        return resultPage;
    }

    @Override
    public int add(WfDataSetPO record, HttpServletRequest request) throws BaseAppException {
        logger.debug("add begin...record={0}", (Object)record);
        record.setModifyUser(1);
        int pkId = this.sequenceGenerator.sequenceIntValue("WF_DATA_SET", "DATA_SET_ID");
        record.setDataSetId(pkId);
        record.setStatus("0");
        record.setCreateDate(new Date());
        return this.wfDataSetDao.insertSelective(record);
    }

    @Override
    public int update(WfDataSetPO record, HttpServletRequest request) throws BaseAppException {
        logger.debug("update begin...record={0}", (Object)record);
        record.setModifyUser(1);
        return this.wfDataSetDao.updateByPrimaryKeySelective(record);
    }

    @Override
    public int delete(WfDataSetPO record, HttpServletRequest request) throws BaseAppException {
        logger.debug("delete begin...record={0}", (Object)record);
        WfDataSetPO po = new WfDataSetPO();
        po.setDataSetId(record.getDataSetId());
        po.setModifyUser(1);
        po.setStatus("1");
        return this.wfDataSetDao.updateByPrimaryKeySelective(po);
    }
}

