/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.image.dao.repository;

import com.club.framework.util.BeanUtils;
import com.club.web.image.dao.base.po.Image;
import com.club.web.image.dao.extend.ImageExtendMapper;
import com.club.web.image.domain.ImageDo;
import com.club.web.image.domain.repository.DoRepository;
import com.club.web.image.service.vo.ImageVo;
import com.club.web.util.IdGenerator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class ImageRepository
implements DoRepository {
    @Autowired
    ImageExtendMapper imageDao;

    @Override
    public ImageDo saveImage(ImageDo imageDo) {
        Image image = new Image();
        BeanUtils.copyProperties(imageDo, image);
        this.imageDao.insert(image);
        return imageDo;
    }

    @Override
    public ImageDo create(String url) {
        Image image = new Image();
        ImageDo imageDo = new ImageDo();
        image.setId(IdGenerator.getDefault().nextId());
        image.setGroupid(IdGenerator.getDefault().nextId());
        image.setCreateTime(new Date());
        image.setCreateBy(1L);
        image.setPicUrl(url);
        BeanUtils.copyProperties(image, imageDo);
        return imageDo;
    }

    @Override
    public ImageDo create(long groupId, Long creator, String url) {
        Image image = new Image();
        ImageDo imageDo = new ImageDo();
        image.setId(IdGenerator.getDefault().nextId());
        image.setGroupid(groupId);
        if (creator != null) {
            image.setCreateBy(creator);
        }
        image.setPicUrl(url);
        image.setCreateTime(new Date());
        BeanUtils.copyProperties(image, imageDo);
        return imageDo;
    }

    @Override
    public ImageDo selectImageById(long id) {
        ImageDo imageDo = new ImageDo();
        Image image = this.imageDao.selectByPrimaryKey(id);
        BeanUtils.copyProperties(image, imageDo);
        return imageDo;
    }

    @Override
    public List<ImageDo> selectImagesByGroupId(long groupId) {
        ArrayList<ImageDo> result = new ArrayList<ImageDo>();
        List<Image> list = this.imageDao.selectImagesByGroupId(groupId);
        for (Image image : list) {
            ImageDo ido = new ImageDo();
            BeanUtils.copyProperties(image, ido);
            result.add(ido);
        }
        return result;
    }

    @Override
    public ImageDo selectImageByUrl(String url) {
        ImageDo imageDo = new ImageDo();
        Image image = this.imageDao.selectImageByUrl(url);
        BeanUtils.copyProperties(image, imageDo);
        return imageDo;
    }

    @Override
    public void deleteByGroupId(long groupId) {
        this.imageDao.deleteByGroupId(groupId);
    }

    @Override
    public void updateImage(ImageVo imageVo) {
        Image image = new Image();
        BeanUtils.copyProperties(imageVo, image);
        this.imageDao.updateByPrimaryKey(image);
    }

    @Override
    public void deleteById(long id) {
        this.imageDao.deleteByPrimaryKey(id);
    }
}

