/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.image.service.imp;

import com.club.framework.util.BeanUtils;
import com.club.web.image.domain.ImageDo;
import com.club.web.image.domain.repository.DoRepository;
import com.club.web.image.service.ImageService;
import com.club.web.image.service.vo.ImageVo;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="imageSaveService")
public class ImageServiceImp
implements ImageService {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    DoRepository imageRepository;

    @Override
    public ImageVo saveImage(String url) {
        ImageVo imageVo = new ImageVo();
        ImageDo imageDo = this.imageRepository.create(url);
        imageDo = this.imageRepository.saveImage(imageDo);
        BeanUtils.copyProperties(imageDo, imageVo);
        return imageVo;
    }

    @Override
    public ImageVo selectImageById(long id) {
        ImageVo imageVo = new ImageVo();
        ImageDo imageDo = this.imageRepository.selectImageById(id);
        BeanUtils.copyProperties(imageDo, imageVo);
        return imageVo;
    }

    @Override
    public List<ImageVo> selectImagesByGroupId(long groupId) {
        ArrayList<ImageVo> listVo = new ArrayList<ImageVo>();
        List<ImageDo> listDo = this.imageRepository.selectImagesByGroupId(groupId);
        for (ImageDo imageDo : listDo) {
            ImageVo imageVo = new ImageVo();
            BeanUtils.copyProperties(imageDo, imageVo);
            listVo.add(imageVo);
        }
        return listVo;
    }

    @Override
    public List<ImageVo> selectImagesByUrl(List<String> urlList) {
        ArrayList<ImageVo> voList = new ArrayList<ImageVo>();
        for (String url : urlList) {
            ImageVo imageVo = new ImageVo();
            ImageDo imageDo = this.imageRepository.selectImageByUrl(url);
            BeanUtils.copyProperties(imageDo, imageVo);
            voList.add(imageVo);
        }
        return voList;
    }

    @Override
    public int saveOrUpdateByGroupId(long groupId, Long creator, String[] array) {
        try {
            this.imageRepository.deleteByGroupId(groupId);
            for (int i = 0; i < array.length; ++i) {
                ImageDo imageDo = this.imageRepository.create(groupId, creator, array[i]);
                this.imageRepository.saveImage(imageDo);
            }
            return 1;
        }
        catch (Exception e) {
            System.out.println("Imageservice--\u6309\u7ec4\u66f4\u65b0\u56fe\u7247\u629b\u51fa\u5f02\u5e38\uff01");
            this.logger.error("ImageServiceImp saveOrUpdateByGroupId error : {}", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void updateImage(ImageVo imagevo) {
        this.imageRepository.updateImage(imagevo);
    }

    @Override
    public void deleteById(long id) {
        this.imageRepository.deleteById(id);
    }
}

