/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.module.controller;

import com.club.framework.util.JsonUtil;
import com.club.web.module.constant.CommonTextType;
import com.club.web.module.service.CommonTextService;
import com.club.web.module.vo.CommonTextVo;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/module/text"})
public class CommonTextController {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CommonTextService commonTextService;

    @RequestMapping(value={"/{type}"})
    @ResponseBody
    public CommonTextVo getTextVoByType(@PathVariable String type, HttpServletResponse response) {
        this.logger.debug("CommonText getTextVoByType");
        try {
            return this.commonTextService.findTextVoByType(CommonTextType.getDbDataByName(type));
        }
        catch (Exception e) {
            this.logger.error("CommonText getTextVoByType error:" + e);
            return null;
        }
    }

    @RequestMapping(value={"/mobile/{type}"})
    @ResponseBody
    public CommonTextVo getMobileTextVoByType(@PathVariable String type, HttpServletResponse response) {
        this.logger.debug("CommonText getMobileTextVoByType");
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setContentType("text/json;charset=utf-8");
        try {
            return this.commonTextService.findTextVoByType(CommonTextType.getDbDataByName(type));
        }
        catch (Exception e) {
            this.logger.error("CommonText getMobileTextVoByType error:" + e);
            return null;
        }
    }

    @RequestMapping(value={"/addOrModify"})
    @ResponseBody
    public Map<String, Object> addOrModify(String modelJson) {
        this.logger.debug("CommonText addOrModify");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("code", 0);
        map.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff01");
        try {
            CommonTextVo commonTextVo = JsonUtil.toBean(modelJson, CommonTextVo.class);
            if (this.commonTextService.addOrModify(commonTextVo)) {
                map.put("code", 1);
                map.put("msg", commonTextVo);
            }
        }
        catch (Exception e) {
            map.put("code", 0);
            map.put("msg", "\u64cd\u4f5c\u5f02\u5e38\uff01");
            this.logger.error("CommonText addOrModify error:" + e);
        }
        return map;
    }
}

