/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.module.controller;

import com.club.core.common.Page;
import com.club.framework.util.JsonUtil;
import com.club.framework.util.StringUtils;
import com.club.web.module.service.OpinionService;
import com.club.web.module.vo.OpinionVo;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/module/opinion"})
public class OpinionController {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private OpinionService opinionService;

    @RequestMapping(value={"/list"})
    @ResponseBody
    public Page<Map<String, Object>> list(Page<Map<String, Object>> page, String conditionStr, HttpServletResponse response) {
        this.logger.debug("opinion list ");
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setContentType("text/json;charset=utf-8");
        try {
            if (StringUtils.isNotEmpty(conditionStr) && page != null) {
                page.setConditons(JsonUtil.toMap(conditionStr));
            }
            page = this.opinionService.list(page);
        }
        catch (Exception e) {
            this.logger.error("opinion list error:", (Throwable)e);
        }
        return page;
    }

    @RequestMapping(value={"/add"})
    @ResponseBody
    public Map<String, Object> add(String modelJson, HttpServletResponse response) {
        this.logger.debug("opinion add");
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setContentType("text/json;charset=utf-8");
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", 1);
        result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
        try {
            OpinionVo opinionVo = JsonUtil.toBean(modelJson, OpinionVo.class);
            if (!this.opinionService.add(opinionVo)) {
                result.put("code", 0);
                result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            result.put("code", 0);
            result.put("msg", "\u64cd\u4f5c\u5f02\u5e38\uff01");
            this.logger.error("opinion add error:", (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public Map<String, Object> delete(String ids, HttpServletResponse response) {
        this.logger.debug("opinion delete");
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setContentType("text/json;charset=utf-8");
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", 1);
        result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
        try {
            if (StringUtils.isNotEmpty(ids) && !this.opinionService.deleteByIds(ids)) {
                result.put("code", 0);
                result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            result.put("code", 0);
            result.put("msg", "\u64cd\u4f5c\u5f02\u5e38\uff01");
            this.logger.error("opinion add error:", (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/mobile/add"})
    @ResponseBody
    public Map<String, Object> mobileAdd(String modelJson, HttpServletResponse response) {
        this.logger.debug("opinion mobileAdd");
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setContentType("text/json;charset=utf-8");
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", 1);
        result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
        try {
            OpinionVo opinionVo = JsonUtil.toBean(modelJson, OpinionVo.class);
            if (!this.opinionService.add(opinionVo)) {
                result.put("code", 0);
                result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            result.put("code", 0);
            result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff01" + e.getMessage());
            this.logger.error("opinion mobileAdd error:", (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/mobile/weixin/add"})
    @ResponseBody
    public Map<String, Object> weixinAdd(String modelJson, HttpServletResponse response) {
        this.logger.debug("opinion weixinAdd");
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setContentType("text/json;charset=utf-8");
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", 1);
        result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
        try {
            OpinionVo opinionVo = JsonUtil.toBean(modelJson, OpinionVo.class);
            if (!this.opinionService.weixinAdd(opinionVo)) {
                result.put("code", 0);
                result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            result.put("code", 0);
            result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff01" + e.getMessage());
            this.logger.error("opinion weixinAdd error:", (Throwable)e);
        }
        return result;
    }
}

