/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.module.controller;

import com.club.core.common.Page;
import com.club.framework.util.JsonUtil;
import com.club.framework.util.StringUtils;
import com.club.web.module.constant.PlatformType;
import com.club.web.module.service.VersionService;
import com.club.web.module.vo.VersionVo;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/module/version"})
public class VersionController {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private VersionService versionService;

    @RequestMapping(value={"/list"})
    @ResponseBody
    public Page<Map<String, Object>> list(Page<Map<String, Object>> page, String conditionStr) {
        this.logger.debug("version list ");
        try {
            if (StringUtils.isNotEmpty(conditionStr) && page != null) {
                page.setConditons(JsonUtil.toMap(conditionStr));
            }
            page = this.versionService.list(page);
        }
        catch (Exception e) {
            this.logger.error("version list error:", (Throwable)e);
        }
        return page;
    }

    @RequestMapping(value={"/mobile/check"})
    @ResponseBody
    public Map<String, Object> checkLastVersion(String type, String name, String code, HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setContentType("text/json;charset=utf-8");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("code", 0);
        map.put("msg", "");
        try {
            VersionVo versionVo = this.versionService.getLastVersionVo(PlatformType.getDbDataByName(type));
            if (versionVo != null && versionVo.getCode() != null && code != null && (long)versionVo.getCode().intValue() > Long.valueOf(code)) {
                map.put("code", 1);
                map.put("msg", versionVo.getName());
                map.put("versionType", versionVo.getStatus());
                map.put("downloadWay", versionVo.getDownloadWay());
                map.put("url", versionVo.getUrl());
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        return map;
    }

    @RequestMapping(value={"/{action}"})
    @ResponseBody
    public Map<String, Object> updateEffect(@PathVariable String action, String ids, HttpServletRequest request) {
        this.logger.debug("version updateEffect ");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("code", 1);
        map.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
        try {
            Map loginMap = (Map)request.getSession().getAttribute("staff");
            String username = loginMap.get("staffName") != null ? (String)loginMap.get("staffName") : "";
            String msg = this.versionService.updateEffect(ids, action, username);
            if (msg != null) {
                map.put("code", 0);
                map.put("msg", msg);
            }
        }
        catch (Exception e) {
            map.put("code", 0);
            map.put("msg", "\u64cd\u4f5c\u5f02\u5e38");
            this.logger.error("version updateEffect error:", (Throwable)e);
        }
        return map;
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public Map<String, Object> delete(String ids) {
        this.logger.debug("version delete ");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("code", 1);
        map.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
        try {
            map = this.versionService.deleteByIds(ids);
        }
        catch (Exception e) {
            map.put("code", 0);
            map.put("msg", "\u64cd\u4f5c\u5931\u8d25");
            this.logger.error("version delete error:", (Throwable)e);
        }
        return map;
    }

    @RequestMapping(value={"/add"})
    @ResponseBody
    public Map<String, Object> add(String modelJson, HttpServletRequest request) {
        this.logger.debug("version add");
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", 1);
        result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
        try {
            String username;
            VersionVo versionVo = JsonUtil.toBean(modelJson, VersionVo.class);
            Map loginMap = (Map)request.getSession().getAttribute("staff");
            String string = username = loginMap.get("staffName") != null ? (String)loginMap.get("staffName") : "";
            if (!this.versionService.add(username, versionVo)) {
                result.put("code", 0);
                result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            result.put("code", 0);
            result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff01" + e.getMessage());
            this.logger.error("version add error:", (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/modify"})
    @ResponseBody
    public Map<String, Object> modify(String modelJson, HttpServletRequest request) {
        this.logger.debug("version modify");
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", 1);
        result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
        try {
            String username;
            VersionVo versionVo = JsonUtil.toBean(modelJson, VersionVo.class);
            Map loginMap = (Map)request.getSession().getAttribute("staff");
            String string = username = loginMap.get("staffName") != null ? (String)loginMap.get("staffName") : "";
            if (!this.versionService.modify(username, versionVo)) {
                result.put("code", 0);
                result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            result.put("code", 0);
            result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff01" + e.getMessage());
            this.logger.error("version modify error:", (Throwable)e);
        }
        return result;
    }
}

