/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.module.dao.repository;

import com.club.web.module.dao.base.po.CommonText;
import com.club.web.module.dao.extend.CommonTextExtendMapper;
import com.club.web.module.domain.CommonTextDo;
import com.club.web.module.domain.repository.CommonTextRepository;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class CommonTextRepositoryImpl
implements CommonTextRepository {
    @Autowired
    private CommonTextExtendMapper commonTextDao;

    @Override
    public CommonTextDo findTextDoByType(int type) {
        return this.getDomainByPo(this.commonTextDao.findTextByType(type));
    }

    @Override
    public CommonTextDo findTextDoById(Long id) {
        return this.getDomainByPo(this.commonTextDao.selectByPrimaryKey(id));
    }

    @Override
    public int add(CommonTextDo commonTextDo) {
        return this.commonTextDao.insert(this.getPoByDomain(commonTextDo));
    }

    @Override
    public int modify(CommonTextDo commonTextDo) {
        return this.commonTextDao.updateByPrimaryKeyWithBLOBs(this.getPoByDomain(commonTextDo));
    }

    private List<CommonText> getPoListByDomainList(List<CommonTextDo> srcs) {
        ArrayList<CommonText> targets = new ArrayList<CommonText>();
        if (srcs != null && srcs.size() != 0) {
            for (CommonTextDo src : srcs) {
                targets.add(this.getPoByDomain(src));
            }
        }
        return targets;
    }

    private List<CommonTextDo> getDomainListByPoList(List<CommonText> srcs) {
        ArrayList<CommonTextDo> targets = new ArrayList<CommonTextDo>();
        if (srcs != null && srcs.size() != 0) {
            for (CommonText src : srcs) {
                targets.add(this.getDomainByPo(src));
            }
        }
        return targets;
    }

    private CommonText getPoByDomain(CommonTextDo src) {
        CommonText target = null;
        if (src != null) {
            target = new CommonText();
            target.setId(src.getId());
            target.setType(src.getType());
            target.setContent(src.getContent());
            target.setFileUrl(src.getFileUrl());
        }
        return target;
    }

    private CommonTextDo getDomainByPo(CommonText src) {
        CommonTextDo target = null;
        if (src != null) {
            target = new CommonTextDo();
            target.setId(src.getId());
            target.setType(src.getType());
            target.setContent(src.getContent());
            target.setFileUrl(src.getFileUrl());
        }
        return target;
    }
}

