/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.module.service.impl;

import com.club.core.common.Page;
import com.club.framework.util.StringUtils;
import com.club.web.module.constant.PlatformType;
import com.club.web.module.constant.VersionEffect;
import com.club.web.module.constant.VersionStatus;
import com.club.web.module.domain.VersionDo;
import com.club.web.module.domain.VersionDo2;
import com.club.web.module.domain.repository.VersionRepository;
import com.club.web.module.service.VersionService;
import com.club.web.module.vo.VersionVo;
import com.club.web.util.CommonUtil;
import com.club.web.util.IdGenerator;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VersionServiceImpl
implements VersionService {
    @Autowired
    private VersionRepository versionRepository;

    @Override
    public VersionVo getLastVersionVo(Integer platform) {
        return this.getVoByDomain(this.versionRepository.getLastVersionDo(platform));
    }

    @Override
    public Page<Map<String, Object>> list(Page<Map<String, Object>> page) {
        int startIndex = 0;
        int pageSize = 10;
        int total = 0;
        List<VersionVo> list = null;
        List<Map<String, Object>> listMap = null;
        if (page != null) {
            startIndex = page.getStart();
            pageSize = page.getLimit();
            Map<String, Object> con = page.getConditons();
            con.put("startIndex", startIndex);
            con.put("pageSize", pageSize);
            total = this.versionRepository.queryTotalByMap(con);
            page.setTotalRecords(total);
            if (total > 0 && (listMap = CommonUtil.listObjTransToListMap(list = this.getVoListByDomainList(this.versionRepository.queryDoByMap(con)))) != null && listMap.size() > 0) {
                page.setResultList(listMap);
            }
        }
        return page;
    }

    @Override
    public String updateEffect(String ids, String effect, String username) {
        if (StringUtils.isNotEmpty(ids) && StringUtils.isNotEmpty(effect)) {
            Date updateTime = new Date();
            if (VersionEffect.\u5931\u6548.getName().equals(effect)) {
                List<VersionDo> doList = this.versionRepository.findDoListByIds(ids);
                for (VersionDo versionDo : doList) {
                    versionDo.updateEffect(effect, username, updateTime);
                }
            } else {
                VersionDo2 versionDo = this.versionRepository.findDoById(Long.valueOf(ids));
                if (versionDo != null && !VersionEffect.\u751f\u6548.equals(versionDo.getEffect())) {
                    if (VersionStatus.\u4f01\u4e1a\u7248.getDbData() == versionDo.getStatus().intValue() && StringUtils.isEmpty(versionDo.getUrl())) {
                        if (PlatformType.\u5b89\u5353.getDbData() == versionDo.getPlatform().intValue()) {
                            return "\u4f01\u4e1a\u7248\u7684'" + versionDo.getName() + "'\u7248\u672c\u751f\u6548\u5931\u8d25\uff1a\u5b89\u5353\u4e0b\u8f7d\u94fe\u63a5\u4e3a\u7a7a\uff01\u8bf7\u586b\u5199\u6570\u636e\uff01";
                        }
                        if (PlatformType.\u82f9\u679c.getDbData() == versionDo.getPlatform().intValue()) {
                            return "\u4f01\u4e1a\u7248\u7684'" + versionDo.getName() + "'\u7248\u672c\u751f\u6548\u5931\u8d25\uff1a\u82f9\u679c\u4e0b\u8f7d\u94fe\u63a5\u4e3a\u7a7a\uff01\u8bf7\u586b\u5199\u6570\u636e\uff01";
                        }
                    }
                    if (VersionStatus.\u6b63\u5f0f\u7248.getDbData() == versionDo.getStatus().intValue() && PlatformType.\u82f9\u679c.getDbData() == versionDo.getPlatform().intValue() && StringUtils.isEmpty(versionDo.getUrl())) {
                        return "\u6b63\u5f0f\u7248\u7684'" + versionDo.getName() + "'\u7248\u672c\u751f\u6548\u5931\u8d25\uff1a\u82f9\u679c\u4e0b\u8f7d\u94fe\u63a5\u4e3a\u7a7a\uff01\u8bf7\u586b\u5199\u6570\u636e\uff01";
                    }
                    List<VersionDo> doAbleList = this.versionRepository.findDoAllAble(versionDo.getPlatform());
                    for (VersionDo doAble : doAbleList) {
                        doAble.updateEffect(VersionEffect.\u5931\u6548.getName(), null, null);
                    }
                    versionDo.updateEffect(effect, username, updateTime);
                }
            }
        }
        return null;
    }

    @Override
    public Map<String, Object> deleteByIds(String ids) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", 1);
        result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
        boolean flag = true;
        List<VersionDo> versionList = this.versionRepository.findDoListByIds(ids);
        for (VersionDo versionDo : versionList) {
            if (VersionEffect.\u751f\u6548.getDbData() != versionDo.getEffect().intValue()) continue;
            flag = false;
            result.put("code", 0);
            result.put("msg", "\u5b58\u5728\u5df2\u751f\u6548\u7248\u672c\uff0c\u8bf7\u5148\u5c06\u7248\u672c\u7f6e\u4e3a\u5931\u6548\u540e\u518d\u8fdb\u884c\u5220\u9664\uff01");
            break;
        }
        if (flag) {
            for (VersionDo versionDo : versionList) {
                versionDo.delete();
            }
        }
        return result;
    }

    @Override
    public boolean add(String username, VersionVo versionVo) {
        versionVo.setId(IdGenerator.getDefault().nextId() + "");
        versionVo.setCreater(username);
        versionVo.setModifier(username);
        versionVo.setUpdateTime(new Date());
        versionVo.setEffect(VersionEffect.\u5931\u6548.getDbData());
        this.getDomainByVo(versionVo).save();
        return true;
    }

    @Override
    public boolean modify(String username, VersionVo versionVo) {
        VersionDo2 target = this.versionRepository.findDoById(Long.valueOf(versionVo.getId()));
        target.setName(versionVo.getName() != null ? versionVo.getName() : "");
        target.setCode(versionVo.getCode());
        target.setDescription(versionVo.getDescription() != null ? versionVo.getDescription() : "");
        target.setStatus(versionVo.getStatus() != null ? versionVo.getStatus() : null);
        target.setUpdateTime(new Date());
        target.setUrl(versionVo.getUrl());
        target.setPlatform(versionVo.getPlatform());
        target.setDownloadWay(versionVo.getDownloadWay());
        target.setModifier(username);
        target.update();
        return true;
    }

    private List<VersionVo> getVoListByDomainList(List<VersionDo> srcs) {
        ArrayList<VersionVo> targets = new ArrayList<VersionVo>();
        if (srcs != null && srcs.size() != 0) {
            for (VersionDo src : srcs) {
                targets.add(this.getVoByDomain(src));
            }
        }
        return targets;
    }

    public VersionVo getVoByDomain(VersionDo src) {
        VersionVo target = null;
        if (src != null) {
            target = new VersionVo();
            target.setId(src.getId() == null ? null : src.getId() + "");
            target.setName(src.getName());
            target.setCode(src.getCode());
            target.setDescription(src.getDescription());
            target.setModifier(src.getModifier());
            target.setCreater(src.getCreater());
            target.setUpdateTime(src.getUpdateTime());
            target.setUrl(src.getUrl());
            target.setPlatform(src.getPlatform());
            target.setStatus(src.getStatus());
            target.setEffect(src.getEffect());
            target.setDownloadWay(src.getDownloadWay());
        }
        return target;
    }

    private VersionDo2 getDomainByVo(VersionVo src) {
        VersionDo2 target = null;
        if (src != null) {
            target = new VersionDo2();
            target.setId(src.getId() == null ? null : Long.valueOf(src.getId()));
            target.setName(src.getName());
            target.setCode(src.getCode());
            target.setDescription(src.getDescription());
            target.setModifier(src.getModifier());
            target.setCreater(src.getCreater());
            target.setUpdateTime(src.getUpdateTime());
            target.setUrl(src.getUrl());
            target.setPlatform(src.getPlatform());
            target.setStatus(src.getStatus());
            target.setEffect(src.getEffect());
            target.setDownloadWay(src.getDownloadWay());
        }
        return target;
    }
}

