/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.security;

import com.club.framework.util.JsonUtil;
import com.club.web.common.Constants;
import com.club.web.common.db.po.StaffT;
import com.club.web.common.service.IBaseService;
import com.club.web.security.JsonResponseWriter;
import com.club.web.store.service.StoreLevelService;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;

@Configurable
public class AjaxAuthenticationSuccessHandler
implements AuthenticationSuccessHandler {
    private static final Logger logger = LoggerFactory.getLogger(AjaxAuthenticationSuccessHandler.class);
    @Autowired
    private IBaseService baseService;
    @Autowired
    private StoreLevelService storeLevelService;
    protected JsonResponseWriter jsonResponseWriter = new JsonResponseWriter();

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        if (logger.isDebugEnabled()) {
            logger.debug("url:" + request.getRequestURI());
        }
        HashMap<String, Object> conditions = new HashMap<String, Object>(2);
        conditions.put("loginName", request.getParameter("username"));
        conditions.put("staffState", Constants.Status.PUBLISH.toString());
        List<Map<String, Object>> list = this.baseService.selectList("staff_t", conditions);
        StaffT staffT = this.storeLevelService.subbranchLogin(request.getParameter("username"));
        HashMap<String, Object> resultmap = new HashMap<String, Object>();
        if (list != null && list.size() > 0) {
            Map<String, Object> userMap = list.get(0);
            userMap.put("roleId", "system");
            request.getSession().setAttribute("staff", userMap);
            resultmap.put("code", 0);
            resultmap.put("msg", "\u767b\u5f55\u6210\u529f!");
        } else if (staffT != null) {
            Map<String, Object> userMap = JsonUtil.toMap(staffT);
            request.getSession().setAttribute("staff", userMap);
            resultmap.put("code", 0);
            resultmap.put("msg", "\u767b\u5f55\u6210\u529f!");
        } else {
            resultmap.put("code", 1);
            resultmap.put("msg", "\u767b\u5f55\u5931\u8d25!");
        }
        response.setHeader("Set-Cookie", "JSESSIONID=" + request.getSession().getId() + "; Path=" + request.getContextPath() + "/; HttpOnly");
        this.jsonResponseWriter.writeAsUTF_8(response, resultmap);
    }
}

