/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.stock.controller;

import com.club.core.common.Page;
import com.club.framework.util.JsonUtil;
import com.club.web.stock.service.CargoBaseSkuTypeService;
import com.club.web.stock.vo.CargoBaseSkuTypeVo;
import com.club.web.util.IdGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/cargoBaseSkuTypeController"})
public class CargoBaseSkuTypeController {
    @Autowired
    private CargoBaseSkuTypeService cargoBaseSkuTypeService;

    @RequestMapping(value={"/addOrUpdCargoBaseSkuType"})
    @ResponseBody
    public Map<String, Object> addBaseSkuType(String modelJson) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        CargoBaseSkuTypeVo cargoBaseSkuTypeVo = JsonUtil.toBean(modelJson, CargoBaseSkuTypeVo.class);
        if (cargoBaseSkuTypeVo != null) {
            if (cargoBaseSkuTypeVo.getId() != null && !cargoBaseSkuTypeVo.getId().isEmpty()) {
                result.put("success", true);
                result.put("msg", "\u7f16\u8f91\u6210\u529f");
                this.cargoBaseSkuTypeService.editBaseSkuType(cargoBaseSkuTypeVo);
            } else {
                result.put("success", true);
                result.put("msg", "\u65b0\u589e\u6210\u529f");
                cargoBaseSkuTypeVo.setId(IdGenerator.getDefault().nextId() + "");
                this.cargoBaseSkuTypeService.addBaseSkuType(cargoBaseSkuTypeVo);
            }
        } else {
            result.put("success", false);
            result.put("msg", "\u65b0\u589e\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(value={"/selectCargoBaseSkuType"}, method={RequestMethod.POST})
    @ResponseBody
    public Page<Map<String, Object>> selectBySkuNameAndSkuType(Page<Map<String, Object>> page, String skuName, String skuType, HttpServletResponse response) {
        page = this.cargoBaseSkuTypeService.selectBySkuNameAndSkuType(page, skuName, skuType);
        return page;
    }

    @RequestMapping(value={"/deleteCargoBaseSkuType"})
    @ResponseBody
    public Map<String, Object> deleteBaseSkuType(String idStr) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (idStr != null) {
            result.put("success", true);
            result.putAll(this.cargoBaseSkuTypeService.deleteBaseSkuType(idStr));
        } else {
            result.put("success", false);
            result.put("msg", "\u89c4\u683cID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return result;
    }

    @RequestMapping(value={"/selectCargoBaseSkuTypeList"})
    @ResponseBody
    public List<CargoBaseSkuTypeVo> selectCargoBaseSkuTypeList() {
        return this.cargoBaseSkuTypeService.selectCargoBaseSkuTypeList();
    }
}

