/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.stock.controller;

import com.club.core.common.Page;
import com.club.framework.util.JsonUtil;
import com.club.web.stock.service.CargoBrandService;
import com.club.web.stock.vo.CargoBrandVo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/cargoBrand"})
public class CargoBrandController {
    private Logger logger = LoggerFactory.getLogger(CargoBrandController.class);
    @Autowired
    private CargoBrandService cargoBrandService;

    @RequestMapping(value={"/saveOrUpdateCargoBrand"})
    @ResponseBody
    public Map<String, Object> saveOrUpdateCargoBrand(@RequestParam(value="modelJson", required=true) String modelJson, HttpServletRequest request) {
        this.logger.debug("saveOrUpdateCargoBrand ");
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            if (modelJson != null && !"".equals(modelJson)) {
                CargoBrandVo cargoBrandVo = JsonUtil.toBean(modelJson, CargoBrandVo.class);
                if (cargoBrandVo == null) {
                    result.put("success", false);
                    result.put("msg", "\u54c1\u724c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                } else {
                    result.putAll(this.cargoBrandService.saveOrUpdateCargoBrand(cargoBrandVo, request));
                }
            } else {
                result.put("success", false);
                result.put("msg", "\u54c1\u724c\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4modelJson\u53c2\u6570\u4e0d\u4e3a\u7a7a\uff0c\u4e14\u4e3ajson\u683c\u5f0f");
            }
        }
        catch (Exception e) {
            this.logger.error("\u7f16\u8f91\u54c1\u724c\u5f02\u5e38<saveOrUpdateCargoBrandCon>:", (Throwable)e);
            result.put("success", false);
            result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff01");
        }
        return result;
    }

    @RequestMapping(value={"/deleteCargoBrand"})
    @ResponseBody
    public Map<String, Object> deleteCargoBrand(@RequestParam(value="IdStr", required=true) String IdStr) {
        HashMap<String, Object> result;
        block2: {
            this.logger.debug("deleteCargoBrand ");
            result = new HashMap<String, Object>();
            try {
                result.putAll(this.cargoBrandService.deleteCargoBrand(IdStr));
            }
            catch (Exception e) {
                this.logger.error("\u5220\u9664\u54c1\u724c\u5f02\u5e38<deleteCargoBrandCon>:", (Throwable)e);
                result.put("success", false);
                result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff01");
                if (!(e instanceof DataIntegrityViolationException)) break block2;
                result.put("msg", "\u5220\u9664\u9009\u62e9\u9879\u5df2\u7ecf\u88ab\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\uff01");
            }
        }
        return result;
    }

    @RequestMapping(value={"/cargoBrandPage"})
    @ResponseBody
    public Page<Map<String, Object>> cargoBrandPage(Page<Map<String, Object>> page, String conditionStr, HttpServletResponse response) {
        if (conditionStr != null) {
            page.setConditons(JsonUtil.toMap(conditionStr));
        }
        page = this.cargoBrandService.queryCargoBrandPage(page);
        return page;
    }

    @RequestMapping(value={"/findListAll"})
    @ResponseBody
    public List<CargoBrandVo> findListAll() {
        List<CargoBrandVo> list = null;
        try {
            list = this.cargoBrandService.findListAll();
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6240\u6709\u54c1\u724c\u5f02\u5e38<findListAllCargoBrandCon>:", (Throwable)e);
        }
        return list;
    }
}

