/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.stock.controller;

import com.club.core.common.Page;
import com.club.framework.exception.BaseAppException;
import com.club.framework.log.ClubLogManager;
import com.club.framework.util.JsonUtil;
import com.club.web.stock.constant.CargoClassifyStatus;
import com.club.web.stock.service.CargoClassifyService;
import com.club.web.stock.vo.CargoClassifyAppVo;
import com.club.web.stock.vo.CargoClassifyVo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/cargo/classify"})
public class CargoClassifyController {
    private ClubLogManager logger = ClubLogManager.getLogger(this.getClass());
    @Autowired
    private CargoClassifyService cargoClassifyService;

    @RequestMapping(value={"/list"})
    @ResponseBody
    public Page<CargoClassifyVo> list() throws BaseAppException {
        this.logger.debug("cargoclassify list ");
        Page<CargoClassifyVo> page = new Page(0, Integer.MAX_VALUE);
        try {
            page = this.cargoClassifyService.list();
        }
        catch (Exception e) {
            this.logger.error("cargoclassify list error:", e);
        }
        return page;
    }

    @RequestMapping(value={"/detail"})
    @ResponseBody
    public CargoClassifyVo detail(String id, Integer status) throws BaseAppException {
        this.logger.debug("cargoclassify detail ");
        CargoClassifyVo vo = new CargoClassifyVo();
        try {
            vo = this.cargoClassifyService.findVoByIdAndStatus(Long.valueOf(id), status);
        }
        catch (Exception e) {
            this.logger.error("cargoclassify detail error:", e);
        }
        return vo;
    }

    @RequestMapping(value={"/{action}"})
    @ResponseBody
    public Map<String, Object> action(String ids, @PathVariable String action, HttpServletRequest request) {
        this.logger.debug("cargoclassify update status '" + action + "' ");
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", 1);
        result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
        try {
            long userId;
            Map loginMap = (Map)request.getSession().getAttribute("staff");
            long l = userId = loginMap.get("staffId") != null ? Long.valueOf(loginMap.get("staffId").toString()) : 0L;
            if (!this.cargoClassifyService.updateStatus(ids, CargoClassifyStatus.getDbDataByName(action), userId)) {
                result.put("code", 0);
                result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            result.put("code", 0);
            result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff01" + e.getMessage());
            this.logger.error("cargoclassify update status '" + action + "' error:", e);
        }
        return result;
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public Map<String, Object> deleteByIds(String ids) {
        this.logger.debug("delete cargoclassify ");
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", 1);
        result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
        try {
            this.cargoClassifyService.deleteByIds(ids);
        }
        catch (Exception e) {
            result.put("code", 0);
            result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff01" + e.getMessage());
            this.logger.error("cargoclassify delete error:", e);
        }
        return result;
    }

    @RequestMapping(value={"/add"})
    @ResponseBody
    public Map<String, Object> add(String modelJson, HttpServletRequest request) {
        this.logger.debug("add cargoclassify ");
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", 1);
        result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
        try {
            long userId;
            CargoClassifyVo cargoClassifyVo = JsonUtil.toBean(modelJson, CargoClassifyVo.class);
            Map loginMap = (Map)request.getSession().getAttribute("staff");
            long l = userId = loginMap.get("staffId") != null ? Long.valueOf(loginMap.get("staffId").toString()) : 0L;
            if (!this.cargoClassifyService.add(userId, cargoClassifyVo)) {
                result.put("code", 0);
                result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            result.put("code", 0);
            result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff01" + e.getMessage());
            this.logger.error("cargoclassify add error:", e);
        }
        return result;
    }

    @RequestMapping(value={"/modify"})
    @ResponseBody
    public Map<String, Object> modify(String modelJson, HttpServletRequest request) {
        this.logger.debug("update cargoclassify ");
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", 1);
        result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
        try {
            long updaterId;
            CargoClassifyVo cargoClassifyVo = JsonUtil.toBean(modelJson, CargoClassifyVo.class);
            Map loginMap = (Map)request.getSession().getAttribute("staff");
            long l = updaterId = loginMap.get("staffId") != null ? Long.valueOf(loginMap.get("staffId").toString()) : 0L;
            if (!this.cargoClassifyService.modify(updaterId, cargoClassifyVo)) {
                result.put("code", 0);
                result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            result.put("code", 0);
            result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff01" + e.getMessage());
            this.logger.error("cargoclassify modify error:", e);
        }
        return result;
    }

    @RequestMapping(value={"/queryByParentId"})
    @ResponseBody
    public List<CargoClassifyVo> queryByParentId(String parentId, Integer status) {
        this.logger.debug("queryByParentId cargoclassify ");
        try {
            return this.cargoClassifyService.getVoListByParentId(Long.valueOf(parentId), status);
        }
        catch (Exception e) {
            this.logger.error("cargoclassify queryByParentId error:", e);
            return null;
        }
    }

    @RequestMapping(value={"/queryParents"})
    @ResponseBody
    public List<CargoClassifyVo> queryParents(Integer status) {
        this.logger.debug("queryParents cargoclassify ");
        try {
            return this.cargoClassifyService.getVoListByParentId(1L, status);
        }
        catch (Exception e) {
            this.logger.error("cargoclassify queryParents error:", e);
            return null;
        }
    }

    @RequestMapping(value={"/mobile/parents"})
    @ResponseBody
    public Object appParents(String parentId, HttpServletResponse response) {
        this.logger.debug("queryParents appParents ");
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setContentType("text/json;charset=utf-8");
        try {
            return this.cargoClassifyService.getAppParents(parentId);
        }
        catch (Exception e) {
            this.logger.error("cargoclassify appParents error:", e);
            return null;
        }
    }

    @RequestMapping(value={"/mobile/firstAndSecondList"})
    @ResponseBody
    public List<CargoClassifyAppVo> mobileFirstAndSecondList(HttpServletResponse response) {
        this.logger.debug("allList mobileFirstAndSecondList ");
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setContentType("text/json;charset=utf-8");
        try {
            return this.cargoClassifyService.mobileFirstAndSecondList();
        }
        catch (Exception e) {
            this.logger.error("cargoclassify mobileFirstAndSecondList error:", e);
            return null;
        }
    }

    @RequestMapping(value={"/allList"})
    @ResponseBody
    public List<CargoClassifyVo> allList(Integer status) {
        this.logger.debug("allList cargoclassify ");
        try {
            return this.cargoClassifyService.getVoAllList(status);
        }
        catch (Exception e) {
            this.logger.error("cargoclassify allList error:", e);
            return null;
        }
    }
}

