/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.stock.controller;

import com.club.core.common.Page;
import com.club.framework.util.JsonUtil;
import com.club.framework.util.StringUtils;
import com.club.framework.util.Utils;
import com.club.web.stock.service.CargoService;
import com.club.web.stock.vo.CargoInfoVo;
import com.club.web.stock.vo.CargoSaveVo;
import com.club.web.stock.vo.CargoSimpleInfoVo;
import com.club.web.stock.vo.CargoSkuSimpleVo;
import java.net.URLDecoder;
import java.sql.BatchUpdateException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/cargo"})
@Controller
public class CargoController {
    private Logger logger = LoggerFactory.getLogger(CargoController.class);
    @Autowired
    private CargoService cargoService;

    @RequestMapping(value={"index"})
    public String index(Model model) {
        return "/test";
    }

    @RequestMapping(value={"/save"})
    @ResponseBody
    public Map<String, Object> save(@RequestParam(value="cargo") String cargoJsonStr, HttpServletRequest request) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", 1);
        result.put("msg", "\u4fdd\u5b58\u6210\u529f");
        try {
            long creatorId = this.getUserId(request);
            this.cargoService.saveCargo(creatorId, JsonUtil.toBean(URLDecoder.decode(cargoJsonStr, "utf-8"), CargoSaveVo.class));
        }
        catch (Exception e) {
            if (e instanceof BatchUpdateException || e instanceof DuplicateKeyException) {
                if (e.getMessage().contains("cargo_sku")) {
                    result.put("msg", "\u8d27\u54c1\u4fdd\u5b58\u5931\u8d25\uff0cSKU\u7f16\u53f7\u5df2\u5b58\u5728");
                } else if (e.getMessage().contains("cargo")) {
                    result.put("msg", "\u8d27\u54c1\u4fdd\u5b58\u5931\u8d25\uff0c\u8d27\u54c1\u7f16\u53f7\u5df2\u5b58\u5728");
                }
            } else {
                result.put("msg", e.getMessage());
            }
            result.put("code", 0);
            this.logger.error("\u4fdd\u5b58\u8d27\u54c1\u5931\u8d25", (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/getList"})
    @ResponseBody
    public Page<CargoSimpleInfoVo> getList(Page<CargoSimpleInfoVo> page, String conditionStr) {
        if (conditionStr != null) {
            page.setConditons(JsonUtil.toMap(conditionStr));
        }
        return this.cargoService.queryCargoList(page);
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public Map<String, Object> delete(String cargoIds) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            boolean flag = this.cargoService.delete(Utils.stringArr2longArr(StringUtils.split(cargoIds, ",")));
            if (flag) {
                result.put("code", 1);
                result.put("msg", "\u5220\u9664\u6210\u529f");
                return result;
            }
            result.put("msg", "\u5220\u9664\u5931\u8d25");
        }
        catch (Exception e) {
            result.put("msg", e.getMessage());
            this.logger.error("\u5220\u9664\u5931\u8d25", (Throwable)e);
        }
        result.put("code", 0);
        return result;
    }

    @RequestMapping(value={"/getSkuList"})
    @ResponseBody
    public List<CargoSkuSimpleVo> getSkuList(long cargoId) {
        try {
            return this.cargoService.getSkuList(cargoId);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6SKU\u5217\u8868\u5931\u8d25", (Throwable)e);
            return new ArrayList<CargoSkuSimpleVo>();
        }
    }

    @RequestMapping(value={"/getInfo"})
    @ResponseBody
    public CargoInfoVo getInfo(long cargoId) {
        try {
            return this.cargoService.getCargoInfo(cargoId);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u8d27\u54c1\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    @RequestMapping(value={"/isSkuCanDelete"})
    @ResponseBody
    public Map<String, Object> isSkuCanDelete(long skuId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            if (this.cargoService.isSkuCanDelete(skuId)) {
                map.put("code", 1);
                map.put("msg", "\u53ef\u4ee5\u5220\u9664");
                return map;
            }
        }
        catch (Exception e) {
            map.put("msg", e.getMessage());
        }
        map.put("code", 0);
        return map;
    }

    private long getUserId(HttpServletRequest request) {
        Map loginMap = (Map)request.getSession().getAttribute("staff");
        long userId = loginMap.get("staffId") != null ? Long.valueOf(loginMap.get("staffId").toString()) : 0L;
        return userId;
    }
}

