/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.stock.controller;

import com.club.core.common.Page;
import com.club.framework.util.JsonUtil;
import com.club.web.stock.service.CargoSupplierService;
import com.club.web.stock.vo.CargoSupplierVo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/cargoSupplier"})
public class CargoSupplierController {
    private Logger logger = LoggerFactory.getLogger(CargoSupplierController.class);
    @Autowired
    private CargoSupplierService cargoSupplierService;

    @RequestMapping(value={"/saveOrUpdateCargoSupplier"})
    @ResponseBody
    public Map<String, Object> saveOrUpdateCargoSupplier(@RequestParam(value="modelJson", required=true) String modelJson, HttpServletRequest request) {
        this.logger.debug("saveOrUpdateCargoSupplier ");
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            if (modelJson != null && !"".equals(modelJson)) {
                CargoSupplierVo cargoSupplierVo = JsonUtil.toBean(modelJson, CargoSupplierVo.class);
                if (cargoSupplierVo == null) {
                    result.put("success", false);
                    result.put("msg", "\u4f9b\u5e94\u5546\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                } else {
                    result.putAll(this.cargoSupplierService.saveOrUpdateCargoSupplier(cargoSupplierVo, request));
                }
            } else {
                result.put("success", false);
                result.put("msg", "\u4f9b\u5e94\u5546\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4modelJson\u53c2\u6570\u4e0d\u4e3a\u7a7a\uff0c\u4e14\u4e3ajson\u683c\u5f0f");
            }
        }
        catch (Exception e) {
            this.logger.error("\u7f16\u8f91\u4f9b\u5e94\u5546\u5f02\u5e38<saveOrUpdateCargoSupplierCon>:", (Throwable)e);
            result.put("success", false);
            result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff01");
        }
        return result;
    }

    @RequestMapping(value={"/deleteCargoSupplier"})
    @ResponseBody
    public Map<String, Object> deleteCargoSupplier(@RequestParam(value="IdStr", required=true) String IdStr) {
        HashMap<String, Object> result;
        block2: {
            this.logger.debug("deletecargoSupplier ");
            result = new HashMap<String, Object>();
            try {
                result.putAll(this.cargoSupplierService.deleteCargoSupplier(IdStr));
            }
            catch (Exception e) {
                this.logger.error("\u5220\u9664\u4f9b\u5e94\u5546\u5f02\u5e38<deleteCargoSupplierCon>:", (Throwable)e);
                result.put("success", false);
                result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff01");
                if (!(e instanceof DataIntegrityViolationException)) break block2;
                result.put("msg", "\u5220\u9664\u9009\u62e9\u9879\u5df2\u7ecf\u88ab\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\uff01");
            }
        }
        return result;
    }

    @RequestMapping(value={"/cargoSupplierPage"})
    @ResponseBody
    public Page<Map<String, Object>> cargoSupplierPage(Page<Map<String, Object>> page, String conditionStr, HttpServletResponse response) {
        if (conditionStr != null) {
            page.setConditons(JsonUtil.toMap(conditionStr));
        }
        page = this.cargoSupplierService.queryCargoSupplierPage(page);
        return page;
    }

    @RequestMapping(value={"/findListAll"})
    @ResponseBody
    public List<CargoSupplierVo> findListAll() {
        List<CargoSupplierVo> list = null;
        try {
            list = this.cargoSupplierService.findListAll();
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6240\u6709\u4f9b\u5e94\u5546\u5f02\u5e38<findListAllCargoSupplierCon>:", (Throwable)e);
        }
        return list;
    }
}

