/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.stock.controller;

import com.club.core.common.Page;
import com.club.framework.util.JsonUtil;
import com.club.framework.util.StringUtils;
import com.club.web.stock.service.StockManagerService;
import com.club.web.stock.vo.TreeListVo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/stock"})
@Controller
public class StockManagerController {
    private Logger logger = LoggerFactory.getLogger(StockManagerController.class);
    @Autowired
    StockManagerService stockService;
    private Map<String, Object> result;

    @RequestMapping(value={"/inbound/queryInboundOrderList"})
    @ResponseBody
    public Page<Map<String, Object>> queryInboundOrderListCon(Page<Map<String, Object>> page, String conditionStr) {
        try {
            if (StringUtils.isNotEmpty(conditionStr) && page != null) {
                page.setConditons(JsonUtil.toMap(conditionStr));
            }
            page = this.stockService.queryInboundOrderListSer(page);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u5165\u5e93\u5355\u5f02\u5e38<queryInboundOrderListCon>:", (Throwable)e);
        }
        return page;
    }

    @RequestMapping(value={"/inbound/queryInboundOrderDetail"})
    @ResponseBody
    public Page<Map<String, Object>> queryInboundOrderDetailCon(Page<Map<String, Object>> page, String conditionStr) {
        try {
            if (StringUtils.isNotEmpty(conditionStr) && page != null) {
                page.setConditons(JsonUtil.toMap(conditionStr));
            }
            page = this.stockService.queryInboundOrderDetailSer(page);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u5165\u5e93\u5355\u660e\u7ec6<queryInboundOrderDetailCon>:", (Throwable)e);
        }
        return page;
    }

    @RequestMapping(value={"/inbound/queryGoodsMsg"})
    @ResponseBody
    public Page<Map<String, Object>> queryGoodsMsgCon(Page<Map<String, Object>> page, String conditionStr) {
        try {
            if (StringUtils.isNotEmpty(conditionStr) && page != null) {
                page.setConditons(JsonUtil.toMap(conditionStr));
            }
            page = this.stockService.queryGoodsMsgSer(page);
        }
        catch (Exception e) {
            this.logger.error("\u6dfb\u52a0\u5165\u5e93-\u67e5\u8be2\u8d27\u54c1\u4fe1\u606f\u5f02\u5e38<queryGoodsMsgCon>:", (Throwable)e);
        }
        return page;
    }

    @RequestMapping(value={"/inbound/queryGoodsSkuMsg"})
    @ResponseBody
    public Page<Map<String, Object>> queryGoodsSkuMsgCon(Page<Map<String, Object>> page, String conditionStr) {
        try {
            if (StringUtils.isNotEmpty(conditionStr) && page != null) {
                page.setConditons(JsonUtil.toMap(conditionStr));
            }
            page = this.stockService.queryGoodsSkuMsgSer(page);
        }
        catch (Exception e) {
            this.logger.error("\u6dfb\u52a0\u5165\u5e93-\u67e5\u8be2\u8d27\u54c1Sku\u4fe1\u606f\u5f02\u5e38<queryGoodsSkuMsgCon>:", (Throwable)e);
        }
        return page;
    }

    @RequestMapping(value={"/inbound/saveGoodsSkuMsg"})
    @ResponseBody
    public Map<String, Object> saveGoodsSkuMsgCon(HttpServletRequest request, String conditionStr) {
        this.result = new HashMap<String, Object>();
        Map<String, Object> paramMap = null;
        try {
            long userId = this.getUserId(request);
            if (StringUtils.isNotEmpty(conditionStr)) {
                paramMap = JsonUtil.toMap(conditionStr);
                this.result = this.stockService.saveInboundStockSer(paramMap, userId);
            } else {
                this.result.put("code", "000001");
                this.result.put("msg", "\u53c2\u6570\u4e3a\u7a7a");
            }
        }
        catch (Exception e) {
            this.result.put("code", "000002");
            this.result.put("msg", "\u64cd\u4f5c\u5931\u8d25");
            this.logger.error("\u4fdd\u5b58\u5165\u5e93\u5355\u4fe1\u606f\u5f02\u5e38<saveGoodsSkuMsgCon>:", (Throwable)e);
        }
        return this.result;
    }

    @RequestMapping(value={"/inbound/updateInboundStatus"})
    @ResponseBody
    public Map<String, Object> updateInboundStatusCon(HttpServletRequest request, String conditionStr) {
        this.result = new HashMap<String, Object>();
        Map<String, Object> paramMap = null;
        try {
            long userId = this.getUserId(request);
            if (StringUtils.isNotEmpty(conditionStr)) {
                paramMap = JsonUtil.toMap(conditionStr);
                this.result = this.stockService.updateInboundStatusSer(paramMap, userId);
            } else {
                this.result.put("code", "000001");
                this.result.put("msg", "\u53c2\u6570\u4e3a\u7a7a");
            }
        }
        catch (Exception e) {
            this.result.put("code", "000002");
            this.result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\uff01");
            this.logger.error("\u4fee\u6539\u5165\u5e93\u5355\u72b6\u6001\u5f02\u5e38<updateInboundStatusCon>:", (Throwable)e);
        }
        return this.result;
    }

    @RequestMapping(value={"/inbound/delInboundOrder"})
    @ResponseBody
    public Map<String, Object> delInboundOrderCon(String conditionStr) {
        this.result = new HashMap<String, Object>();
        Map<String, Object> paramMap = null;
        try {
            if (StringUtils.isNotEmpty(conditionStr)) {
                paramMap = JsonUtil.toMap(conditionStr);
                this.result = this.stockService.delInboundOrderSer(paramMap);
            } else {
                this.result.put("code", "000001");
                this.result.put("msg", "\u53c2\u6570\u4e3a\u7a7a");
            }
        }
        catch (Exception e) {
            this.result.put("code", "000002");
            this.result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\uff01");
            this.logger.error("\u5220\u9664\u5165\u5e93\u5355\u4fe1\u606f\u5f02\u5e38<delInboundOrderCon>:", (Throwable)e);
        }
        return this.result;
    }

    @RequestMapping(value={"/inbound/delInboundOrderDetail"})
    @ResponseBody
    public Map<String, Object> delInboundOrderDetailCon(String conditionStr) {
        this.result = new HashMap<String, Object>();
        Map<String, Object> paramMap = null;
        try {
            if (StringUtils.isNotEmpty(conditionStr)) {
                paramMap = JsonUtil.toMap(conditionStr);
                this.result = this.stockService.delInboundOrderDetailSer(paramMap);
            } else {
                this.result.put("code", "000001");
                this.result.put("msg", "\u53c2\u6570\u4e3a\u7a7a");
            }
        }
        catch (Exception e) {
            this.result.put("code", "000002");
            this.result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\uff01");
            this.logger.error("\u5220\u9664\u5165\u5e93\u5355\u660e\u7ec6\u4fe1\u606f\u5f02\u5e38<delInboundOrderDetailCon>:", (Throwable)e);
        }
        return this.result;
    }

    @RequestMapping(value={"/modular/queryStockMsg"})
    @ResponseBody
    public Page<Map<String, Object>> queryStockMsgCon(Page<Map<String, Object>> page, String conditionStr) {
        try {
            if (StringUtils.isNotEmpty(conditionStr) && page != null) {
                page.setConditons(JsonUtil.toMap(conditionStr));
            }
            page = this.stockService.queryStockMsgSer(page);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u5e93\u5b58\u4fe1\u606f\u5f02\u5e38<queryStockMsgCon>:", (Throwable)e);
        }
        return page;
    }

    @RequestMapping(value={"/modular/updateStockRemain"})
    @ResponseBody
    public Map<String, Object> updateStockRemainCon(HttpServletRequest request, String conditionStr) {
        this.result = new HashMap<String, Object>();
        Map<String, Object> paramMap = null;
        try {
            long userId = this.getUserId(request);
            if (StringUtils.isNotEmpty(conditionStr)) {
                paramMap = JsonUtil.toMap(conditionStr);
                this.result = this.stockService.updateStockRemainSer(paramMap, userId);
            } else {
                this.result.put("code", "000001");
                this.result.put("msg", "\u53c2\u6570\u4e3a\u7a7a");
            }
        }
        catch (Exception e) {
            this.result.put("code", "000002");
            this.result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\uff01");
            this.logger.error("\u4fee\u6539\u5e93\u5b58\u7559\u5b58\u6570\u91cf\u5f02\u5e38<updateStockRemainCon>:", (Throwable)e);
        }
        return this.result;
    }

    @RequestMapping(value={"/modular/updateNormalStockMsg"})
    @ResponseBody
    public Map<String, Object> updateNormalStockMsgCon(HttpServletRequest request, String conditionStr) {
        this.result = new HashMap<String, Object>();
        Map<String, Object> paramMap = null;
        try {
            long userId = this.getUserId(request);
            if (StringUtils.isNotEmpty(conditionStr)) {
                paramMap = JsonUtil.toMap(conditionStr);
                this.result = this.stockService.updateNormalStockMsgSer(paramMap, userId);
            } else {
                this.result.put("code", "000001");
                this.result.put("msg", "\u53c2\u6570\u4e3a\u7a7a");
            }
        }
        catch (Exception e) {
            this.result.put("code", "000002");
            this.result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\uff01");
            this.logger.error("\u66f4\u65b0\u5b58\u5728\u5f02\u5e38\u7684\u5e93\u5b58\u4fe1\u606f\u5f02\u5e38<updateNormalStockMsgCon>:", (Throwable)e);
        }
        return this.result;
    }

    @RequestMapping(value={"/outbound/queryOutboundOrderList"})
    @ResponseBody
    public Page<Map<String, Object>> queryOutboundOrderListCon(Page<Map<String, Object>> page, String conditionStr) {
        try {
            if (StringUtils.isNotEmpty(conditionStr) && page != null) {
                page.setConditons(JsonUtil.toMap(conditionStr));
            }
            page = this.stockService.queryOutboundOrderListSer(page);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u51fa\u5e93\u5355\u4fe1\u606f\u5f02\u5e38<queryOutboundOrderListCon>:", (Throwable)e);
        }
        return page;
    }

    @RequestMapping(value={"/outbound/queryOutboundOrderDetail"})
    @ResponseBody
    public Page<Map<String, Object>> queryOutboundOrderDetailCon(Page<Map<String, Object>> page, String conditionStr) {
        try {
            if (StringUtils.isNotEmpty(conditionStr) && page != null) {
                page.setConditons(JsonUtil.toMap(conditionStr));
            }
            page = this.stockService.queryOutboundOrderDetailSer(page);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u51fa\u5e93\u5355\u8be6\u7ec6\u4fe1\u606f\u5f02\u5e38<queryOutboundOrderDetailCon>:", (Throwable)e);
        }
        return page;
    }

    @RequestMapping(value={"/outbound/queryOutboundStockSkuMsg"})
    @ResponseBody
    public Page<Map<String, Object>> queryOutboundStockSkuMsgCon(Page<Map<String, Object>> page, String conditionStr) {
        try {
            if (StringUtils.isNotEmpty(conditionStr) && page != null) {
                page.setConditons(JsonUtil.toMap(conditionStr));
            }
            page = this.stockService.queryOutboundStockSkuMsgSer(page);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u65b0\u589e\u51fa\u5e93\u5355\u7684\u8d27\u54c1sku\u5217\u8868\u5f02\u5e38<queryOutboundStockSkuMsgCon>:", (Throwable)e);
        }
        return page;
    }

    @RequestMapping(value={"/outbound/saveOutboundMsg"})
    @ResponseBody
    public Map<String, Object> saveOutboundMsgCon(HttpServletRequest request, String conditionStr) {
        this.result = new HashMap<String, Object>();
        Map<String, Object> paramMap = null;
        try {
            long userId = this.getUserId(request);
            if (StringUtils.isNotEmpty(conditionStr)) {
                paramMap = JsonUtil.toMap(conditionStr);
                this.result = this.stockService.saveOutboundMsgSer(paramMap, userId);
            } else {
                this.result.put("code", "000001");
                this.result.put("msg", "\u53c2\u6570\u4e3a\u7a7a");
            }
        }
        catch (Exception e) {
            this.result.put("code", "000002");
            this.result.put("msg", "\u64cd\u4f5c\u5931\u8d25");
            this.logger.error("\u4fdd\u5b58\u51fa\u5e93\u5355\u4fe1\u606f\u5f02\u5e38<saveOutboundMsgCon>:", (Throwable)e);
        }
        return this.result;
    }

    @RequestMapping(value={"/outbound/delOutboundOrderDetail"})
    @ResponseBody
    public Map<String, Object> delOutboundOrderDetailCon(String conditionStr) {
        this.result = new HashMap<String, Object>();
        Map<String, Object> paramMap = null;
        try {
            if (StringUtils.isNotEmpty(conditionStr)) {
                paramMap = JsonUtil.toMap(conditionStr);
                this.result = this.stockService.delOutboundOrderDetailSer(paramMap);
            } else {
                this.result.put("code", "000001");
                this.result.put("msg", "\u53c2\u6570\u4e3a\u7a7a");
            }
        }
        catch (Exception e) {
            this.result.put("code", "000002");
            this.result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\uff01");
            this.logger.error("\u5220\u9664\u51fa\u5e93\u5355\u660e\u7ec6\u4fe1\u606f\u5f02\u5e38<delOutboundOrderDetailCon>:", (Throwable)e);
        }
        return this.result;
    }

    @RequestMapping(value={"/outbound/delOutboundOrder"})
    @ResponseBody
    public Map<String, Object> delOutboundOrderCon(String conditionStr) {
        this.result = new HashMap<String, Object>();
        Map<String, Object> paramMap = null;
        try {
            if (StringUtils.isNotEmpty(conditionStr)) {
                paramMap = JsonUtil.toMap(conditionStr);
                this.result = this.stockService.delOutboundOrderSer(paramMap);
            } else {
                this.result.put("code", "000001");
                this.result.put("msg", "\u53c2\u6570\u4e3a\u7a7a");
            }
        }
        catch (Exception e) {
            this.result.put("code", "000002");
            this.result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\uff01");
            this.logger.error("\u5220\u9664\u51fa\u5e93\u5355\u4fe1\u606f\u5f02\u5e38<delOutboundOrderCon>:", (Throwable)e);
        }
        return this.result;
    }

    @RequestMapping(value={"/outbound/updateOutboundStatus"})
    @ResponseBody
    public Map<String, Object> updateOutboundStatusCon(HttpServletRequest request, String conditionStr) {
        this.result = new HashMap<String, Object>();
        Map<String, Object> paramMap = null;
        try {
            long userId = this.getUserId(request);
            if (StringUtils.isNotEmpty(conditionStr)) {
                paramMap = JsonUtil.toMap(conditionStr);
                this.result = this.stockService.updateOutboundStatusSerHandler(paramMap, userId);
            } else {
                this.result.put("code", "000001");
                this.result.put("msg", "\u53c2\u6570\u4e3a\u7a7a");
            }
        }
        catch (Exception e) {
            this.result.put("code", "000002");
            this.result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\uff01");
            this.logger.error("\u4fee\u6539\u51fa\u5e93\u5355\u72b6\u6001\u5f02\u5e38<updateOutboundStatusCon>:", (Throwable)e);
        }
        return this.result;
    }

    @RequestMapping(value={"/tree/queryTreeMenu"})
    @ResponseBody
    public String queryTreeMenuCon() {
        String result = "";
        try {
            List<TreeListVo> list = this.stockService.queryTreeMenuSer();
            if (list != null && list.stream().count() > 0L) {
                result = JsonUtil.toJson(list);
            }
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6811\u5217\u8868\u5f02\u5e38<queryTreeMenuCon>:", (Throwable)e);
        }
        return result;
    }

    private long getUserId(HttpServletRequest request) {
        Map loginMap = (Map)request.getSession().getAttribute("staff");
        long userId = loginMap.get("staffId") != null ? Long.valueOf(loginMap.get("staffId").toString()) : 0L;
        return userId;
    }
}

