/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.stock.dao.repository;

import com.club.core.common.Page;
import com.club.framework.util.BeanUtils;
import com.club.web.stock.dao.base.po.CargoBrand;
import com.club.web.stock.dao.extend.CargoBrandExtendMapper;
import com.club.web.stock.domain.CargoBrand2Do;
import com.club.web.stock.domain.CargoBrandDo;
import com.club.web.stock.domain.repository.CargoBrandRepository;
import com.club.web.stock.vo.CargoBrandVo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class CargoBrandRepositoryImpl
implements CargoBrandRepository {
    @Autowired
    private CargoBrandExtendMapper brandDao;

    @Override
    public CargoBrandDo create(CargoBrandVo cargoBrandVo) {
        if (cargoBrandVo == null) {
            return null;
        }
        CargoBrand2Do cargoBrandDo = new CargoBrand2Do();
        BeanUtils.copyProperties(cargoBrandVo, cargoBrandDo);
        cargoBrandDo.setId(Long.parseLong(cargoBrandVo.getId()));
        return cargoBrandDo;
    }

    private CargoBrandDo getDomainByPo(CargoBrand cargoBrand) {
        if (cargoBrand == null) {
            return null;
        }
        CargoBrand2Do cargoBrandDo = new CargoBrand2Do();
        BeanUtils.copyProperties(cargoBrand, cargoBrandDo);
        return cargoBrandDo;
    }

    private CargoBrand getPoByDomain(CargoBrandDo cargoBrandDo) {
        if (cargoBrandDo == null) {
            return null;
        }
        CargoBrand cargoBrand = new CargoBrand();
        BeanUtils.copyProperties(cargoBrandDo, cargoBrand);
        return cargoBrand;
    }

    private CargoBrandVo getVoByPo(CargoBrand cargoBrand) {
        if (cargoBrand == null) {
            return null;
        }
        CargoBrandVo cargoBrandVo = new CargoBrandVo();
        BeanUtils.copyProperties(cargoBrand, cargoBrandVo);
        cargoBrandVo.setId(cargoBrand.getId() + "");
        return cargoBrandVo;
    }

    @Override
    public CargoBrandDo getCargoBrandDoById(Long id) {
        return this.getDomainByPo(this.brandDao.selectByPrimaryKey(id));
    }

    @Override
    public void insert(CargoBrandDo cargoBrandDo) {
        this.brandDao.insert(this.getPoByDomain(cargoBrandDo));
    }

    @Override
    public void update(CargoBrandDo cargoBrandDo) {
        this.brandDao.updateByPrimaryKey(this.getPoByDomain(cargoBrandDo));
    }

    @Override
    public Long queryCargoBrandCountPage(Page<Map<String, Object>> page) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (page.getConditons() != null) {
            map.put("conditions", page.getConditons().get("conditions").toString());
        }
        return this.brandDao.queryCargoBrandCountPage(map);
    }

    @Override
    public List<Map<String, Object>> queryCargoBrandPage(Page<Map<String, Object>> page) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (page.getConditons() != null) {
            map.put("conditions", page.getConditons().get("conditions").toString());
        }
        map.put("start", page.getStart());
        map.put("limit", page.getLimit());
        return this.brandDao.queryCargoBrandPage(map);
    }

    @Override
    public List<CargoBrandVo> findListAll() {
        return this.brandDao.findListAll();
    }

    @Override
    public List<CargoBrandVo> findListAllNotNull(Map<String, Object> param) {
        return this.brandDao.findListAllNotNull(param);
    }

    @Override
    public void deleteByPrimaryKey(long id) {
        this.brandDao.deleteByPrimaryKey(id);
    }

    @Override
    public List<CargoBrandVo> queryCargoBrandByName(String name) {
        return this.brandDao.queryCargoBrandByName(name);
    }

    @Override
    public CargoBrandVo getCargoBrandVoById(Long id) {
        return this.getVoByPo(this.brandDao.selectByPrimaryKey(id));
    }
}

