/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.stock.dao.repository;

import com.club.framework.util.ListUtils;
import com.club.web.stock.dao.base.po.CargoClassify;
import com.club.web.stock.dao.extend.CargoClassifyExtendMapper;
import com.club.web.stock.domain.CargoClassifyDo;
import com.club.web.stock.domain.repository.CargoClassifyRepository;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class CargoClassifyRepositoryImpl
implements CargoClassifyRepository {
    @Autowired
    private CargoClassifyExtendMapper cargoClassifyDoDao;

    @Override
    public List<CargoClassifyDo> findDoListByIds(String ids) {
        return this.getDomainListByPoList(this.cargoClassifyDoDao.findListByIds(ListUtils.strToLongList(ids)));
    }

    @Override
    public CargoClassifyDo findDoById(Long id) {
        return this.getDomainByPo(this.cargoClassifyDoDao.findByIdAndStatus(id, null));
    }

    @Override
    public List<Long> getAllIdsByIdAndStatus(Long id, Integer status) {
        CargoClassifyDo cargoClassifyDo = this.getDomainByPo(this.cargoClassifyDoDao.findByIdAndStatus(id, null));
        return cargoClassifyDo != null ? cargoClassifyDo.getAllIds(status) : null;
    }

    @Override
    public CargoClassifyDo findDoByIdAndStatus(Long id, Integer status) {
        return this.getDomainByPo(this.cargoClassifyDoDao.findByIdAndStatus(id, status));
    }

    @Override
    public List<CargoClassifyDo> findDoByParentId(Long parentId) {
        return this.getDomainListByPoList(this.cargoClassifyDoDao.findByParentIdAndStatus(parentId, null));
    }

    @Override
    public List<CargoClassifyDo> findDoByParentIdAndStatus(Long parentId, Integer status) {
        return this.getDomainListByPoList(this.cargoClassifyDoDao.findByParentIdAndStatus(parentId, status));
    }

    @Override
    public List<CargoClassify> findDoByParentIdAndStatusForWeb(Long parentId, Integer status) {
        return this.cargoClassifyDoDao.findByParentIdAndStatus(parentId, status);
    }

    @Override
    public int updateStatus(CargoClassifyDo cargoClassifyDo) {
        return this.cargoClassifyDoDao.updateByPrimaryKeySelective(this.getPoByDomain(cargoClassifyDo));
    }

    @Override
    public int delete(CargoClassifyDo cargoClassifyDo) {
        return this.cargoClassifyDoDao.deleteByPrimaryKey(cargoClassifyDo.getId());
    }

    @Override
    public int add(CargoClassifyDo cargoClassifyDo) {
        return this.cargoClassifyDoDao.insert(this.getPoByDomain(cargoClassifyDo));
    }

    @Override
    public int modify(CargoClassifyDo cargoClassifyDo) {
        return this.cargoClassifyDoDao.updateByPrimaryKeySelective(this.getPoByDomain(cargoClassifyDo));
    }

    @Override
    public List<CargoClassifyDo> findDoNoIds(List<Long> ids) {
        return this.getDomainListByPoList(this.cargoClassifyDoDao.findNoIds(ids));
    }

    @Override
    public List<CargoClassifyDo> findAllDoByStatus(Integer status) {
        return this.getDomainListByPoList(this.cargoClassifyDoDao.findAllPoByStatus(status));
    }

    private List<CargoClassify> getPoListByDomainList(List<CargoClassifyDo> srcs) {
        ArrayList<CargoClassify> targets = new ArrayList<CargoClassify>();
        if (srcs != null && srcs.size() != 0) {
            for (CargoClassifyDo src : srcs) {
                targets.add(this.getPoByDomain(src));
            }
        }
        return targets;
    }

    private List<CargoClassifyDo> getDomainListByPoList(List<CargoClassify> srcs) {
        ArrayList<CargoClassifyDo> targets = new ArrayList<CargoClassifyDo>();
        if (srcs != null && srcs.size() != 0) {
            for (CargoClassify src : srcs) {
                targets.add(this.getDomainByPo(src));
            }
        }
        return targets;
    }

    private CargoClassify getPoByDomain(CargoClassifyDo src) {
        CargoClassify target = null;
        if (src != null) {
            target = new CargoClassify();
            target.setId(src.getId());
            target.setName(src.getName());
            target.setParentId(src.getParentId());
            target.setStatus(src.getStatus());
            target.setOrderIndex(src.getOrderIndex());
            target.setCreateBy(src.getCreateBy());
            target.setCreateTime(src.getCreateTime());
            target.setUpdateBy(src.getUpdateBy());
            target.setUpdateTime(src.getUpdateTime());
            target.setImgUrl(src.getImgUrl());
        }
        return target;
    }

    private CargoClassifyDo getDomainByPo(CargoClassify src) {
        CargoClassifyDo target = null;
        if (src != null) {
            target = new CargoClassifyDo();
            target.setId(src.getId());
            target.setName(src.getName());
            target.setParentId(src.getParentId());
            target.setStatus(src.getStatus());
            target.setOrderIndex(src.getOrderIndex());
            target.setCreateBy(src.getCreateBy());
            target.setCreateTime(src.getCreateTime());
            target.setUpdateBy(src.getUpdateBy());
            target.setUpdateTime(src.getUpdateTime());
            target.setImgUrl(src.getImgUrl());
        }
        return target;
    }

    @Override
    public String queryNameById(long id) {
        String name = this.cargoClassifyDoDao.queryNameById(id);
        return name;
    }
}

