/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.stock.dao.repository;

import com.club.web.stock.dao.base.po.CargoSkuType;
import com.club.web.stock.dao.extend.CargoSkuTypeExtendMapper;
import com.club.web.stock.domain.CargoSkuType2Do;
import com.club.web.stock.domain.CargoSkuTypeDo;
import com.club.web.stock.domain.repository.CargoSkuTypeRepository;
import com.club.web.util.IdGenerator;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class CargoSkuTypeRepositoryImpl
implements CargoSkuTypeRepository {
    @Autowired
    CargoSkuTypeExtendMapper cargoSkuTypeDao;

    @Override
    public List<CargoSkuTypeDo> getListByCargoId(long cargoId) {
        return this.getDomainByPo(this.cargoSkuTypeDao.getListByCargoId(cargoId));
    }

    @Override
    public void delete(long cargoSkuTypeId) {
        this.cargoSkuTypeDao.deleteByPrimaryKey(cargoSkuTypeId);
    }

    @Override
    public void insert(CargoSkuTypeDo cargoSkuTypeDo) {
        this.cargoSkuTypeDao.insert(this.getPoByDomain(cargoSkuTypeDo));
    }

    @Override
    public void update(CargoSkuTypeDo cargoSkuTypeDo) {
        this.cargoSkuTypeDao.updateByPrimaryKeySelective(this.getPoByDomain(cargoSkuTypeDo));
    }

    @Override
    public CargoSkuTypeDo getById(long cargoSkuTypeId) {
        return this.getDomainByPo(this.cargoSkuTypeDao.selectByPrimaryKey(cargoSkuTypeId));
    }

    @Override
    public CargoSkuTypeDo create(long creatorId, long cargoBaseSkuTypeId, long cargoId, String name, int type) {
        CargoSkuType2Do c = new CargoSkuType2Do();
        c.setId(IdGenerator.getDefault().nextId());
        c.setCargoBaseSkuTypeId(cargoBaseSkuTypeId);
        c.setCargoId(cargoId);
        c.setName(name);
        c.setType(type);
        c.setCreateBy(creatorId);
        c.setUpdateBy(creatorId);
        return c;
    }

    private CargoSkuTypeDo getDomainByPo(CargoSkuType src) {
        if (src == null) {
            return null;
        }
        CargoSkuType2Do target = new CargoSkuType2Do();
        target.setId(src.getId());
        target.setCargoId(src.getCargoId());
        target.setCargoBaseSkuTypeId(src.getCargoBaseSkuTypeId());
        target.setName(src.getName());
        target.setType(src.getType());
        target.setCreateBy(src.getCreateBy());
        target.setCreateTime(src.getCreateTime());
        target.setUpdateBy(src.getUpdateBy());
        target.setUpdateTime(src.getUpdateTime());
        return target;
    }

    private CargoSkuType getPoByDomain(CargoSkuTypeDo src) {
        if (src == null) {
            return null;
        }
        CargoSkuType target = new CargoSkuType();
        target.setId(src.getId());
        target.setCargoId(src.getCargoId());
        target.setCargoBaseSkuTypeId(src.getCargoBaseSkuTypeId());
        target.setName(src.getName());
        target.setType(src.getType());
        target.setCreateBy(src.getCreateBy());
        target.setCreateTime(src.getCreateTime());
        target.setUpdateBy(src.getUpdateBy());
        target.setUpdateTime(src.getUpdateTime());
        return target;
    }

    private List<CargoSkuTypeDo> getDomainByPo(List<CargoSkuType> list) {
        ArrayList<CargoSkuTypeDo> result = new ArrayList<CargoSkuTypeDo>();
        if (list == null) {
            return result;
        }
        for (CargoSkuType src : list) {
            result.add(this.getDomainByPo(src));
        }
        return result;
    }
}

