/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.stock.dao.repository;

import com.club.web.stock.dao.base.CargoSkuStockLogMapper;
import com.club.web.stock.dao.base.po.CargoInboundDetail;
import com.club.web.stock.dao.base.po.CargoInboundOrder;
import com.club.web.stock.dao.base.po.CargoOutboundDetail;
import com.club.web.stock.dao.base.po.CargoOutboundOrder;
import com.club.web.stock.dao.base.po.CargoSkuStock;
import com.club.web.stock.dao.base.po.CargoSkuStockLog;
import com.club.web.stock.dao.extend.CargoInboundDetailExtendMapper;
import com.club.web.stock.dao.extend.CargoInboundOrderExtendMapper;
import com.club.web.stock.dao.extend.CargoOutboundDetailExtendMapper;
import com.club.web.stock.dao.extend.CargoOutboundOrderExtendMapper;
import com.club.web.stock.dao.extend.CargoSkuStockExtendMapper;
import com.club.web.stock.domain.CargoInboundDetailDo;
import com.club.web.stock.domain.CargoInboundExtendDetailDo;
import com.club.web.stock.domain.CargoInboundOrderDo;
import com.club.web.stock.domain.CargoOutboundDetailDo;
import com.club.web.stock.domain.CargoOutboundOrderDo;
import com.club.web.stock.domain.CargoSkuStockDo;
import com.club.web.stock.domain.CargoSkuStockLogDo;
import com.club.web.stock.domain.CargoSkuStockLogExtendDo;
import com.club.web.stock.domain.repository.StockManagerRepository;
import com.club.web.stock.vo.CargoInboundDetailVo;
import com.club.web.stock.vo.CargoInboundOrderVo;
import com.club.web.stock.vo.CargoOutboundOrderVo;
import com.club.web.stock.vo.CargoSkuItemVo;
import com.club.web.stock.vo.CargoSkuStockVo;
import com.club.web.stock.vo.SkuGoodsParam;
import com.club.web.stock.vo.StockGoodsInboundMsgVo;
import com.club.web.stock.vo.StockGoodsOutboundMsgVo;
import com.club.web.stock.vo.U8Stock;
import com.club.web.util.IdGenerator;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class StockRepositoryImpl
implements StockManagerRepository {
    private Logger logger = LoggerFactory.getLogger(StockRepositoryImpl.class);
    @Autowired
    CargoInboundOrderExtendMapper inboundDao;
    @Autowired
    CargoInboundDetailExtendMapper inboundDetailDao;
    @Autowired
    CargoSkuStockExtendMapper stockDao;
    @Autowired
    CargoOutboundOrderExtendMapper outboundDao;
    @Autowired
    CargoOutboundDetailExtendMapper outboundDetailDao;
    @Autowired
    CargoSkuStockLogMapper stockLogDao;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <T> void save(T t) throws Exception {
        if (t == null) throw new NullPointerException("\u64cd\u4f5c\u5bf9\u8c61\u4e3a\u7a7a");
        if (t instanceof CargoOutboundOrderDo) {
            CargoOutboundOrderDo out = (CargoOutboundOrderDo)t;
            CargoOutboundOrder po = new CargoOutboundOrder();
            BeanUtils.copyProperties((Object)po, (Object)out);
            po.setOutboundTime(null);
            this.outboundDao.insert(po);
            return;
        } else if (t instanceof CargoSkuStockDo) {
            CargoSkuStockDo stockDo = (CargoSkuStockDo)t;
            CargoSkuStock stockPo = new CargoSkuStock();
            BeanUtils.copyProperties((Object)stockPo, (Object)stockDo);
            this.stockDao.insert(stockPo);
            return;
        } else if (t instanceof CargoInboundOrderDo) {
            CargoInboundOrderDo inboundObj = (CargoInboundOrderDo)t;
            CargoInboundOrder inboundPo = new CargoInboundOrder();
            BeanUtils.copyProperties((Object)inboundPo, (Object)inboundObj);
            inboundPo.setInboundTime(null);
            this.inboundDao.insert(inboundPo);
            return;
        } else if (t instanceof CargoInboundDetailDo) {
            CargoInboundDetailDo detailObj = (CargoInboundDetailDo)t;
            CargoInboundDetail detailPo = new CargoInboundDetail();
            BeanUtils.copyProperties((Object)detailPo, (Object)detailObj);
            this.inboundDetailDao.insert(detailPo);
            return;
        } else if (t instanceof CargoOutboundDetailDo) {
            CargoOutboundDetailDo detailOut = (CargoOutboundDetailDo)t;
            CargoOutboundDetail po = new CargoOutboundDetail();
            BeanUtils.copyProperties((Object)po, (Object)detailOut);
            this.outboundDetailDao.insert(po);
            return;
        } else {
            if (!(t instanceof CargoSkuStockLogDo)) throw new Exception("\u4e0d\u5b58\u5728\u64cd\u4f5c\u7684\u5bf9\u8c61\u5b9e\u4f8b");
            CargoSkuStockLogDo stockLog = (CargoSkuStockLogDo)t;
            CargoSkuStockLog stockPo = new CargoSkuStockLog();
            BeanUtils.copyProperties((Object)stockPo, (Object)stockLog);
            this.stockLogDao.insert(stockPo);
        }
    }

    @Override
    public CargoSkuStockDo queryStockById(long id) throws Exception {
        CargoSkuStockDo stockDo = null;
        CargoSkuStock stock = this.stockDao.selectByPrimaryKey(id);
        if (stock != null) {
            stock.setUpdateTime(stock.getCreateTime());
            stockDo = new CargoSkuStockDo();
            BeanUtils.copyProperties((Object)stockDo, (Object)stock);
        }
        return stockDo;
    }

    @Override
    public List<CargoSkuStockVo> queryStockMsg(List<Long> nodeList, long brand, String matchParam, String type, int startIndex, int pageSize) {
        List<CargoSkuStockVo> list = this.stockDao.queryStockMsg(nodeList, brand, matchParam, type, startIndex, pageSize);
        return list;
    }

    @Override
    public List<CargoSkuStockVo> queryNormalStockMsgByIds(List<Long> ids) {
        List<CargoSkuStockVo> list = this.stockDao.queryNormalStockMsgByIds(ids);
        return list;
    }

    @Override
    public int queryStockMsgTotal(List<Long> nodeList, long brand, String matchParam, String type) {
        int total = this.stockDao.queryStockMsgTotal(nodeList, brand, matchParam, type);
        return total;
    }

    @Override
    public CargoSkuStockDo createStockObj(long skuId, int count, long userId) {
        CargoSkuStockDo stock = new CargoSkuStockDo();
        CargoSkuStock stockPo = this.stockDao.queryBySkuId(skuId);
        if (stockPo == null) {
            stock.setId(IdGenerator.getDefault().nextId());
            stock.setCargoSkuId(skuId);
            stock.setCreateBy(userId);
            stock.setCreateTime(new Date());
            stock.setUpdateTime(new Date());
            stock.setOutShelvesNo(count);
            stock.setOnPayNo(0);
            stock.setOnSalesNo(0);
            stock.setOnSendNo(0);
            stock.setRemainCount(0);
            stock.setFlag(0);
        } else {
            stock.setFlag(1);
            stock.setId(stockPo.getId());
            stock.setCargoSkuId(stockPo.getCargoSkuId());
            stock.setCreateBy(stockPo.getCreateBy());
            stock.setCreateTime(stockPo.getCreateTime());
            stock.setOnPayNo(stockPo.getOnPayNo());
            stock.setOnSalesNo(stockPo.getOnSalesNo());
            stock.setOnSendNo(stockPo.getOnSendNo());
            stock.setRemainCount(stockPo.getRemainCount());
            stock.setUpdateBy(userId);
            stock.setUpdateTime(new Date());
            stock.setOutShelvesNo(stockPo.getOutShelvesNo() + count);
        }
        return stock;
    }

    @Override
    public CargoSkuStockLogDo createStockLogObj(CargoSkuStockDo stock, int status, long inboundId, int count) {
        CargoSkuStockLogExtendDo stockLog = null;
        if (stock != null) {
            stockLog = new CargoSkuStockLogExtendDo();
            stockLog.setId(IdGenerator.getDefault().nextId());
            stockLog.setCargoSkuId(stock.getCargoSkuId());
            stockLog.setOutShelvesNo(stock.getOutShelvesNo());
            stockLog.setOnSalesNo(stock.getOnSalesNo());
            stockLog.setOnPayNo(stock.getOnPayNo());
            stockLog.setOnSendNo(stock.getOnSendNo());
            stockLog.setInboundId(inboundId);
            stockLog.setCreateTime(new Date());
            stockLog.setCreateBy(stock.getCreateBy());
            stockLog.setUpdateCount(count);
            stockLog.setUpdateStatus(status);
        }
        return stockLog;
    }

    @Override
    public synchronized void updateStock(CargoSkuStockDo obj) throws IllegalAccessException, InvocationTargetException {
        CargoSkuStock stockPo = new CargoSkuStock();
        BeanUtils.copyProperties((Object)stockPo, (Object)obj);
        this.stockDao.updateByPrimaryKey(stockPo);
    }

    @Override
    public void updateOutbound(CargoOutboundDetailDo obj) throws Exception {
        CargoOutboundDetail po = new CargoOutboundDetail();
        BeanUtils.copyProperties((Object)po, (Object)obj);
        this.outboundDetailDao.updateByPrimaryKey(po);
    }

    @Override
    public void updateInboundOrderStatus(CargoInboundOrderDo inboundObj) throws IllegalAccessException, InvocationTargetException {
        CargoInboundOrder inboundPo = new CargoInboundOrder();
        BeanUtils.copyProperties((Object)inboundPo, (Object)inboundObj);
        if (inboundPo.getStatus() != 3) {
            inboundPo.setInboundTime(null);
        }
        this.inboundDao.updateByPrimaryKey(inboundPo);
    }

    @Override
    public void updateOutbound(CargoOutboundOrderDo outbound) throws Exception {
        CargoOutboundOrder po = new CargoOutboundOrder();
        BeanUtils.copyProperties((Object)po, (Object)outbound);
        if (outbound.getStatus() != 3) {
            po.setOutboundTime(null);
        }
        this.outboundDao.updateByPrimaryKey(po);
    }

    @Override
    public List<CargoInboundOrderDo> getInboundObjByIds(List<Long> ids) {
        List<CargoInboundOrderDo> list = this.inboundDao.getInboundObjByIds(ids);
        return list;
    }

    @Override
    public void updateInboundDetail(CargoInboundDetailDo detailObj) throws IllegalAccessException, InvocationTargetException {
        CargoInboundDetail detailPo = new CargoInboundDetail();
        BeanUtils.copyProperties((Object)detailPo, (Object)detailObj);
        this.inboundDetailDao.updateByPrimaryKey(detailPo);
    }

    @Override
    public CargoInboundOrderDo createInboundObj(long[] skuIdList, int[] skuCountList, long userId, String sourceCode, String remk, String type) {
        CargoInboundOrderDo inboundObj = null;
        ArrayList<CargoInboundDetailDo> detailList = null;
        if (skuIdList != null && skuCountList != null && skuCountList.length > 0 && skuIdList.length > 0) {
            inboundObj = new CargoInboundOrderDo();
            inboundObj.setId(IdGenerator.getDefault().nextId());
            inboundObj.setCreateTime(new Date());
            inboundObj.setSubTime(new Date());
            inboundObj.setInboundTime(new Date());
            inboundObj.setCreateBy(userId);
            inboundObj.setRemarks(remk);
            inboundObj.setSourceNo(sourceCode);
            inboundObj.setStatus(1);
            inboundObj.setType(type);
            detailList = new ArrayList<CargoInboundDetailDo>();
            CargoInboundExtendDetailDo detailObj = null;
            for (int i = 0; i < skuIdList.length; ++i) {
                detailObj = new CargoInboundExtendDetailDo();
                detailObj.setId(IdGenerator.getDefault().nextId());
                detailObj.setInboundId(inboundObj.getId());
                detailObj.setSkuId(skuIdList[i]);
                detailObj.setCount(skuCountList[i]);
                detailList.add(detailObj);
            }
            inboundObj.setDetail(detailList);
        }
        return inboundObj;
    }

    @Override
    public CargoOutboundOrderDo createOutboundObj(long[] skuIdList, int[] skuCountList, long userId, String sourceCode, String remk, String type) {
        CargoOutboundOrderDo outbound = null;
        ArrayList<CargoOutboundDetailDo> list = null;
        if (skuIdList != null && skuCountList != null && skuCountList.length > 0 && skuIdList.length > 0) {
            outbound = new CargoOutboundOrderDo();
            outbound.setId(IdGenerator.getDefault().nextId());
            outbound.setCreateTime(new Date());
            outbound.setSubTime(new Date());
            outbound.setOutboundTime(new Date());
            outbound.setStatus(1);
            if (type.equals("1")) {
                outbound.setRemarks("\u8fdb\u8d27\u51fa\u5e93");
            } else {
                outbound.setRemarks("\u9500\u552e\u51fa\u5e93");
            }
            outbound.setSourceNo(sourceCode);
            outbound.setOutboundType(1);
            outbound.setCreateBy(userId);
            outbound.setType(type);
            list = new ArrayList<CargoOutboundDetailDo>();
            CargoOutboundDetailDo detail = null;
            for (int i = 0; i < skuIdList.length; ++i) {
                detail = new CargoOutboundDetailDo();
                detail.setId(IdGenerator.getDefault().nextId());
                detail.setOutboundId(outbound.getId());
                detail.setSkuId(skuIdList[i]);
                detail.setCount(skuCountList[i]);
                list.add(detail);
            }
            outbound.setDetail(list);
        }
        return outbound;
    }

    @Override
    public CargoOutboundOrderDo createOutboundObj(List<SkuGoodsParam> list, long userId, String orderId, String remk) {
        CargoOutboundOrderDo outbound = null;
        ArrayList<CargoOutboundDetailDo> listDetail = null;
        if (list != null && list.stream().count() > 0L) {
            outbound = new CargoOutboundOrderDo();
            outbound.setId(IdGenerator.getDefault().nextId());
            outbound.setCreateTime(new Date());
            outbound.setSubTime(new Date());
            outbound.setOutboundTime(new Date());
            outbound.setStatus(2);
            outbound.setRemarks(remk);
            outbound.setSourceNo(orderId);
            outbound.setOutboundType(0);
            outbound.setCreateBy(userId);
            listDetail = new ArrayList<CargoOutboundDetailDo>();
            CargoOutboundDetailDo detail = null;
            for (SkuGoodsParam sk : list) {
                detail = new CargoOutboundDetailDo();
                detail.setId(IdGenerator.getDefault().nextId());
                detail.setOutboundId(outbound.getId());
                detail.setSkuId(Long.valueOf(sk.getCargoSkuId()));
                detail.setCount(Integer.valueOf(sk.getNum()));
                listDetail.add(detail);
            }
            outbound.setDetail(listDetail);
        }
        return outbound;
    }

    @Override
    public List<CargoInboundDetailDo> createInboundDetailObj(long[] skuIdList, int[] skuCountList, long inboundId) {
        ArrayList<CargoInboundDetailDo> list = new ArrayList<CargoInboundDetailDo>();
        CargoInboundExtendDetailDo detailObj = null;
        CargoInboundDetail detailPo = null;
        for (int i = 0; i < skuIdList.length; ++i) {
            detailPo = this.inboundDetailDao.selectBySkuId(skuIdList[i], inboundId);
            detailObj = new CargoInboundExtendDetailDo();
            if (detailPo != null) {
                detailObj.setId(detailPo.getId());
                detailObj.setCount(detailPo.getCount() + skuCountList[i]);
                detailObj.setInboundId(detailPo.getInboundId());
                detailObj.setSkuId(detailPo.getSkuId());
                detailObj.setFlag(1);
            } else {
                detailObj.setId(IdGenerator.getDefault().nextId());
                detailObj.setInboundId(inboundId);
                detailObj.setSkuId(skuIdList[i]);
                detailObj.setCount(skuCountList[i]);
                detailObj.setFlag(0);
            }
            list.add(detailObj);
        }
        return list;
    }

    @Override
    public List<CargoOutboundDetailDo> createOutboundDetailObj(long[] skuIdList, int[] skuCountList, long outboundId) {
        ArrayList<CargoOutboundDetailDo> list = new ArrayList<CargoOutboundDetailDo>();
        CargoOutboundDetail po = null;
        CargoOutboundDetailDo obj = null;
        for (int i = 0; i < skuIdList.length; ++i) {
            po = this.outboundDetailDao.selectBySkuAndOutId(skuIdList[i], outboundId);
            obj = new CargoOutboundDetailDo();
            if (po != null) {
                obj.setId(po.getId());
                obj.setCount(po.getCount() + skuCountList[i]);
                obj.setOutboundId(po.getOutboundId());
                obj.setSkuId(po.getSkuId());
                obj.setFlag(1);
            } else {
                obj.setId(IdGenerator.getDefault().nextId());
                obj.setOutboundId(outboundId);
                obj.setSkuId(skuIdList[i]);
                obj.setCount(skuCountList[i]);
                obj.setFlag(0);
            }
            list.add(obj);
        }
        return list;
    }

    @Override
    public List<CargoInboundOrderVo> queryInboundOrderList(int status, String matchParam, String type, int startIndex, int pageSize) {
        List<CargoInboundOrderVo> record = this.inboundDao.queryInboundOrderList(status, matchParam, type, startIndex, pageSize);
        return record;
    }

    @Override
    public int queryInboundOrderTotal(int status, String matchParam, String type) {
        int total = this.inboundDao.queryInboundOrderTotal(status, matchParam, type);
        return total;
    }

    @Override
    public int queryInboundDetailTotal(List<Long> nodeList, long brand, long inboundId, String matchParam) {
        int total = this.inboundDao.queryInboundOrderDetailTotal(nodeList, brand, inboundId, matchParam);
        return total;
    }

    @Override
    public int queryOutboundDetailTotal(List<Long> nodeList, long brand, long outboundId, String matchParam) {
        int total = this.outboundDetailDao.queryOutboundDetailTotal(nodeList, brand, outboundId, matchParam);
        return total;
    }

    @Override
    public List<StockGoodsOutboundMsgVo> queryOutboundDetail(List<Long> nodeList, long brand, long outboundId, String matchParam, int startIndex, int pageSize) {
        List<StockGoodsOutboundMsgVo> list = this.outboundDetailDao.queryOutboundDetail(nodeList, brand, outboundId, matchParam, startIndex, pageSize);
        return list;
    }

    @Override
    public int queryGoodsMsgTotal(List<Long> nodeList, String matchParam, String type) {
        int total = 0;
        try {
            total = this.inboundDao.queryGoodsMsgTotal(nodeList, matchParam, type);
        }
        catch (Exception e) {
            this.logger.error("\u6dfb\u52a0\u5165\u5e93-\u67e5\u8be2\u8d27\u54c1\u4fe1\u606f\u603b\u6570-\u6839\u636e\u67e5\u8be2\u6761\u4ef6\u5f02\u5e38<queryGoodsMsgTotal>:", (Throwable)e);
        }
        return total;
    }

    @Override
    public int queryGoodsSkuMsgTotal(List<Long> goodsIdList) {
        int total = 0;
        try {
            total = this.inboundDao.queryGoodsSkuMsgTotal(goodsIdList);
        }
        catch (Exception e) {
            this.logger.error("\u6dfb\u52a0\u5165\u5e93-\u67e5\u8be2\u8d27\u54c1Sku\u4fe1\u606f\u603b\u6570\u5f02\u5e38<queryGoodsSkuMsgTotal>:", (Throwable)e);
        }
        return total;
    }

    @Override
    public List<CargoSkuItemVo> queryGoodsSpecList(long skuId) {
        List<CargoSkuItemVo> list = null;
        try {
            list = this.inboundDao.queryGoodsSpecList(skuId);
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636esku\u67e5\u8be2\u89c4\u683c\u5f02\u5e38<queryGoodsSpecList>:", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<StockGoodsInboundMsgVo> queryInboundorderDetailList(List<Long> nodeList, long brand, long inboundId, String matchParam, int startIndex, int pageSize) {
        List<StockGoodsInboundMsgVo> list = this.inboundDao.queryInboundorderDetailList(nodeList, brand, inboundId, matchParam, startIndex, pageSize);
        return list;
    }

    @Override
    public List<StockGoodsInboundMsgVo> queryGoodsMsg(List<Long> nodeList, String matchParam, String type, int startIndex, int pageSize) {
        List<StockGoodsInboundMsgVo> list = this.inboundDao.queryGoodsMsg(nodeList, matchParam, type, startIndex, pageSize);
        return list;
    }

    @Override
    public List<StockGoodsInboundMsgVo> queryGoodsSkuMsg(List<Long> goodsIdList, int startIndex, int pageSize) {
        List<StockGoodsInboundMsgVo> list = this.inboundDao.queryGoodsSkuMsg(goodsIdList, startIndex, pageSize);
        return list;
    }

    @Override
    public boolean deleteInboundOrder(List<Long> ids) {
        this.inboundDao.deleteInboundStock(ids);
        return true;
    }

    @Override
    public boolean deleteInboundOrderDetail(List<Long> inboundIds) {
        this.inboundDetailDao.deleteInboundDetail(inboundIds);
        return true;
    }

    @Override
    public boolean deleteInboundOrderDetailByIds(List<Long> ids) {
        this.inboundDetailDao.deleteInboundDetailByIds(ids);
        return true;
    }

    @Override
    public List<CargoInboundDetailVo> queryByInboundId(long inboundId) {
        List<CargoInboundDetailVo> list = this.inboundDetailDao.querySkuIdsByInboundId(inboundId);
        return list;
    }

    @Override
    public int queryOutboundOrderListTotal(int status, String matchParam, String type) {
        int total = this.outboundDao.queryOutboundOrderListTotal(status, matchParam, type);
        return total;
    }

    @Override
    public List<CargoOutboundOrderVo> queryOutboundOrderList(int status, String matchParam, String type, int startIndex, int pageSize) {
        List<CargoOutboundOrderVo> list = this.outboundDao.queryOutboundOrderList(status, matchParam, type, startIndex, pageSize);
        return list;
    }

    @Override
    public int queryOutboundSkuMsgTotal(List<Long> goodsIdList) {
        int total = 0;
        try {
            total = this.outboundDetailDao.queryOutboundSkuMsgTotal(goodsIdList);
        }
        catch (Exception e) {
            this.logger.error("\u6dfb\u52a0\u51fa\u5e93-\u67e5\u8be2\u8d27\u54c1Sku\u4fe1\u606f\u603b\u6570\u5f02\u5e38<queryOutboundSkuMsgTotal>:", (Throwable)e);
        }
        return total;
    }

    @Override
    public List<StockGoodsOutboundMsgVo> queryOutboundSkuMsg(List<Long> goodsIdList, int startIndex, int pageSize) {
        List<StockGoodsOutboundMsgVo> list = this.outboundDetailDao.queryOutboundSkuMsg(goodsIdList, startIndex, pageSize);
        return list;
    }

    @Override
    public boolean deleteOutboundDetailByIds(List<Long> ids) {
        this.outboundDetailDao.deleteOutboundDetailByIds(ids);
        return true;
    }

    @Override
    public boolean delOutboundDetailByOutIds(List<Long> outboundIds) {
        this.outboundDetailDao.delOutboundDetailByOutIds(outboundIds);
        return true;
    }

    @Override
    public boolean deleteOutboundOrder(List<Long> ids) {
        this.outboundDao.deleteOutboundOrder(ids);
        return true;
    }

    @Override
    public List<CargoOutboundOrderDo> getOutboundObjByIds(List<Long> ids) {
        List<CargoOutboundOrderDo> list = this.outboundDao.getOutboundObjByIds(ids);
        return list;
    }

    @Override
    public CargoOutboundOrderDo queryOutboundBySourceNo(String sourceNo) {
        CargoOutboundOrderDo outbound = this.outboundDao.queryOutboundBySourceNo(sourceNo);
        return outbound;
    }

    @Override
    public int queryStockCountBySkuId(long skuId) {
        int count = this.stockDao.queryStockCountBySkuId(skuId);
        return count;
    }

    @Override
    public int queryStockTotalBySkuId(long skuId) {
        int count = this.stockDao.queryStockTotalBySkuId(skuId);
        return count;
    }

    @Override
    public int queryStockTotalByCargoId(long cargoId) {
        int count = this.stockDao.queryStockTotalByCargoId(cargoId);
        return count;
    }

    @Override
    public List<U8Stock> queryCargoSkuStockList() {
        return this.stockDao.queryCargoSkuStockList();
    }

    @Override
    public void updateLocalStock(U8Stock lo) {
        this.stockDao.updateLocalStock(lo);
    }

    @Override
    public CargoSkuStockDo queryPackageStockByBomId(long skuId) throws Exception {
        CargoSkuStockDo stockPo = this.stockDao.queryPackageStockByBomId(skuId);
        return stockPo;
    }

    @Override
    public void updatePackageStock(CargoSkuStockDo cargoSkuStockDo) {
        this.stockDao.updatePackageStock(cargoSkuStockDo);
    }

    @Override
    public void deleteStockBySkuId(long skuId) {
        this.stockDao.deleteStockBySkuId(skuId);
    }

    @Override
    public void deleteStockByCargoId(long cargoId) {
        this.stockDao.deleteStockByCargoId(cargoId);
    }

    @Override
    public int queryOutCountBySkuId(long skuId, long outboundId) {
        int count = 0;
        CargoOutboundDetail detail = this.outboundDetailDao.selectBySkuAndOutId(skuId, outboundId);
        if (detail != null) {
            count = detail.getCount();
        }
        return count;
    }

    @Override
    public List<StockGoodsOutboundMsgVo> getStockCountByOutIds(List<Long> outboundIds) {
        List<StockGoodsOutboundMsgVo> list = this.outboundDetailDao.getStockCountByOutIds(outboundIds);
        return list;
    }

    @Override
    public CargoSkuStockDo queryBySkuId(long skuId) throws Exception {
        CargoSkuStockDo stock = null;
        CargoSkuStock stockPo = this.stockDao.queryBySkuId(skuId);
        if (stockPo != null) {
            stockPo.setUpdateTime(stockPo.getCreateTime());
            stock = new CargoSkuStockDo();
            BeanUtils.copyProperties((Object)stock, (Object)stockPo);
        }
        return stock;
    }

    @Override
    public List<CargoOutboundDetailDo> queryOutDetailByOutboundId(long outboundId) {
        List<CargoOutboundDetailDo> list = this.outboundDetailDao.queryOutDetailByOutboundId(outboundId);
        return list;
    }
}

