/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.stock.domain;

import com.club.web.stock.domain.repository.CargoClassifyRepository;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;

@Configurable
public class CargoClassifyDo {
    private Long id;
    private String name;
    private Date createTime;
    private Long createBy;
    private Date updateTime;
    private Long updateBy;
    private Long parentId;
    private Integer status;
    private Integer orderIndex;
    private String imgUrl;
    private Integer sort;
    @Autowired
    private CargoClassifyRepository repository;

    public CargoClassifyDo getParent() {
        return this.parentId != null ? this.repository.findDoById(this.parentId) : null;
    }

    public List<CargoClassifyDo> getChildrens() {
        return this.id != null ? this.repository.findDoByParentId(this.id) : Collections.EMPTY_LIST;
    }

    public Integer getSort() {
        return this.sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public List<Long> getAllIds(Integer status) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (status == null || status.equals(this.getStatus())) {
            List<CargoClassifyDo> childrens;
            if (1L != this.getId()) {
                ids.add(this.getId());
            }
            if ((childrens = this.getChildrens()) != null && childrens.size() != 0) {
                for (CargoClassifyDo cargoClassifyDo : childrens) {
                    ids.addAll(cargoClassifyDo.getAllIds(status));
                }
            }
        }
        return ids;
    }

    public void save() {
        this.repository.add(this);
    }

    public void update() {
        this.repository.modify(this);
    }

    public void updateStop(Date updateTime, long userId, int status) {
        for (CargoClassifyDo children : this.getChildrens()) {
            children.updateStop(updateTime, userId, status);
        }
        this.setStatus(status);
        this.setUpdateBy(userId);
        this.setUpdateTime(updateTime);
        this.repository.updateStatus(this);
    }

    public void updateStart(Date updateTime, long userId, int status) {
        CargoClassifyDo parent = this.getParent();
        if (parent != null) {
            parent.updateStart(updateTime, userId, status);
        }
        this.setStatus(status);
        this.setUpdateBy(userId);
        this.setUpdateTime(updateTime);
        this.repository.updateStatus(this);
    }

    public int delete() {
        int i = 1;
        if (this.id != null) {
            for (CargoClassifyDo childrenDo : this.getChildrens()) {
                childrenDo.delete();
            }
            i = this.repository.delete(this);
        }
        return i;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getOrderIndex() {
        return this.orderIndex;
    }

    public void setOrderIndex(Integer orderIndex) {
        this.orderIndex = orderIndex;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Long getCreateBy() {
        return this.createBy;
    }

    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Long getUpdateBy() {
        return this.updateBy;
    }

    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public String getImgUrl() {
        return this.imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }
}

