/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.stock.domain;

import com.club.web.stock.domain.BaseDo;
import com.club.web.stock.domain.CargoBaseSkuTypeDo;
import com.club.web.stock.domain.CargoBrandDo;
import com.club.web.stock.domain.CargoClassifyDo;
import com.club.web.stock.domain.CargoSkuDo;
import com.club.web.stock.domain.CargoSkuItemDo;
import com.club.web.stock.domain.CargoSkuTypeDo;
import com.club.web.stock.domain.CargoSupplierDo;
import com.club.web.stock.domain.repository.CargoBaseSkuTypeRepository;
import com.club.web.stock.domain.repository.CargoBrandRepository;
import com.club.web.stock.domain.repository.CargoClassifyRepository;
import com.club.web.stock.domain.repository.CargoRepository;
import com.club.web.stock.domain.repository.CargoSkuItemRepository;
import com.club.web.stock.domain.repository.CargoSkuRepository;
import com.club.web.stock.domain.repository.CargoSkuTypeRepository;
import com.club.web.stock.domain.repository.CargoSupplierRepository;
import com.club.web.stock.domain.repository.StockManagerRepository;
import com.club.web.stock.listener.CargoListenerManager;
import java.math.BigDecimal;
import java.sql.BatchUpdateException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.util.Assert;

@Configurable
public class CargoDo
extends BaseDo {
    private long id;
    private long supplierId;
    private long brandId;
    private long classifyId;
    private String name;
    private String cargoNo;
    private String description;
    private long smallImageId;
    private long showImageGroupId;
    private long detailImageGroupId;
    private List<CargoSkuTypeDo> skuTypeList;
    @Autowired
    private CargoRepository cargoRepository;
    @Autowired
    private CargoSkuRepository cargoSkuRepository;
    @Autowired
    private CargoSkuTypeRepository cargoSkuTypeRepository;
    @Autowired
    private CargoClassifyRepository cargoClassifyRepository;
    @Autowired
    private CargoSupplierRepository cargoSupplierRepository;
    @Autowired
    private CargoBrandRepository cargoBrandRepository;
    @Autowired
    private CargoListenerManager goodsListener;
    @Autowired
    private StockManagerRepository stockManagerRepository;
    @Autowired
    private CargoBaseSkuTypeRepository cargoBaseSkuTypeRepository;
    @Autowired
    private CargoSkuItemRepository cargoSkuItemRepository;

    public CargoSkuDo getSku(long skuId) {
        CargoSkuDo csDo = this.cargoSkuRepository.getById(skuId);
        if (csDo != null && csDo.getCargoId() == this.id) {
            return csDo;
        }
        return null;
    }

    public int getTotalCount() {
        return this.stockManagerRepository.queryStockTotalByCargoId(this.id);
    }

    public List<CargoSkuDo> getSkuList() {
        return this.cargoSkuRepository.getListByCargoId(this.id);
    }

    public List<CargoSkuTypeDo> getSkuTypeList() {
        if (this.skuTypeList == null) {
            this.skuTypeList = this.cargoSkuTypeRepository.getListByCargoId(this.id);
        }
        return this.skuTypeList;
    }

    public List<CargoSkuTypeDo> getSkuTypeList(long resourceId) {
        if (this.skuTypeList == null) {
            this.skuTypeList = this.cargoSkuTypeRepository.getListByCargoId(resourceId);
        }
        return this.skuTypeList;
    }

    public CargoSkuItemDo getSkuItem(long itemId) {
        List<CargoSkuTypeDo> skuTypeList = this.getSkuTypeList();
        for (CargoSkuTypeDo cstDo : skuTypeList) {
            for (CargoSkuItemDo csiDo : cstDo.getSkuItemList()) {
                if (csiDo.getCargoBaseSkuItemId() != itemId) continue;
                return csiDo;
            }
        }
        return null;
    }

    public CargoSkuItemDo getSkuItem(long itemId, long resourceId) {
        List<CargoSkuTypeDo> skuTypeList = this.getSkuTypeList(resourceId);
        for (CargoSkuTypeDo cstDo : skuTypeList) {
            for (CargoSkuItemDo csiDo : cstDo.getSkuItemList()) {
                if (csiDo.getCargoBaseSkuItemId() != itemId) continue;
                return csiDo;
            }
        }
        return null;
    }

    public boolean deleteAllSku() {
        boolean flag = true;
        for (CargoSkuDo csDo : this.getSkuList()) {
            Assert.state((csDo.getTotalCout() == 0 ? 1 : 0) != 0, (String)("SKU[" + csDo.getCode() + "]\u5c1a\u6709" + csDo.getTotalCout() + "\u4ef6\u672a\u5904\u7406"));
            if (!this.goodsListener.deleteCargoSku(csDo.getId())) {
                flag = false;
                continue;
            }
            csDo.delete();
        }
        return flag;
    }

    public void deleteSku(long ... skuIds) {
        if (skuIds != null) {
            for (long skuId : skuIds) {
                for (CargoSkuDo csDo : this.getSkuList()) {
                    if (csDo.getId() != skuId) continue;
                    Assert.state((csDo.getTotalCout() == 0 ? 1 : 0) != 0, (String)("SKU[" + csDo.getCode() + "]\u5c1a\u6709" + csDo.getTotalCout() + "\u4ef6\u672a\u5904\u7406"));
                    if (!this.goodsListener.deleteCargoSku(skuId)) continue;
                    csDo.delete();
                }
            }
        }
    }

    public void updateSku(long creatorId, long skuId, String code, BigDecimal price) {
        CargoSkuDo csDo = this.getSku(skuId);
        Assert.notNull((Object)csDo, (String)"\u66f4\u65b0SKU\u9519\u8bef");
        csDo.setCode(code);
        csDo.setPrice(price);
        csDo.setUpdateBy(creatorId);
        csDo.update();
    }

    public CargoSkuDo addSku(long creatorId, String code, BigDecimal price, long[] skuItems) {
        CargoSkuDo csDo;
        block2: {
            this.checkSkuItems(skuItems);
            csDo = this.cargoSkuRepository.create(creatorId, this.id, code, price);
            try {
                csDo.insert();
            }
            catch (Exception e) {
                if (!(e instanceof BatchUpdateException) && !(e instanceof DuplicateKeyException)) break block2;
                throw new RuntimeException("\u8d27\u54c1\u4fdd\u5b58\u5931\u8d25\uff0cSKU\u7f16\u53f7[" + csDo.getCode() + "]\u5df2\u5b58\u5728");
            }
        }
        csDo.setSkuItems(creatorId, skuItems, this.id);
        return csDo;
    }

    public CargoSkuDo addSkuForMaterial(long creatorId, String code, BigDecimal price, long[] skuItems, String resourceId) {
        CargoSkuDo csDo;
        block3: {
            this.checkSkuItems(skuItems);
            csDo = this.cargoSkuRepository.create(creatorId, this.id, code, price);
            try {
                csDo.insert();
            }
            catch (Exception e) {
                if (!(e instanceof BatchUpdateException) && !(e instanceof DuplicateKeyException)) break block3;
                throw new RuntimeException("\u8d27\u54c1\u4fdd\u5b58\u5931\u8d25\uff0cSKU\u7f16\u53f7[" + csDo.getCode() + "]\u5df2\u5b58\u5728");
            }
        }
        csDo.deleteItems();
        for (long skuItem : skuItems) {
            this.cargoSkuItemRepository.insertSelectedSkuItem(creatorId, this.id, Long.parseLong(resourceId));
        }
        csDo.setSkuItemsForMaterial(creatorId, skuItems, this.id);
        return csDo;
    }

    private void checkSkuItems(long[] skuItems) {
        Assert.state((skuItems != null && skuItems.length > 0 ? 1 : 0) != 0, (String)"SKU\u9009\u5b9a\u9879\u9519\u8bef");
        List<CargoSkuTypeDo> skuTypeList = this.getSkuTypeList();
        Assert.state((skuTypeList.size() == skuItems.length ? 1 : 0) != 0, (String)"SKU\u9009\u5b9a\u9879\u89c4\u683c\u7c7b\u578b\u9519\u8bef");
        HashSet<Long> selectSkuTypeId = new HashSet<Long>();
        block0: for (CargoSkuTypeDo cstDo : skuTypeList) {
            boolean flag = false;
            for (long skuItem : skuItems) {
                for (CargoSkuItemDo csiDo : cstDo.getSkuItemList()) {
                    if (csiDo.getCargoBaseSkuItemId() != skuItem) continue;
                    flag = true;
                    selectSkuTypeId.add(cstDo.getId());
                    continue block0;
                }
            }
            Assert.state((boolean)flag, (String)"SKU\u9009\u5b9a\u9879\u4e0d\u5339\u914d");
        }
        Assert.state((selectSkuTypeId.size() == skuItems.length ? 1 : 0) != 0, (String)"SKU\u9009\u5b9a\u9879\u4e0d\u6b63\u786e");
    }

    public List<CargoSkuTypeDo> setSkuTypes(long creatorId, long ... skuTypeIds) {
        List<CargoSkuTypeDo> list = this.getSkuTypeList();
        block2: for (int i = list.size() - 1; i >= 0; --i) {
            long[] lArray = skuTypeIds;
            int n = lArray.length;
            for (int j = 0; j < n; ++j) {
                long skuTypeId = lArray[j];
                if (list.get(i).getCargoBaseSkuTypeId() == skuTypeId) continue block2;
            }
            list.remove(i).delete();
        }
        for (long skuTypeId : skuTypeIds) {
            CargoBaseSkuTypeDo cbstDo;
            boolean flag = false;
            CargoSkuTypeDo temp = null;
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i).getCargoBaseSkuTypeId() != skuTypeId) continue;
                flag = true;
                temp = list.get(i);
                break;
            }
            try {
                cbstDo = this.cargoBaseSkuTypeRepository.selectCargoBaseSkuTypeById(skuTypeId);
            }
            catch (Exception e) {
                cbstDo = null;
            }
            if (flag) continue;
            Assert.notNull((Object)cbstDo, (String)"\u6570\u636e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            temp = this.cargoSkuTypeRepository.create(creatorId, cbstDo.getId(), this.id, cbstDo.getName(), cbstDo.getType());
            temp.insert();
            list.add(temp);
        }
        return this.getSkuTypeList();
    }

    public void insert() {
        this.cargoRepository.insert(this);
    }

    public void update() {
        this.cargoRepository.update(this);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getSupplierId() {
        return this.supplierId;
    }

    public void setSupplierId(long supplierId) {
        this.supplierId = supplierId;
    }

    public CargoSupplierDo getSupplier() {
        return this.cargoSupplierRepository.getCargoSupplierDoById(this.supplierId);
    }

    public long getBrandId() {
        return this.brandId;
    }

    public void setBrandId(long brandId) {
        this.brandId = brandId;
    }

    public CargoBrandDo getBrand() {
        return this.cargoBrandRepository.getCargoBrandDoById(this.brandId);
    }

    public List<CargoClassifyDo> getClassifyList() {
        ArrayList<CargoClassifyDo> list = new ArrayList<CargoClassifyDo>();
        CargoClassifyDo classify = this.cargoClassifyRepository.findDoById(this.classifyId);
        list.add(classify);
        while (classify != null && classify.getParentId() != null) {
            if ((classify = this.cargoClassifyRepository.findDoById(classify.getParentId())) == null || classify.getName() == null || classify.getName().isEmpty()) continue;
            list.add(0, classify);
        }
        return list;
    }

    public long getClassifyId() {
        return this.classifyId;
    }

    public void setClassifyId(long classifyId) {
        this.classifyId = classifyId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCargoNo() {
        return this.cargoNo;
    }

    public void setCargoNo(String cargoNo) {
        this.cargoNo = cargoNo;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public long getSmallImageId() {
        return this.smallImageId;
    }

    public void setSmallImageId(long smallImageId) {
        this.smallImageId = smallImageId;
    }

    public long getShowImageGroupId() {
        return this.showImageGroupId;
    }

    public void setShowImageGroupId(long showImageGroupId) {
        this.showImageGroupId = showImageGroupId;
    }

    public long getDetailImageGroupId() {
        return this.detailImageGroupId;
    }

    public void setDetailImageGroupId(long detailImageGroupId) {
        this.detailImageGroupId = detailImageGroupId;
    }

    public void delete() {
        this.setSkuTypes(0L, new long[0]);
        this.cargoRepository.delete(this.id);
    }
}

