/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.stock.domain;

import com.club.framework.util.StringUtils;
import com.club.web.stock.domain.CargoInboundDetailDo;
import com.club.web.stock.domain.CargoSkuStockDo;
import com.club.web.stock.domain.repository.StockManagerRepository;
import com.club.web.stock.vo.CargoInboundDetailVo;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;

@Configurable
public class CargoInboundOrderDo {
    @Autowired
    StockManagerRepository repository;
    private Long id;
    private Integer status;
    private String sourceNo;
    private String remarks;
    private Date inboundTime;
    private Date subTime;
    private Date createTime;
    private long createBy;
    private String applyDesc;
    private String type;
    private List<CargoInboundDetailDo> detail;

    public String getApplyDesc() {
        return this.applyDesc;
    }

    public void setApplyDesc(String applyDesc) {
        this.applyDesc = applyDesc;
    }

    public List<CargoInboundDetailDo> getDetail() {
        return this.detail;
    }

    public void setDetail(List<CargoInboundDetailDo> detail) {
        this.detail = detail;
    }

    public long getCreateBy() {
        return this.createBy;
    }

    public void setCreateBy(long createBy) {
        this.createBy = createBy;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getSourceNo() {
        return this.sourceNo;
    }

    public void setSourceNo(String sourceNo) {
        this.sourceNo = sourceNo == null ? null : sourceNo.trim();
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks == null ? null : remarks.trim();
    }

    public Date getInboundTime() {
        return this.inboundTime;
    }

    public void setInboundTime(Date inboundTime) {
        this.inboundTime = inboundTime;
    }

    public Date getSubTime() {
        return this.subTime;
    }

    public void setSubTime(Date subTime) {
        this.subTime = subTime;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void save() throws Exception {
        this.repository.save(this);
        if (this.detail != null) {
            for (CargoInboundDetailDo inbound : this.detail) {
                inbound.save();
            }
        }
    }

    public void update(int status, String desc, long userId) throws Exception {
        List<CargoInboundDetailVo> inboundDetailList = null;
        CargoSkuStockDo stockDo = null;
        this.setStatus(status);
        this.setInboundTime(new Date());
        this.setSubTime(new Date());
        if (StringUtils.isNotEmpty(desc)) {
            this.setApplyDesc(desc);
        }
        this.repository.updateInboundOrderStatus(this);
        if (status == 3 && (inboundDetailList = this.repository.queryByInboundId(this.id)) != null && inboundDetailList.stream().count() > 0L) {
            for (CargoInboundDetailVo dv : inboundDetailList) {
                stockDo = this.repository.createStockObj(dv.getSkuId(), dv.getCount(), userId);
                if (stockDo == null) continue;
                if (stockDo.getFlag() == 0) {
                    stockDo.save();
                    continue;
                }
                stockDo.update(1, dv.getCount());
            }
        }
    }
}

