/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.stock.domain;

import com.club.web.stock.domain.BaseDo;
import com.club.web.stock.domain.CargoDo;
import com.club.web.stock.domain.CargoSkuItemDo;
import com.club.web.stock.domain.CargoSkuTypeDo;
import com.club.web.stock.domain.repository.CargoRepository;
import com.club.web.stock.domain.repository.CargoSkuItemRepository;
import com.club.web.stock.domain.repository.CargoSkuRepository;
import com.club.web.stock.domain.repository.CargoSkuTypeRepository;
import com.club.web.stock.domain.repository.StockManagerRepository;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.util.Assert;

@Configurable
public class CargoSkuDo
extends BaseDo {
    private long id;
    private long cargoId;
    private String code;
    private BigDecimal price;
    @Autowired
    private CargoRepository cargoRepository;
    @Autowired
    private CargoSkuRepository cargoSkuRepository;
    @Autowired
    private CargoSkuItemRepository cargoSkuItemRepository;
    @Autowired
    private StockManagerRepository stockManagerRepository;
    @Autowired
    private CargoSkuTypeRepository cargoSkuTypeRepository;

    public CargoDo getCargo() {
        return this.cargoRepository.getCargoById(this.cargoId);
    }

    public List<CargoSkuItemDo> getItemList() {
        return this.cargoSkuItemRepository.getListBySkuId(this.id);
    }

    public void delete() {
        this.deleteItems();
        this.cargoSkuRepository.delete(this.id);
    }

    public void update() {
        this.cargoSkuRepository.update(this);
    }

    public void insert() {
        this.cargoSkuRepository.insert(this);
    }

    public void deleteItems() {
        this.cargoSkuItemRepository.deleteSelectedItemsBySkuId(this.id);
    }

    public List<CargoSkuItemDo> setSkuItems(long creatorId, long[] skuItems, long resourceId) {
        this.deleteItems();
        CargoDo cDo = this.cargoRepository.getCargoById(this.cargoId);
        for (long skuItem : skuItems) {
            CargoSkuItemDo csiDo = cDo.getSkuItem(skuItem);
            Assert.notNull((Object)csiDo, (String)"\u6570\u636e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            this.cargoSkuItemRepository.insertSelectedSkuItem(creatorId, this.id, csiDo.getId());
        }
        return this.getItemList();
    }

    public List<CargoSkuItemDo> setSkuItemsForMaterial(long creatorId, long[] skuItems, long resourceId) {
        this.deleteItems();
        CargoDo cDo = new CargoDo();
        for (long skuItem : skuItems) {
            CargoSkuItemDo newcargosku = cDo.getSkuItem(skuItem, resourceId);
            Assert.notNull((Object)newcargosku, (String)"\u6570\u636e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            List<CargoSkuTypeDo> skuTypeList = this.cargoSkuTypeRepository.getListByCargoId(resourceId);
            for (CargoSkuTypeDo cstDo : skuTypeList) {
                for (CargoSkuItemDo csiDo : cstDo.getSkuItemList()) {
                    if (csiDo.getCargoBaseSkuItemId() != resourceId) continue;
                    newcargosku = csiDo;
                }
            }
            this.cargoSkuItemRepository.insertSelectedSkuItem(creatorId, this.id, newcargosku.getId());
        }
        return this.getItemList();
    }

    public int getTotalCout() {
        return this.stockManagerRepository.queryStockTotalBySkuId(this.id);
    }

    public String getSpecs() {
        List<CargoSkuItemDo> list = this.getItemList();
        StringBuilder sb = new StringBuilder();
        for (CargoSkuItemDo csido : list) {
            sb.append(csido.getName()).append(",");
        }
        if (sb.length() > 0) {
            return sb.deleteCharAt(sb.length() - 1).toString();
        }
        return "";
    }

    public long getId() {
        return this.id;
    }

    public long getCargoId() {
        return this.cargoId;
    }

    public String getCode() {
        return this.code;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setCargoId(long cargoId) {
        this.cargoId = cargoId;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
}

