/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.stock.domain;

import com.club.web.stock.domain.CargoSkuStockLogDo;
import com.club.web.stock.domain.repository.StockManagerRepository;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;

@Configurable
public class CargoSkuStockDo {
    @Autowired
    StockManagerRepository repository;
    private Long id;
    private String goodsName;
    private Long cargoSkuId;
    private Integer outShelvesNo;
    private Integer onSalesNo;
    private Integer onPayNo;
    private Integer onSendNo;
    private Date createTime;
    private Long createBy;
    private Date updateTime;
    private Long updateBy;
    private Integer remainCount;
    private int flag;

    public Integer getRemainCount() {
        return this.remainCount;
    }

    public void setRemainCount(Integer remainCount) {
        this.remainCount = remainCount;
    }

    public int getFlag() {
        return this.flag;
    }

    public void setFlag(int flag) {
        this.flag = flag;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getCargoSkuId() {
        return this.cargoSkuId;
    }

    public void setCargoSkuId(Long cargoSkuId) {
        this.cargoSkuId = cargoSkuId;
    }

    public Integer getOutShelvesNo() {
        return this.outShelvesNo;
    }

    public void setOutShelvesNo(Integer outShelvesNo) {
        this.outShelvesNo = outShelvesNo;
    }

    public Integer getOnSalesNo() {
        return this.onSalesNo;
    }

    public void setOnSalesNo(Integer onSalesNo) {
        this.onSalesNo = onSalesNo;
    }

    public Integer getOnPayNo() {
        return this.onPayNo;
    }

    public void setOnPayNo(Integer onPayNo) {
        this.onPayNo = onPayNo;
    }

    public Integer getOnSendNo() {
        return this.onSendNo;
    }

    public void setOnSendNo(Integer onSendNo) {
        this.onSendNo = onSendNo;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Long getCreateBy() {
        return this.createBy;
    }

    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Long getUpdateBy() {
        return this.updateBy;
    }

    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public String getGoodsName() {
        return this.goodsName;
    }

    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    public void save() throws Exception {
        this.repository.save(this);
        try {
            CargoSkuStockLogDo stockLog = this.repository.createStockLogObj(this, 1, this.id, this.getOutShelvesNo());
            if (stockLog != null) {
                stockLog.save();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void update(int status, int count) throws Exception {
        this.repository.updateStock(this);
        try {
            CargoSkuStockLogDo stockLog = this.repository.createStockLogObj(this, status, this.id, count);
            if (stockLog != null) {
                stockLog.save();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void update(int count, int variable, long userId) throws Exception {
        this.setRemainCount(count);
        this.setOutShelvesNo(this.getOutShelvesNo() + variable);
        this.setUpdateBy(userId);
        this.setUpdateTime(new Date());
        this.repository.updateStock(this);
        try {
            CargoSkuStockLogDo stockLog = this.repository.createStockLogObj(this, 7, this.id, count);
            if (stockLog != null) {
                stockLog.save();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void update(int variable_pay, int variable_send, int truePay, int trueSend, long userId) throws Exception {
        this.setOnSalesNo(this.getOnSalesNo() - (variable_pay + variable_send));
        this.setOnPayNo(truePay);
        this.setOnSendNo(trueSend);
        this.setUpdateBy(userId);
        this.setUpdateTime(new Date());
        this.repository.updateStock(this);
    }

    public void upate(int count, long userId, int status) throws Exception {
        if (status == 0) {
            this.setOutShelvesNo(this.getOutShelvesNo() - count);
            this.setOnSalesNo(this.getOnSalesNo() + count);
        } else if (status == 1) {
            this.setOutShelvesNo(this.getOutShelvesNo() + count);
            this.setOnSalesNo(this.getOnSalesNo() - count);
        }
        this.setUpdateBy(userId);
        this.setUpdateTime(new Date());
        this.repository.updateStock(this);
        try {
            CargoSkuStockLogDo stockLog = this.repository.createStockLogObj(this, status + 2, this.id, count);
            if (stockLog != null) {
                stockLog.save();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updatePackage(int status, int count) throws Exception {
        this.repository.updatePackageStock(this);
        try {
            CargoSkuStockLogDo stockLog = this.repository.createStockLogObj(this, status, this.id, count);
            if (stockLog != null) {
                stockLog.save();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

