/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.stock.service.impl;

import com.club.framework.util.BeanUtils;
import com.club.web.image.service.ImageService;
import com.club.web.image.service.vo.ImageVo;
import com.club.web.stock.domain.CargoBaseSkuItemDo;
import com.club.web.stock.domain.repository.CargoBaseSkuItemRepository;
import com.club.web.stock.service.CargoBaseSkuItemService;
import com.club.web.stock.service.impl.CargoBaseSkuTypeServiceImpl;
import com.club.web.stock.vo.CargoBaseSkuItemVo;
import com.club.web.util.IdGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="cargoBaseSkuItemService")
public class CargoBaseSkuItemServiceImpl
implements CargoBaseSkuItemService {
    private Logger logger = LoggerFactory.getLogger(CargoBaseSkuTypeServiceImpl.class);
    @Autowired
    CargoBaseSkuItemRepository cargoBaseSkuItemRepository;
    @Autowired
    ImageService imageService;

    @Override
    public CargoBaseSkuItemVo addBaseSkuItem(CargoBaseSkuItemVo baseSkuItem) {
        CargoBaseSkuItemDo cargoBaseSkuItemDo = new CargoBaseSkuItemDo();
        BeanUtils.copyProperties(baseSkuItem, cargoBaseSkuItemDo);
        cargoBaseSkuItemDo.setId(IdGenerator.getDefault().nextId());
        cargoBaseSkuItemDo.setBaseSkuTypeId(Long.valueOf(baseSkuItem.getBaseSkuTypeId()));
        baseSkuItem.setId(cargoBaseSkuItemDo.getId() + "");
        if ("3".equals(baseSkuItem.getCode()) && baseSkuItem.getValue() != null && !"".equals(baseSkuItem.getValue())) {
            try {
                ImageVo imageVo = this.imageService.saveImage(baseSkuItem.getValue());
                cargoBaseSkuItemDo.setValue(imageVo.getId() + "");
                baseSkuItem.setId(imageVo.getId() + "");
            }
            catch (Exception e) {
                this.logger.error("\u89c4\u683c\u9009\u9879\u65b0\u589e\u56fe\u7247\u5f02\u5e38:", (Throwable)e);
            }
        }
        if ("1".equals(baseSkuItem.getCode())) {
            cargoBaseSkuItemDo.setName(cargoBaseSkuItemDo.getValue());
        }
        try {
            this.cargoBaseSkuItemRepository.addBaseSkuItem(cargoBaseSkuItemDo);
        }
        catch (Exception e) {
            this.logger.error("\u65b0\u589e\u89c4\u683c\u9009\u9879\u5f02\u5e38:", (Throwable)e);
        }
        return baseSkuItem;
    }

    @Override
    public List<CargoBaseSkuItemVo> selectSkuItemBySkuTypeId(Long id, String type) {
        ArrayList<CargoBaseSkuItemVo> baseSkuItemVoLst = new ArrayList();
        if ("3".equals(type)) {
            try {
                baseSkuItemVoLst = this.cargoBaseSkuItemRepository.selectSkuItemAndImgBySkuTypeId(id);
            }
            catch (Exception e) {
                this.logger.error("\u6839\u636eID\u67e5\u8be2\u89c4\u683c\u9009\u9879\u5f02\u5e38:", (Throwable)e);
            }
        } else {
            try {
                baseSkuItemVoLst = this.cargoBaseSkuItemRepository.selectSkuItemBySkuTypeId(id);
            }
            catch (Exception e) {
                this.logger.error("\u6839\u636eID\u67e5\u8be2\u89c4\u683c\u9009\u9879\u5f02\u5e38:", (Throwable)e);
            }
        }
        return baseSkuItemVoLst;
    }

    @Override
    public Map<String, Object> deleteSkuItemByBaseSkuTypeId(Long baseSkuTypeId, Long id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            this.cargoBaseSkuItemRepository.deleteSkuItemByBaseSkuTypeId(baseSkuTypeId, id);
        }
        catch (Exception e) {
            result.put("success", false);
            result.put("msg", e.getMessage());
            this.logger.error("\u5220\u9664\u89c4\u683c\u9009\u9879\u5f02\u5e38:", (Throwable)e);
        }
        return result;
    }
}

