/*
 * Decompiled with CFR 0.152.
 */
package com.club.web.stock.service.impl;

import com.club.core.common.Page;
import com.club.web.stock.domain.CargoBaseSkuTypeDo;
import com.club.web.stock.domain.repository.CargoBaseSkuTypeRepository;
import com.club.web.stock.service.CargoBaseSkuTypeService;
import com.club.web.stock.vo.CargoBaseSkuTypeEnum;
import com.club.web.stock.vo.CargoBaseSkuTypeVo;
import com.club.web.util.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="cargoBaseSkuTypeService")
public class CargoBaseSkuTypeServiceImpl
implements CargoBaseSkuTypeService {
    private Logger logger = LoggerFactory.getLogger(CargoBaseSkuTypeServiceImpl.class);
    @Autowired
    CargoBaseSkuTypeRepository cargoBaseSkuTypeRepository;

    @Override
    public Map<String, Object> addBaseSkuType(CargoBaseSkuTypeVo baseSkuType) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        CargoBaseSkuTypeDo cargoBaseSkuTypeDo = this.cargoBaseSkuTypeRepository.voChangeDo(baseSkuType);
        try {
            result.put("success", true);
            result.put("msg", "\u65b0\u589e\u6210\u529f");
            this.cargoBaseSkuTypeRepository.addBaseSkuType(cargoBaseSkuTypeDo);
        }
        catch (Exception e) {
            result.put("success", false);
            result.put("msg", e.getMessage());
            this.logger.error("\u65b0\u589e\u89c4\u683c\u5f02\u5e38:", (Throwable)e);
        }
        return result;
    }

    @Override
    public Page<Map<String, Object>> selectBySkuNameAndSkuType(Page<Map<String, Object>> page, String skuName, String skuType) {
        Page<Map<String, Object>> result = new Page<Map<String, Object>>();
        List<Object> list = new ArrayList();
        Long count = 0L;
        result.setStart(page.getStart());
        result.setLimit(page.getLimit());
        skuName = skuName.isEmpty() ? null : "%" + skuName + "%";
        if ("0".equals(skuType) || skuType.isEmpty()) {
            skuType = null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuName", skuName);
        map.put("skuType", skuType);
        map.put("start", page.getStart());
        map.put("limit", page.getLimit());
        try {
            list = this.cargoBaseSkuTypeRepository.selectBySkuNameAndSkuType(map);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u89c4\u683c\u5f02\u5e38:", (Throwable)e);
        }
        for (CargoBaseSkuTypeVo cargoBaseSkuTypeVo : list) {
            cargoBaseSkuTypeVo.setTypeName(CargoBaseSkuTypeEnum.getTxt(cargoBaseSkuTypeVo.getType()));
        }
        try {
            count = this.cargoBaseSkuTypeRepository.queryCargoBaseSkuTypeCountPage(map);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u89c4\u683c\u7b14\u6570\u5f02\u5e38:", (Throwable)e);
        }
        result.setResultList(CommonUtil.listObjTransToListMap(list));
        result.setTotalRecords(count.intValue());
        return result;
    }

    @Override
    public Map<String, Object> editBaseSkuType(CargoBaseSkuTypeVo baseSkuType) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        CargoBaseSkuTypeDo cargoBaseSkuTypeDo = this.cargoBaseSkuTypeRepository.voChangeDo(baseSkuType);
        try {
            result.put("success", true);
            result.put("msg", "\u7f16\u8f91\u6210\u529f");
            this.cargoBaseSkuTypeRepository.editBaseSkuType(cargoBaseSkuTypeDo);
        }
        catch (Exception e) {
            result.put("success", false);
            result.put("msg", e.getMessage());
            this.logger.error("\u7f16\u8f91\u89c4\u683c\u5f02\u5e38:", (Throwable)e);
        }
        return result;
    }

    @Override
    public Map<String, Object> deleteBaseSkuType(String idStr) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String[] ids = idStr.split(",");
        try {
            for (String id : ids) {
                result.put("success", true);
                result.put("msg", "\u5220\u9664\u6210\u529f");
                this.cargoBaseSkuTypeRepository.deleteBaseSkuType(Long.parseLong(id));
            }
        }
        catch (Exception e) {
            result.put("success", false);
            result.put("msg", e.getMessage());
            this.logger.error("\u5220\u9664\u89c4\u683c\u5f02\u5e38:", (Throwable)e);
        }
        return result;
    }

    @Override
    public CargoBaseSkuTypeDo selectCargoBaseSkuTypeById(Long id) {
        CargoBaseSkuTypeDo cargoBaseSkuTypeDo = this.cargoBaseSkuTypeRepository.create();
        try {
            cargoBaseSkuTypeDo = this.cargoBaseSkuTypeRepository.selectCargoBaseSkuTypeById(id);
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636eID\u67e5\u8be2\u89c4\u683c\u5f02\u5e38:", (Throwable)e);
        }
        return cargoBaseSkuTypeDo;
    }

    @Override
    public List<CargoBaseSkuTypeVo> selectCargoBaseSkuTypeList() {
        ArrayList<CargoBaseSkuTypeVo> cargoBaseSkuTypeVoLst = new ArrayList();
        try {
            cargoBaseSkuTypeVoLst = this.cargoBaseSkuTypeRepository.selectCargoBaseSkuTypeList();
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u89c4\u683c\u6570\u7ec4\u5f02\u5e38:", (Throwable)e);
        }
        return cargoBaseSkuTypeVoLst;
    }
}

